/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.MoreTabsIcon;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayoutStrategy;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class SingleRowLayout
extends TabLayout {
    final JBTabsImpl myTabs;
    public SingleRowPassInfo myLastSingRowLayout;
    private final SingleRowLayoutStrategy myTop;
    private final SingleRowLayoutStrategy myLeft;
    private final SingleRowLayoutStrategy myBottom;
    private final SingleRowLayoutStrategy myRight;
    public final MoreTabsIcon myMoreIcon = new MoreTabsIcon(){

        @Override
        @Nullable
        protected Rectangle getIconRec() {
            return SingleRowLayout.this.myLastSingRowLayout != null ? SingleRowLayout.this.myLastSingRowLayout.moreRect : null;
        }

        @Override
        protected int getIconY(Rectangle iconRec) {
            int shift;
            switch (SingleRowLayout.this.myTabs.getTabsPosition()) {
                case bottom: {
                    shift = SingleRowLayout.this.myTabs.getActiveTabUnderlineHeight();
                    break;
                }
                case top: {
                    shift = -(SingleRowLayout.this.myTabs.getActiveTabUnderlineHeight() / 2);
                    break;
                }
                default: {
                    shift = 0;
                }
            }
            return super.getIconY(iconRec) + shift;
        }
    };
    public JPopupMenu myMorePopup;
    public final GhostComponent myLeftGhost = new GhostComponent(RowDropPolicy.first, RowDropPolicy.first);
    public final GhostComponent myRightGhost = new GhostComponent(RowDropPolicy.last, RowDropPolicy.first);
    private RowDropPolicy myRowDropPolicy = RowDropPolicy.first;

    @Override
    public boolean isSideComponentOnTabs() {
        return this.getStrategy().isSideComponentOnTabs();
    }

    @Override
    public ShapeTransform createShapeTransform(Rectangle labelRec) {
        return this.getStrategy().createShapeTransform(labelRec);
    }

    @Override
    public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
        return this.getStrategy().isDragOut(tabLabel, deltaX, deltaY);
    }

    public SingleRowLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
        this.myTop = new SingleRowLayoutStrategy.Top(this);
        this.myLeft = new SingleRowLayoutStrategy.Left(this);
        this.myBottom = new SingleRowLayoutStrategy.Bottom(this);
        this.myRight = new SingleRowLayoutStrategy.Right(this);
    }

    SingleRowLayoutStrategy getStrategy() {
        switch (this.myTabs.getPresentation().getTabsPosition()) {
            case top: {
                return this.myTop;
            }
            case left: {
                return this.myLeft;
            }
            case bottom: {
                return this.myBottom;
            }
            case right: {
                return this.myRight;
            }
        }
        return null;
    }

    protected boolean checkLayoutLabels(SingleRowPassInfo data) {
        boolean layoutLabels = true;
        if (!this.myTabs.myForcedRelayout && this.myLastSingRowLayout != null && this.myLastSingRowLayout.contentCount == this.myTabs.getTabCount() && this.myLastSingRowLayout.layoutSize.equals(this.myTabs.getSize()) && this.myLastSingRowLayout.scrollOffset == this.getScrollOffset()) {
            for (TabInfo each : data.myVisibleInfos) {
                TabLabel eachLabel = this.myTabs.myInfo2Label.get(each);
                if (!eachLabel.isValid()) {
                    layoutLabels = true;
                    break;
                }
                if (this.myTabs.getSelectedInfo() != each || eachLabel.getBounds().width == 0) continue;
                layoutLabels = false;
            }
        }
        return layoutLabels;
    }

    int getScrollOffset() {
        return 0;
    }

    public void scroll(int units) {
    }

    public int getScrollUnitIncrement() {
        return 0;
    }

    public void scrollSelectionInView() {
    }

    public LayoutPassInfo layoutSingleRow(List<TabInfo> visibleInfos) {
        SingleRowPassInfo data = new SingleRowPassInfo(this, visibleInfos);
        boolean layoutLabels = this.checkLayoutLabels(data);
        if (!layoutLabels) {
            data = this.myLastSingRowLayout;
        }
        TabInfo selected = this.myTabs.getSelectedInfo();
        this.prepareLayoutPassInfo(data, selected);
        this.myTabs.resetLayout(layoutLabels || this.myTabs.isHideTabs());
        if (layoutLabels && !this.myTabs.isHideTabs()) {
            data.position = this.getStrategy().getStartPosition(data) - this.getScrollOffset();
            this.recomputeToLayout(data);
            this.layoutLabelsAndGhosts(data);
            this.layoutMoreButton(data);
        }
        if (selected != null) {
            data.comp = new WeakReference<JComponent>(selected.getComponent());
            this.getStrategy().layoutComp(data);
        }
        this.updateMoreIconVisibility(data);
        data.tabRectangle = new Rectangle();
        if (data.toLayout.size() > 0) {
            TabLabel firstLabel = this.myTabs.myInfo2Label.get(data.toLayout.get(0));
            TabLabel lastLabel = this.findLastVisibleLabel(data);
            if (firstLabel != null && lastLabel != null) {
                data.tabRectangle.x = firstLabel.getBounds().x;
                data.tabRectangle.y = firstLabel.getBounds().y;
                data.tabRectangle.width = (int)lastLabel.getBounds().getMaxX() - data.tabRectangle.x;
                data.tabRectangle.height = (int)lastLabel.getBounds().getMaxY() - data.tabRectangle.y;
            }
        }
        this.myLastSingRowLayout = data;
        return data;
    }

    @Nullable
    protected TabLabel findLastVisibleLabel(SingleRowPassInfo data) {
        return this.myTabs.myInfo2Label.get(data.toLayout.get(data.toLayout.size() - 1));
    }

    protected void prepareLayoutPassInfo(SingleRowPassInfo data, TabInfo selected) {
        JBTabsImpl.Toolbar selectedToolbar;
        data.insets = this.myTabs.getLayoutInsets();
        if (this.myTabs.isHorizontalTabs()) {
            data.insets.left += this.myTabs.getFirstTabOffset();
        }
        data.hToolbar = new WeakReference<Object>(((selectedToolbar = this.myTabs.myInfo2Toolbar.get(selected)) != null && this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data.vToolbar = new WeakReference<Object>((selectedToolbar != null && !this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data.toFitLength = this.getStrategy().getToFitLength(data);
        if (this.myTabs.isGhostsAlwaysVisible()) {
            data.toFitLength -= this.myTabs.getGhostTabLength() * 2 + this.myTabs.getInterTabSpaceLength() * 2;
        }
    }

    protected void updateMoreIconVisibility(SingleRowPassInfo data) {
        int counter = (int)data.myVisibleInfos.stream().filter(this::isTabHidden).count();
        this.myMoreIcon.updateCounter(counter);
    }

    protected void layoutMoreButton(SingleRowPassInfo data) {
        if (data.toDrop.size() > 0) {
            data.moreRect = this.getStrategy().getMoreRect(data);
        }
    }

    protected void layoutLabelsAndGhosts(SingleRowPassInfo data) {
        if (data.firstGhostVisible || this.myTabs.isGhostsAlwaysVisible()) {
            data.firstGhost = this.getStrategy().getLayoutRect(data, data.position, this.myTabs.getGhostTabLength());
            this.myTabs.layout(this.myLeftGhost, data.firstGhost);
            data.position += this.getStrategy().getLengthIncrement(data.firstGhost.getSize()) + this.myTabs.getInterTabSpaceLength();
        }
        int deltaToFit = 0;
        if ((data.firstGhostVisible || data.lastGhostVisible) && data.requiredLength < data.toFitLength && this.getStrategy().canBeStretched()) {
            deltaToFit = (int)Math.floor((double)(data.toFitLength - data.requiredLength) / (double)data.toLayout.size());
        }
        int totalLength = 0;
        int positionStart = data.position;
        boolean layoutStopped = false;
        for (TabInfo eachInfo : data.toLayout) {
            TabLabel label = this.myTabs.myInfo2Label.get(eachInfo);
            if (layoutStopped) {
                label.setActionPanelVisible(false);
                Rectangle rec = this.getStrategy().getLayoutRect(data, 0, 0);
                this.myTabs.layout(label, rec);
                continue;
            }
            label.setActionPanelVisible(true);
            Dimension eachSize = label.getPreferredSize();
            boolean isLast = data.toLayout.indexOf(eachInfo) == data.toLayout.size() - 1;
            int length = !isLast || deltaToFit == 0 ? this.getStrategy().getLengthIncrement(eachSize) + deltaToFit : data.toFitLength - totalLength;
            boolean continueLayout = this.applyTabLayout(data, label, length, deltaToFit);
            data.position = this.getStrategy().getMaxPosition(label.getBounds());
            data.position += this.myTabs.getInterTabSpaceLength();
            totalLength = this.getStrategy().getMaxPosition(label.getBounds()) - positionStart + this.myTabs.getInterTabSpaceLength();
            if (continueLayout) continue;
            layoutStopped = true;
        }
        for (TabInfo eachInfo : data.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
        if (data.lastGhostVisible || this.myTabs.isGhostsAlwaysVisible()) {
            data.lastGhost = this.getStrategy().getLayoutRect(data, data.position, this.myTabs.getGhostTabLength());
            this.myTabs.layout(this.myRightGhost, data.lastGhost);
        }
    }

    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label, int length, int deltaToFit) {
        Rectangle rec = this.getStrategy().getLayoutRect(data, data.position, length);
        this.myTabs.layout(label, rec);
        label.setAlignmentToCenter((deltaToFit > 0 || this.myTabs.isEditorTabs()) && this.getStrategy().isToCenterTextWhenStretched());
        return true;
    }

    protected void recomputeToLayout(SingleRowPassInfo data) {
        this.calculateRequiredLength(data);
        while (data.requiredLength > data.toFitLength - data.position && data.toLayout.size() != 0) {
            TabInfo first = data.toLayout.get(0);
            TabInfo last = data.toLayout.get(data.toLayout.size() - 1);
            if (this.myRowDropPolicy == RowDropPolicy.first) {
                if (first != this.myTabs.getSelectedInfo()) {
                    this.processDrop(data, first, true);
                    continue;
                }
                if (last == this.myTabs.getSelectedInfo()) break;
                this.processDrop(data, last, false);
                continue;
            }
            if (last != this.myTabs.getSelectedInfo()) {
                this.processDrop(data, last, false);
                continue;
            }
            if (first == this.myTabs.getSelectedInfo()) break;
            this.processDrop(data, first, true);
        }
        for (int i = 1; i < data.myVisibleInfos.size() - 1; ++i) {
            TabInfo each = (TabInfo)data.myVisibleInfos.get(i);
            TabInfo prev = (TabInfo)data.myVisibleInfos.get(i - 1);
            TabInfo next = (TabInfo)data.myVisibleInfos.get(i + 1);
            if (data.toLayout.contains(each) && data.toDrop.contains(prev)) {
                this.myLeftGhost.setInfo(prev);
                continue;
            }
            if (!data.toLayout.contains(each) || !data.toDrop.contains(next)) continue;
            this.myRightGhost.setInfo(next);
        }
    }

    protected void calculateRequiredLength(SingleRowPassInfo data) {
        for (TabInfo eachInfo : data.myVisibleInfos) {
            data.requiredLength += this.getRequiredLength(eachInfo);
            if (this.myTabs.getTabsPosition() == JBTabsPosition.left || this.myTabs.getTabsPosition() == JBTabsPosition.right) {
                --data.requiredLength;
            }
            data.toLayout.add(eachInfo);
        }
    }

    protected int getRequiredLength(TabInfo eachInfo) {
        TabLabel label = this.myTabs.myInfo2Label.get(eachInfo);
        return this.getStrategy().getLengthIncrement(label != null ? label.getPreferredSize() : new Dimension()) + (this.myTabs.isEditorTabs() ? this.myTabs.getInterTabSpaceLength() : 0);
    }

    public boolean isTabHidden(TabInfo tabInfo) {
        return this.myLastSingRowLayout != null && this.myLastSingRowLayout.toDrop.contains(tabInfo);
    }

    private void processDrop(SingleRowPassInfo data, TabInfo info, boolean isFirstSide) {
        data.requiredLength -= this.getStrategy().getLengthIncrement(this.myTabs.myInfo2Label.get(info).getPreferredSize());
        data.toDrop.add(info);
        data.toLayout.remove(info);
        if (data.toDrop.size() == 1) {
            data.toFitLength -= data.moreRectAxisSize;
        }
        if (!data.firstGhostVisible && isFirstSide) {
            boolean bl = data.firstGhostVisible = !this.myTabs.isEditorTabs();
            if (!this.myTabs.isGhostsAlwaysVisible() && !this.myTabs.isEditorTabs()) {
                data.toFitLength -= this.myTabs.getGhostTabLength();
            }
        } else if (!data.lastGhostVisible && !isFirstSide) {
            boolean bl = data.lastGhostVisible = !this.myTabs.isEditorTabs();
            if (!this.myTabs.isGhostsAlwaysVisible() && !this.myTabs.isEditorTabs()) {
                data.toFitLength -= this.myTabs.getGhostTabLength();
            }
        }
    }

    @Override
    public int getDropIndexFor(Point point) {
        if (this.myLastSingRowLayout == null) {
            return -1;
        }
        int result2 = -1;
        Component c = this.myTabs.getComponentAt(point);
        if (c instanceof JBTabsImpl) {
            for (int i = 0; i < this.myLastSingRowLayout.myVisibleInfos.size() - 1; ++i) {
                boolean between;
                TabLabel first = this.myTabs.myInfo2Label.get(this.myLastSingRowLayout.myVisibleInfos.get(i));
                TabLabel second = this.myTabs.myInfo2Label.get(this.myLastSingRowLayout.myVisibleInfos.get(i + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean horizontal = this.getStrategy() instanceof SingleRowLayoutStrategy.Horizontal;
                if (horizontal) {
                    between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                } else {
                    boolean bl = between = firstBounds.getMaxY() < (double)point.y && secondBounds.getY() > (double)point.y && firstBounds.x < point.x && secondBounds.getMaxX() > (double)point.x;
                }
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastSingRowLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i = 0; i <= index; ++i) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.myLastSingRowLayout.myVisibleInfos.get(i))) continue;
                    --index;
                    break;
                }
                result2 = index;
            } else if (index < this.myLastSingRowLayout.myVisibleInfos.size()) {
                result2 = index;
            }
        } else if (c instanceof GhostComponent) {
            GhostComponent ghost = (GhostComponent)c;
            TabInfo info = ghost.myInfo;
            if (info != null) {
                int index = this.myLastSingRowLayout.myVisibleInfos.indexOf(info);
                result2 = (index += this.myLeftGhost == ghost ? -1 : 1) >= 0 && index < this.myLastSingRowLayout.myVisibleInfos.size() ? index : -1;
            } else {
                result2 = this.myLastSingRowLayout.myVisibleInfos.size() == 0 ? 0 : (this.myLeftGhost == ghost ? 0 : this.myLastSingRowLayout.myVisibleInfos.size() - 1);
            }
        }
        return result2;
    }

    public class GhostComponent
    extends JLabel {
        private TabInfo myInfo;

        private GhostComponent(final RowDropPolicy before, final RowDropPolicy after) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (JBTabsImpl.isSelectionClick(e, true) && GhostComponent.this.myInfo != null) {
                        SingleRowLayout.this.myRowDropPolicy = before;
                        SingleRowLayout.this.myTabs.select(GhostComponent.this.myInfo, true).doWhenDone(() -> SingleRowLayout.this.myRowDropPolicy = after);
                    } else {
                        MouseEvent event = SwingUtilities.convertMouseEvent(e.getComponent(), e, SingleRowLayout.this.myTabs);
                        SingleRowLayout.this.myTabs.processMouseEvent(event);
                    }
                }
            });
        }

        public void setInfo(@Nullable TabInfo info) {
            this.myInfo = info;
            this.setToolTipText(info != null ? info.getTooltipText() : null);
        }

        public void reset() {
            JBTabsImpl.resetLayout(this);
            this.setInfo(null);
        }
    }

    private static enum RowDropPolicy {
        first,
        last;

    }
}

