/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SuitableFontProvider;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntIntHashMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleColoredComponent
extends JComponent
implements Accessible,
ColoredTextContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.SimpleColoredComponent");
    public static final int FRAGMENT_ICON = -2;
    private final List<String> myFragments;
    private final List<TextLayout> myLayouts;
    private Font myLayoutFont;
    private final List<SimpleTextAttributes> myAttributes;
    private List<Object> myFragmentTags;
    private final TIntIntHashMap myFragmentAlignment;
    private Icon myIcon;
    private Insets myIpad;
    protected int myIconTextGap;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private Border myBorder;
    private int myMainTextLastIndex = -1;
    private final TIntIntHashMap myFragmentPadding;
    @JdkConstants.HorizontalAlignment
    private int myTextAlign = 2;
    private boolean myIconOpaque;
    private boolean myAutoInvalidate = !(this instanceof TreeCellRenderer);
    private boolean myIconOnTheRight;
    private boolean myTransparentIconBackground;

    public SimpleColoredComponent() {
        this.myFragments = new ArrayList<String>(3);
        this.myLayouts = new ArrayList<TextLayout>(3);
        this.myAttributes = new ArrayList<SimpleTextAttributes>(3);
        this.myIpad = JBUI.insets((int)1, (int)2);
        this.myIconTextGap = JBUI.scale((int)2);
        this.myBorder = JBUI.Borders.empty((int)1, (int)(UIUtil.isUnderWin10LookAndFeel() ? 0 : 1));
        this.myFragmentPadding = new TIntIntHashMap(10);
        this.myFragmentAlignment = new TIntIntHashMap(10);
        this.setOpaque(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        UISettings.setupComponentAntialiasing(this);
    }

    @NotNull
    public ColoredIterator iterator() {
        MyIterator myIterator = new MyIterator();
        if (myIterator == null) {
            SimpleColoredComponent.$$$reportNull$$$0(0);
        }
        return myIterator;
    }

    public boolean isIconOnTheRight() {
        return this.myIconOnTheRight;
    }

    public void setIconOnTheRight(boolean iconOnTheRight) {
        this.myIconOnTheRight = iconOnTheRight;
    }

    @NotNull
    public final SimpleColoredComponent append(@NotNull String fragment) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(1);
        }
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        SimpleColoredComponent simpleColoredComponent = this;
        if (simpleColoredComponent == null) {
            SimpleColoredComponent.$$$reportNull$$$0(2);
        }
        return simpleColoredComponent;
    }

    @Override
    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(4);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, int padding, @JdkConstants.HorizontalAlignment int align) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(5);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(6);
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
        this.appendTextPadding(padding, align);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(7);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(8);
        }
        this._append(fragment, attributes, isMainText);
        this.revalidateAndRepaint();
    }

    private synchronized void _append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(9);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(10);
        }
        this.myFragments.add(fragment);
        this.myAttributes.add(attributes);
        if (isMainText) {
            this.myMainTextLastIndex = this.myFragments.size() - 1;
        }
    }

    void revalidateAndRepaint() {
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    @Override
    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(12);
        }
        this._append(fragment, attributes, tag);
        this.revalidateAndRepaint();
    }

    private synchronized void _append(String fragment, SimpleTextAttributes attributes, Object tag) {
        this.append(fragment, attributes);
        if (this.myFragmentTags == null) {
            this.myFragmentTags = new ArrayList<Object>();
        }
        while (this.myFragmentTags.size() < this.myFragments.size() - 1) {
            this.myFragmentTags.add(null);
        }
        this.myFragmentTags.add(tag);
    }

    @Deprecated
    public synchronized void appendFixedTextFragmentWidth(int width) {
        this.appendTextPadding(width);
    }

    public synchronized void appendTextPadding(int padding) {
        this.appendTextPadding(padding, 2);
    }

    public synchronized void appendTextPadding(int padding, @JdkConstants.HorizontalAlignment int align) {
        int alignIndex = this.myFragments.size() - 1;
        this.myFragmentPadding.put(alignIndex, padding);
        this.myFragmentAlignment.put(alignIndex, align);
    }

    public void setTextAlign(@JdkConstants.HorizontalAlignment int align) {
        this.myTextAlign = align;
    }

    public void clear() {
        this._clear();
        this.revalidateAndRepaint();
    }

    private synchronized void _clear() {
        this.myIcon = null;
        this.myPaintFocusBorder = false;
        this.myFragments.clear();
        this.myLayouts.clear();
        this.myAttributes.clear();
        this.myFragmentTags = null;
        this.myMainTextLastIndex = -1;
        this.myFragmentPadding.clear();
    }

    public final Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public final void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        this.revalidateAndRepaint();
    }

    @NotNull
    public Insets getIpad() {
        Insets insets = this.myIpad;
        if (insets == null) {
            SimpleColoredComponent.$$$reportNull$$$0(13);
        }
        return insets;
    }

    public void setIpad(@NotNull Insets ipad) {
        if (ipad == null) {
            SimpleColoredComponent.$$$reportNull$$$0(14);
        }
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    public Border getMyBorder() {
        return this.myBorder;
    }

    public void setMyBorder(@Nullable Border border) {
        this.myBorder = border;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.computePreferredSize(false);
        if (dimension == null) {
            SimpleColoredComponent.$$$reportNull$$$0(15);
        }
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = this.computePreferredSize(false);
        if (dimension == null) {
            SimpleColoredComponent.$$$reportNull$$$0(16);
        }
        return dimension;
    }

    @Nullable
    public synchronized Object getFragmentTag(int index) {
        if (this.myFragmentTags != null && index < this.myFragmentTags.size()) {
            return this.myFragmentTags.get(index);
        }
        return null;
    }

    @NotNull
    public final synchronized Dimension computePreferredSize(boolean mainTextOnly) {
        int width = this.myIpad.left;
        if (this.myIcon != null) {
            width += this.myIcon.getIconWidth() + this.myIconTextGap;
        }
        JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
        width += borderInsets.left;
        Font font = this.getBaseFont();
        width = (int)((float)width + this.computeTextWidth(font, mainTextOnly));
        width += this.myIpad.right + borderInsets.right;
        Insets insets = this.getInsets();
        if (insets != null) {
            width += insets.left + insets.right;
        }
        int height = this.computePreferredHeight();
        Dimension dimension = new Dimension(width, height);
        if (dimension == null) {
            SimpleColoredComponent.$$$reportNull$$$0(17);
        }
        return dimension;
    }

    final synchronized int computePreferredHeight() {
        int height = this.myIpad.top + this.myIpad.bottom;
        Font font = this.getBaseFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = Math.max(JBUI.scale((int)16), metrics.getHeight());
        JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
        height += this.myIcon == null ? textHeight : Math.max(this.myIcon.getIconHeight(), textHeight += borderInsets.top + borderInsets.bottom);
        Insets insets = this.getInsets();
        if (insets != null) {
            height += insets.top + insets.bottom;
        }
        return height;
    }

    private Rectangle computePaintArea() {
        Rectangle area = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.getInsets());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.myIpad);
        return area;
    }

    private float computeTextWidth(@NotNull Font font, boolean mainTextOnly) {
        if (font == null) {
            SimpleColoredComponent.$$$reportNull$$$0(18);
        }
        float result2 = 0.0f;
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            result2 += this.computeStringWidth(i, font);
            int fixedWidth = this.myFragmentPadding.get(i);
            if (fixedWidth > 0 && result2 < (float)fixedWidth) {
                result2 = fixedWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        return result2;
    }

    @NotNull
    private Font getBaseFont() {
        Font font = this.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        Font font2 = font;
        if (font2 == null) {
            SimpleColoredComponent.$$$reportNull$$$0(19);
        }
        return font2;
    }

    private TextLayout getTextLayout(int fragmentIndex, Font font, FontRenderContext frc) {
        TextLayout layout;
        if (this.getBaseFont() != this.myLayoutFont) {
            this.myLayouts.clear();
        }
        TextLayout textLayout = layout = fragmentIndex < this.myLayouts.size() ? this.myLayouts.get(fragmentIndex) : null;
        if (layout == null && SimpleColoredComponent.needFontFallback(font, this.myFragments.get(fragmentIndex))) {
            layout = this.createAndCacheTextLayout(fragmentIndex, font, frc);
        }
        return layout;
    }

    private void doDrawString(Graphics2D g, int fragmentIndex, float x, float y) {
        String text = this.myFragments.get(fragmentIndex);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        TextLayout layout = this.getTextLayout(fragmentIndex, g.getFont(), g.getFontRenderContext());
        if (layout != null) {
            layout.draw(g, x, y);
        } else {
            g.drawString(text, x, y);
        }
    }

    private float computeStringWidth(int fragmentIndex, Font font) {
        String text = this.myFragments.get(fragmentIndex);
        if (StringUtil.isEmpty((String)text)) {
            return 0.0f;
        }
        FontRenderContext fontRenderContext = this.getFontMetrics(font).getFontRenderContext();
        TextLayout layout = this.getTextLayout(fragmentIndex, font, fontRenderContext);
        return layout != null ? layout.getAdvance() : (float)font.getStringBounds(text, fontRenderContext).getWidth();
    }

    private TextLayout createAndCacheTextLayout(int fragmentIndex, Font basefont, FontRenderContext fontRenderContext) {
        String text = this.myFragments.get(fragmentIndex);
        AttributedString string = new AttributedString(text);
        int start = 0;
        int end = text.length();
        AttributedCharacterIterator it = string.getIterator(new AttributedCharacterIterator.Attribute[0], start, end);
        Font currentFont = basefont;
        int currentIndex = start;
        char c = it.first();
        while (c != '\uffff') {
            Font font = basefont;
            if (!font.canDisplay(c)) {
                SuitableFontProvider provider;
                SuitableFontProvider[] suitableFontProviderArray = (SuitableFontProvider[])SuitableFontProvider.EP_NAME.getExtensions();
                int n = suitableFontProviderArray.length;
                for (int i = 0; i < n && (font = (provider = suitableFontProviderArray[i]).getFontAbleToDisplay(c, basefont.getSize(), basefont.getStyle(), basefont.getFamily())) == null; ++i) {
                }
            }
            int i = it.getIndex();
            if (!Comparing.equal((Object)currentFont, (Object)font)) {
                if (i > currentIndex) {
                    string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, i);
                }
                currentFont = font;
                currentIndex = i;
            }
            c = it.next();
        }
        if (currentIndex < end) {
            string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, end);
        }
        TextLayout layout = new TextLayout(string.getIterator(), fontRenderContext);
        if (fragmentIndex >= this.myLayouts.size()) {
            this.myLayouts.addAll(Collections.nCopies(fragmentIndex - this.myLayouts.size() + 1, null));
        }
        this.myLayouts.set(fragmentIndex, layout);
        this.myLayoutFont = this.getBaseFont();
        return layout;
    }

    private static boolean needFontFallback(Font font, String text) {
        return font.canDisplayUpTo(text) != -1 && text.indexOf(65535) == -1;
    }

    public int findFragmentAt(int x) {
        float curX = this.myIpad.left;
        if (this.myIcon != null && !this.myIconOnTheRight) {
            int iconRight = this.myIcon.getIconWidth() + this.myIconTextGap;
            if (x < iconRight) {
                return -2;
            }
            curX += (float)iconRight;
        }
        Font font = this.getBaseFont();
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            float curWidth = this.computeStringWidth(i, font);
            if ((float)x >= curX && (float)x < curX + curWidth) {
                return i;
            }
            curX += curWidth;
            int fragmentPadding = this.myFragmentPadding.get(i);
            if (fragmentPadding <= 0 || !(curX < (float)fragmentPadding)) continue;
            curX = fragmentPadding;
        }
        if (this.myIcon != null && this.myIconOnTheRight && (float)x >= (curX += (float)this.myIconTextGap) && (float)x < curX + (float)this.myIcon.getIconWidth()) {
            return -2;
        }
        return -1;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        int index = this.findFragmentAt(x);
        return index < 0 ? null : this.getFragmentTag(index);
    }

    @NotNull
    protected JLabel formatToLabel(@NotNull JLabel label) {
        if (label == null) {
            SimpleColoredComponent.$$$reportNull$$$0(20);
        }
        label.setIcon(this.myIcon);
        if (!this.myFragments.isEmpty()) {
            StringBuilder text = new StringBuilder();
            text.append("<html><body style=\"white-space:nowrap\">");
            for (int i = 0; i < this.myFragments.size(); ++i) {
                String fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = this.myAttributes.get(i);
                Object tag = this.getFragmentTag(i);
                if (tag instanceof BrowserLauncherTag) {
                    SimpleColoredComponent.formatLink(text, fragment, attributes, ((BrowserLauncherTag)tag).myUrl);
                    continue;
                }
                SimpleColoredComponent.formatText(text, fragment, attributes);
            }
            text.append("</body></html>");
            label.setText(text.toString());
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            SimpleColoredComponent.$$$reportNull$$$0(21);
        }
        return jLabel;
    }

    static void formatText(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (builder == null) {
            SimpleColoredComponent.$$$reportNull$$$0(22);
        }
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(23);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(24);
        }
        if (!fragment.isEmpty()) {
            builder.append("<span");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</span>");
        }
    }

    static void formatLink(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull String url) {
        if (builder == null) {
            SimpleColoredComponent.$$$reportNull$$$0(25);
        }
        if (fragment == null) {
            SimpleColoredComponent.$$$reportNull$$$0(26);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(27);
        }
        if (url == null) {
            SimpleColoredComponent.$$$reportNull$$$0(28);
        }
        if (!fragment.isEmpty()) {
            builder.append("<a href=\"").append(StringUtil.replace((String)url, (String)"\"", (String)"%22")).append("\"");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</a>");
        }
    }

    private static String convertFragment(String fragment) {
        return StringUtil.escapeXml((String)fragment).replaceAll("\\\\n", "<br>");
    }

    private static void formatStyle(StringBuilder builder, SimpleTextAttributes attributes) {
        Color fgColor = attributes.getFgColor();
        Color bgColor = attributes.getBgColor();
        int style = attributes.getStyle();
        int pos = builder.length();
        if (fgColor != null) {
            builder.append("color:").append(ColorUtil.toHtmlColor((Color)fgColor)).append(';');
        }
        if (bgColor != null) {
            builder.append("background-color:").append(ColorUtil.toHtmlColor((Color)bgColor)).append(';');
        }
        if ((style & 1) != 0) {
            builder.append("font-weight:bold;");
        }
        if ((style & 2) != 0) {
            builder.append("font-style:italic;");
        }
        if ((style & 0x10) != 0) {
            builder.append("text-decoration:underline;");
        } else if ((style & 4) != 0) {
            builder.append("text-decoration:line-through;");
        }
        if (builder.length() > pos) {
            builder.insert(pos, " style=\"");
            builder.append('\"');
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            this._doPaint(g);
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), (Throwable)e);
            throw e;
        }
    }

    private synchronized void _doPaint(Graphics g) {
        SimpleColoredComponent.checkCanPaint(g);
        this.doPaint((Graphics2D)g);
    }

    protected void doPaint(Graphics2D g) {
        int offset = 0;
        Icon icon = this.myIcon;
        if (icon != null && !this.myIconOnTheRight) {
            this.doPaintIcon(g, icon, 0);
            offset += this.myIpad.left + icon.getIconWidth() + this.myIconTextGap;
        }
        this.doPaintTextBackground(g, offset);
        offset = this.doPaintText(g, offset, this.myFocusBorderAroundIcon || icon == null) + this.myIconTextGap;
        if (icon != null && this.myIconOnTheRight) {
            this.doPaintIcon(g, icon, offset);
        }
    }

    private void doPaintTextBackground(Graphics2D g, int offset) {
        if (this.isOpaque() || this.shouldDrawBackground()) {
            this.paintBackground(g, offset, this.getWidth() - offset, this.getHeight());
        }
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(x, 0, width, height);
    }

    protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon, int offset) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(29);
        }
        if (icon == null) {
            SimpleColoredComponent.$$$reportNull$$$0(30);
        }
        Container parent = this.getParent();
        Color iconBackgroundColor = null;
        if ((this.isOpaque() || this.isIconOpaque()) && !this.isTransparentIconBackground()) {
            iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
        }
        if (iconBackgroundColor != null) {
            g.setColor(iconBackgroundColor);
            g.fillRect(offset, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
        }
        this.paintIcon(g, icon, offset + this.myIpad.left);
    }

    protected int doPaintText(Graphics2D g, int textStart, boolean focusAroundIcon) {
        if (textStart == 0) {
            textStart = this.myIpad.left;
        }
        float offset = textStart;
        if (this.myBorder != null) {
            offset += (float)this.myBorder.getBorderInsets((Component)this).left;
        }
        offset += (float)this.getInsets().left;
        int height = this.getHeight();
        this.applyAdditionalHints(g);
        Font baseFont = this.getBaseFont();
        g.setFont(baseFont);
        offset += (float)this.computeTextAlignShift();
        int baseSize = baseFont.getSize();
        FontMetrics baseMetrics = g.getFontMetrics();
        Rectangle area = this.computePaintArea();
        int textBaseline = area.y + SimpleColoredComponent.getTextBaseLine(baseMetrics, area.height);
        boolean wasSmaller = false;
        class Frag {
            private final int index;
            private final float start;
            private final float end;
            private final float baseLine;
            private final Font font;
            private final Frag next;

            Frag(int index, float start, float end, @NotNull float baseLine, Font font, Frag next) {
                if (font == null) {
                    Frag.$$$reportNull$$$0(0);
                }
                this.index = index;
                this.start = start;
                this.end = end;
                this.baseLine = baseLine;
                this.font = font;
                this.next = next;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/ui/SimpleColoredComponent$1Frag", "<init>"));
            }
        }
        Frag secondPassFrag = null;
        for (int i = 0; i < this.myFragments.size(); ++i) {
            float endOffset;
            Color color;
            Color bgColor;
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            Font font = g.getFont();
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            g.setFont(font);
            FontMetrics metrics = g.getFontMetrics(font);
            float fragmentWidth = this.computeStringWidth(i, font);
            int fragmentPadding = this.myFragmentPadding.get(i);
            boolean secondPass = attributes.isSearchMatch() || attributes.isClickable();
            Color color2 = bgColor = secondPass ? null : attributes.getBgColor();
            if ((attributes.isOpaque() || this.isOpaque()) && bgColor != null) {
                g.setColor(bgColor);
                g.fillRect((int)offset, 0, (int)fragmentWidth, height);
            }
            if ((color = attributes.getFgColor()) == null) {
                color = this.getForeground();
            }
            if (!this.isEnabled()) {
                color = UIUtil.getInactiveTextColor();
            }
            g.setColor(color);
            int fragmentAlignment = this.myFragmentAlignment.get(i);
            if (fragmentPadding > 0 && (float)fragmentPadding > fragmentWidth) {
                endOffset = fragmentPadding;
                if (fragmentAlignment == 4 || fragmentAlignment == 11) {
                    offset = (float)fragmentPadding - fragmentWidth;
                }
            } else {
                endOffset = offset + fragmentWidth;
            }
            if (!secondPass) {
                if (this.shouldDrawDimmed()) {
                    color = ColorUtil.dimmer((Color)color);
                }
                g.setColor(color);
                this.doDrawString(g, i, offset, textBaseline);
                g.setStroke(g.getStroke());
                this.drawTextAttributes(g, attributes, (int)offset, textBaseline, (int)fragmentWidth, metrics, font);
            }
            if (secondPass) {
                secondPassFrag = new Frag(i, offset, offset + fragmentWidth, textBaseline, font, secondPassFrag);
            }
            offset = endOffset;
        }
        if (this.myPaintFocusBorder && this.myBorder != null) {
            int width = this.getWidth();
            if (focusAroundIcon) {
                this.myBorder.paintBorder(this, g, 0, 0, width, height);
            } else {
                this.myBorder.paintBorder(this, g, textStart, 0, width - textStart, height);
            }
        }
        Frag frag = secondPassFrag;
        while (frag != null) {
            block23: {
                Object fgColor;
                SimpleTextAttributes attributes;
                String text;
                float baseline;
                float x2;
                float x1;
                block22: {
                    block21: {
                        x1 = frag.start;
                        x2 = frag.end;
                        baseline = frag.baseLine;
                        text = this.myFragments.get(frag.index);
                        attributes = this.myAttributes.get(frag.index);
                        if (!attributes.isSearchMatch()) break block21;
                        fgColor = new JBColor((Color)Gray._50, (Color)Gray._0);
                        UIUtil.drawSearchMatch((Graphics2D)g, (float)x1, (float)x2, (int)height);
                        break block22;
                    }
                    if (!attributes.isClickable()) break block23;
                    fgColor = (Color)ObjectUtils.notNull((Object)attributes.getFgColor(), (Object)UIUtil.getLabelForeground());
                    Color bg = (Color)ObjectUtils.notNull((Object)attributes.getBgColor(), (Object)UIUtil.getLabelBackground());
                    SimpleColoredComponent.drawClickableFrag(g, x1, x2, height, bg);
                }
                g.setFont(frag.font);
                g.setColor((Color)fgColor);
                g.drawString(text, x1, baseline);
                int fragmentWidth = (int)(x2 - x1);
                this.drawTextAttributes(g, attributes, (int)x1, (int)baseline, fragmentWidth, g.getFontMetrics(), g.getFont());
            }
            frag = frag.next;
        }
        return (int)offset;
    }

    private static void drawClickableFrag(Graphics2D g, float x1, float x2, int height, Color bg) {
        boolean darcula = UIUtil.isUnderDarcula();
        Color c1 = darcula ? bg.brighter() : bg;
        Color c2 = darcula ? bg : bg.darker();
        GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)g);
        g.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g.setPaint(UIUtil.getGradientPaint((float)(x1 + 1.0f), (float)2.0f, (Color)c1, (float)(x1 + 1.0f), (float)(height - 5), (Color)c2));
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x1 + 1.0f, 2.0f, x2 - x1 - 2.0f, height - 4, 4.0f, 4.0f);
        g.fill(shape);
        g.setColor((Color)new JBColor((Color)Gray.xCC, new Color(7699328)));
        g.draw(shape);
        c.restore();
    }

    private void drawTextAttributes(@NotNull Graphics2D g, @NotNull SimpleTextAttributes attributes, int offset, int textBaseline, int fragmentWidth, @NotNull FontMetrics metrics, Font font) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(31);
        }
        if (attributes == null) {
            SimpleColoredComponent.$$$reportNull$$$0(32);
        }
        if (metrics == null) {
            SimpleColoredComponent.$$$reportNull$$$0(33);
        }
        if (attributes.isStrikeout()) {
            EffectPainter.STRIKE_THROUGH.paint(g, offset, textBaseline, fragmentWidth, SimpleColoredComponent.getCharHeight(g), font);
        }
        if (attributes.isWaved()) {
            if (attributes.getWaveColor() != null) {
                g.setColor(attributes.getWaveColor());
            }
            EffectPainter.WAVE_UNDERSCORE.paint(g, offset, textBaseline + 1, fragmentWidth, Math.max(2, metrics.getDescent()), font);
        }
        if (attributes.isUnderline()) {
            EffectPainter.LINE_UNDERSCORE.paint(g, offset, textBaseline, fragmentWidth, metrics.getDescent(), font);
        }
        if (attributes.isBoldDottedLine()) {
            int dottedAt = SystemInfo.isMac ? textBaseline : textBaseline + 1;
            Color lineColor = attributes.getWaveColor();
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)offset, (int)(offset + fragmentWidth), (int)dottedAt, (Color)attributes.getBgColor(), (Color)lineColor, (boolean)this.isOpaque());
        }
    }

    private static int getCharHeight(Graphics g) {
        return g.getFontMetrics().charWidth('a');
    }

    private int computeTextAlignShift() {
        if (this.myTextAlign == 2 || this.myTextAlign == 10) {
            return 0;
        }
        int componentWidth = this.getSize().width;
        int excessiveWidth = componentWidth - this.computePreferredSize((boolean)false).width;
        if (excessiveWidth <= 0) {
            return 0;
        }
        if (this.myTextAlign == 0) {
            return excessiveWidth / 2;
        }
        if (this.myTextAlign == 4 || this.myTextAlign == 11) {
            return excessiveWidth;
        }
        return 0;
    }

    protected boolean shouldDrawMacShadow() {
        return false;
    }

    protected boolean shouldDrawDimmed() {
        return false;
    }

    protected boolean shouldDrawBackground() {
        return false;
    }

    protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(34);
        }
        if (icon == null) {
            SimpleColoredComponent.$$$reportNull$$$0(35);
        }
        Rectangle area = this.computePaintArea();
        icon.paintIcon(this, g, offset, area.y + (area.height - icon.getIconHeight() + 1) / 2);
    }

    protected void applyAdditionalHints(@NotNull Graphics2D g) {
        if (g == null) {
            SimpleColoredComponent.$$$reportNull$$$0(36);
        }
        UISettings.setupAntialiasing(g);
    }

    @Override
    public int getBaseline(int width, int height) {
        super.getBaseline(width, height);
        return SimpleColoredComponent.getTextBaseLine(this.getFontMetrics(this.getFont()), height);
    }

    public boolean isTransparentIconBackground() {
        return this.myTransparentIconBackground;
    }

    public void setTransparentIconBackground(boolean transparentIconBackground) {
        this.myTransparentIconBackground = transparentIconBackground;
    }

    public static int getTextBaseLine(@NotNull FontMetrics metrics, int height) {
        if (metrics == null) {
            SimpleColoredComponent.$$$reportNull$$$0(37);
        }
        return (height - metrics.getHeight()) / 2 + metrics.getAscent() + (SystemInfo.isJetBrainsJvm ? metrics.getLeading() : 0);
    }

    private static void checkCanPaint(Graphics g) {
        if (UIUtil.isPrinting((Graphics)g)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertIsDispatchThread();
        } else if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException(Thread.currentThread().toString());
        }
    }

    @NotNull
    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            SimpleColoredComponent.$$$reportNull$$$0(38);
        }
        return string;
    }

    protected void setBorderInsets(Insets insets) {
        this.myBorder = new JBEmptyBorder(insets);
        this.revalidateAndRepaint();
    }

    @NotNull
    public CharSequence getCharSequence(boolean mainOnly) {
        List<String> fragments = mainOnly && this.myMainTextLastIndex > -1 && this.myMainTextLastIndex + 1 < this.myFragments.size() ? this.myFragments.subList(0, this.myMainTextLastIndex + 1) : this.myFragments;
        String string = StringUtil.join(fragments, (String)"");
        if (string == null) {
            SimpleColoredComponent.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getCharSequence(false).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(@NotNull Runnable runnable, boolean autoInvalidate) {
        if (runnable == null) {
            SimpleColoredComponent.$$$reportNull$$$0(40);
        }
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSimpleColoredComponent();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SimpleColoredComponent";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 24: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipad";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 29: 
            case 31: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SimpleColoredComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIpad";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSize";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computePreferredSize";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFont";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "formatToLabel";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "logSwingPath";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "_append";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIpad";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeTextWidth";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "formatToLabel";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "formatLink";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doPaintIcon";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "drawTextAttributes";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "paintIcon";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalHints";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTextBaseLine";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIterator
    implements ColoredIterator {
        int myIndex = -1;
        int myOffset;
        int myEndOffset;

        private MyIterator() {
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        @Override
        @NotNull
        public String getFragment() {
            String string = (String)SimpleColoredComponent.this.myFragments.get(this.myIndex);
            if (string == null) {
                MyIterator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            SimpleTextAttributes simpleTextAttributes = (SimpleTextAttributes)SimpleColoredComponent.this.myAttributes.get(this.myIndex);
            if (simpleTextAttributes == null) {
                MyIterator.$$$reportNull$$$0(1);
            }
            return simpleTextAttributes;
        }

        @Override
        public int split(int offset, @NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                MyIterator.$$$reportNull$$$0(2);
            }
            if (offset < 0 || offset > this.myEndOffset - this.myOffset) {
                throw new IllegalArgumentException(offset + " is not within [0, " + (this.myEndOffset - this.myOffset) + "]");
            }
            if (offset == this.myEndOffset - this.myOffset) {
                SimpleColoredComponent.this.myAttributes.set(this.myIndex, attributes);
            } else if (offset > 0) {
                String text = this.getFragment();
                SimpleColoredComponent.this.myFragments.set(this.myIndex, text.substring(0, offset));
                SimpleColoredComponent.this.myAttributes.add(this.myIndex, attributes);
                SimpleColoredComponent.this.myFragments.add(this.myIndex + 1, text.substring(offset));
                if (SimpleColoredComponent.this.myFragmentTags != null && SimpleColoredComponent.this.myFragmentTags.size() > this.myIndex) {
                    SimpleColoredComponent.this.myFragmentTags.add(this.myIndex, SimpleColoredComponent.this.myFragments.get(this.myIndex));
                }
                if (this.myIndex < SimpleColoredComponent.this.myLayouts.size()) {
                    SimpleColoredComponent.this.myLayouts.set(this.myIndex, null);
                }
                if (this.myIndex + 1 < SimpleColoredComponent.this.myLayouts.size()) {
                    SimpleColoredComponent.this.myLayouts.add(this.myIndex + 1, null);
                }
                ++this.myIndex;
            }
            this.myOffset += offset;
            return this.myOffset;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex + 1 < SimpleColoredComponent.this.myFragments.size();
        }

        @Override
        public String next() {
            ++this.myIndex;
            this.myOffset = this.myEndOffset;
            String text = this.getFragment();
            this.myEndOffset += text.length();
            return text;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/SimpleColoredComponent$MyIterator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/SimpleColoredComponent$MyIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "split";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ColoredIterator
    extends Iterator<String> {
        public int getOffset();

        public int getEndOffset();

        @NotNull
        public String getFragment();

        @NotNull
        public SimpleTextAttributes getTextAttributes();

        public int split(int var1, @NotNull SimpleTextAttributes var2);
    }

    public static class BrowserLauncherTag
    implements Runnable {
        private final String myUrl;

        public BrowserLauncherTag(@NotNull String url) {
            if (url == null) {
                BrowserLauncherTag.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse(this.myUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ui/SimpleColoredComponent$BrowserLauncherTag", "<init>"));
        }
    }

    protected class AccessibleSimpleColoredComponent
    extends JComponent.AccessibleJComponent {
        protected AccessibleSimpleColoredComponent() {
            super(SimpleColoredComponent.this);
        }

        @Override
        public String getAccessibleName() {
            return SimpleColoredComponent.this.getCharSequence(false).toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

