/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.differ;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;

public abstract class DifferBase
implements Differ {
    protected final Project myProject;
    protected final String myOrigText;
    protected final CodeStyleSettings mySettings;
    protected final PsiFile myFile;

    public DifferBase(Project project, PsiFile file, CodeStyleSettings settings) {
        this.myProject = project;
        this.myFile = file;
        this.myOrigText = this.myFile.getText();
        this.mySettings = settings;
    }

    public abstract String reformattedText();

    @Override
    public int getDifference(ValuesExtractionResult container) {
        ValuesExtractionResult orig = container.apply(true);
        String newText = this.reformattedText();
        int result2 = Utils.getDiff(this.mySettings.getCommonSettings(this.myFile.getLanguage()).getIndentOptions(), this.myOrigText, newText);
        orig.apply(false);
        return result2;
    }
}

