/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class DiffNavigationContext {
    private final String myTargetString;
    private final Iterable<String> myPreviousLinesIterable;

    public DiffNavigationContext(@NotNull Iterable<String> previousLinesIterable, @NotNull String targetString) {
        if (previousLinesIterable == null) {
            DiffNavigationContext.$$$reportNull$$$0(0);
        }
        if (targetString == null) {
            DiffNavigationContext.$$$reportNull$$$0(1);
        }
        this.myPreviousLinesIterable = previousLinesIterable;
        this.myTargetString = targetString;
    }

    public Iterable<String> getPreviousLinesIterable() {
        return this.myPreviousLinesIterable;
    }

    public String getTargetString() {
        return this.myTargetString;
    }

    public int contextMatchCheck(@NotNull Iterator<Pair<Integer, CharSequence>> changedLinesIterator) {
        Iterator<String> iterator;
        if (changedLinesIterator == null) {
            DiffNavigationContext.$$$reportNull$$$0(2);
        }
        if ((iterator = this.getPreviousLinesIterable().iterator()).hasNext()) {
            CharSequence contextLine = iterator.next();
            while (changedLinesIterator.hasNext()) {
                Pair<Integer, CharSequence> pair = changedLinesIterator.next();
                if (!StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)pair.getSecond()), (CharSequence)contextLine)) continue;
                if (!iterator.hasNext()) break;
                contextLine = iterator.next();
            }
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (!changedLinesIterator.hasNext()) {
            return -1;
        }
        while (changedLinesIterator.hasNext()) {
            Pair<Integer, CharSequence> pair = changedLinesIterator.next();
            if (!StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)pair.getSecond()), (CharSequence)this.getTargetString())) continue;
            return (Integer)pair.getFirst();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousLinesIterable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetString";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedLinesIterator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/DiffNavigationContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contextMatchCheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

