/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationBase
extends UserDataHolderBase
implements RunConfiguration,
TargetAwareRunProfile {
    private static final String PREDEFINED_LOG_FILE_ELEMENT = "predefined_log_file";
    private static final String SHOW_CONSOLE_ON_STD_OUT = "show_console_on_std_out";
    private static final String SHOW_CONSOLE_ON_STD_ERR = "show_console_on_std_err";
    @Nullable
    private final ConfigurationFactory myFactory;
    private final Project myProject;
    private String myName;
    private RunConfigurationOptions myOptions;
    private List<PredefinedLogFile> myPredefinedLogFiles;
    private List<BeforeRunTask> myBeforeRunTasks;

    protected RunConfigurationBase(@NotNull Project project, @Nullable ConfigurationFactory factory, String name) {
        if (project == null) {
            RunConfigurationBase.$$$reportNull$$$0(0);
        }
        this.myOptions = this.createOptions();
        this.myPredefinedLogFiles = new SmartList();
        this.myBeforeRunTasks = Collections.emptyList();
        this.myProject = project;
        this.myFactory = factory;
        this.myName = name;
    }

    @NotNull
    private RunConfigurationOptions createOptions() {
        RunConfigurationOptions runConfigurationOptions = (RunConfigurationOptions)ReflectionUtil.newInstance(this.getOptionsClass());
        if (runConfigurationOptions == null) {
            RunConfigurationBase.$$$reportNull$$$0(1);
        }
        return runConfigurationOptions;
    }

    protected RunConfigurationOptions getOptions() {
        return this.myOptions;
    }

    @Override
    @Transient
    @NotNull
    public List<BeforeRunTask> getBeforeRunTasks() {
        List<BeforeRunTask> list = this.myBeforeRunTasks;
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setBeforeRunTasks(@NotNull List<BeforeRunTask> value) {
        if (value == null) {
            RunConfigurationBase.$$$reportNull$$$0(3);
        }
        this.myBeforeRunTasks = value;
    }

    @Override
    @Nullable
    public final ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public final void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RunConfigurationBase.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myFactory == null ? null : this.myFactory.getIcon();
    }

    @Override
    @Transient
    public final String getName() {
        return this.myName;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
        if (runner == null) {
            RunConfigurationBase.$$$reportNull$$$0(5);
        }
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
    }

    @Override
    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (target == null) {
            RunConfigurationBase.$$$reportNull$$$0(6);
        }
        return true;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public RunConfiguration clone() {
        RunConfigurationBase runConfiguration = (RunConfigurationBase)super.clone();
        runConfiguration.myPredefinedLogFiles = new ArrayList<PredefinedLogFile>(this.myPredefinedLogFiles);
        runConfiguration.myOptions = this.createOptions();
        runConfiguration.myOptions.copyFrom(this.myOptions);
        this.copyCopyableDataTo(runConfiguration);
        this.myBeforeRunTasks = this.myBeforeRunTasks.isEmpty() ? Collections.emptyList() : new SmartList(this.myBeforeRunTasks);
        return runConfiguration;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        return null;
    }

    public void removeAllPredefinedLogFiles() {
        this.myPredefinedLogFiles.clear();
    }

    public void addPredefinedLogFile(@NotNull PredefinedLogFile predefinedLogFile) {
        if (predefinedLogFile == null) {
            RunConfigurationBase.$$$reportNull$$$0(7);
        }
        this.myPredefinedLogFiles.add(predefinedLogFile);
    }

    @NotNull
    public List<PredefinedLogFile> getPredefinedLogFiles() {
        List<PredefinedLogFile> list = this.myPredefinedLogFiles;
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public ArrayList<LogFileOptions> getAllLogFiles() {
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>(this.getLogFiles());
        for (PredefinedLogFile predefinedLogFile : this.myPredefinedLogFiles) {
            LogFileOptions options = this.getOptionsForPredefinedLogFile(predefinedLogFile);
            if (options == null) continue;
            list.add(options);
        }
        ArrayList<LogFileOptions> arrayList = list;
        if (arrayList == null) {
            RunConfigurationBase.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public List<LogFileOptions> getLogFiles() {
        List<LogFileOptions> list = this.getOptions().getLogFiles();
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void addLogFile(String file, String alias, boolean checked) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file, checked));
    }

    public void addLogFile(String file, String alias, boolean checked, boolean skipContent, boolean showAll) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file, checked, skipContent, showAll));
    }

    public void removeAllLogFiles() {
        this.getOptions().getLogFiles().clear();
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
    }

    public void customizeLogConsole(LogConsole console) {
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            RunConfigurationBase.$$$reportNull$$$0(11);
        }
        this.readExternal(element);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RunConfigurationBase.$$$reportNull$$$0(12);
        }
        this.myPredefinedLogFiles.clear();
        for (Element fileElement : element.getChildren(PREDEFINED_LOG_FILE_ELEMENT)) {
            PredefinedLogFile logFile = new PredefinedLogFile();
            logFile.readExternal(fileElement);
            this.myPredefinedLogFiles.add(logFile);
        }
        this.myOptions = XmlSerializer.deserialize(element, this.getOptionsClass());
    }

    protected Class<? extends RunConfigurationOptions> getOptionsClass() {
        if (this instanceof PersistentStateComponent) {
            PersistentStateComponent instance = (PersistentStateComponent)((Object)this);
            return ComponentSerializationUtil.getStateClass(instance.getClass());
        }
        return RunConfigurationOptions.class;
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RunConfigurationBase.$$$reportNull$$$0(13);
        }
        JDOMExternalizerUtil.addChildren((Element)element, (String)PREDEFINED_LOG_FILE_ELEMENT, this.myPredefinedLogFiles);
        XmlSerializer.serializeObjectInto(this.myOptions, element);
    }

    @Transient
    public boolean isSaveOutputToFile() {
        return this.myOptions.getFileOutput().isSaveOutput();
    }

    public void setSaveOutputToFile(boolean redirectOutput) {
        this.myOptions.getFileOutput().setSaveOutput(redirectOutput);
    }

    @Attribute(value="show_console_on_std_out")
    public boolean isShowConsoleOnStdOut() {
        return this.myOptions.isShowConsoleOnStdOut();
    }

    public void setShowConsoleOnStdOut(boolean showConsoleOnStdOut) {
        this.myOptions.setShowConsoleOnStdOut(showConsoleOnStdOut);
    }

    @Attribute(value="show_console_on_std_err")
    public boolean isShowConsoleOnStdErr() {
        return this.myOptions.isShowConsoleOnStdErr();
    }

    public void setShowConsoleOnStdErr(boolean showConsoleOnStdErr) {
        this.myOptions.setShowConsoleOnStdErr(showConsoleOnStdErr);
    }

    @Transient
    public String getOutputFilePath() {
        return this.myOptions.getFileOutput().getFileOutputPath();
    }

    public void setFileOutputPath(String fileOutputPath) {
        this.myOptions.getFileOutput().setFileOutputPath(fileOutputPath);
    }

    public boolean collectOutputFromProcessHandler() {
        return true;
    }

    public boolean excludeCompileBeforeLaunchOption() {
        return false;
    }

    public boolean isCompileBeforeLaunchAddedByDefault() {
        return true;
    }

    public String toString() {
        return this.getType().getDisplayName() + ": " + this.getName();
    }

    @Deprecated
    protected boolean isNewSerializationUsed() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLogFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLogFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLogFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBeforeRunTasks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnerSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedLogFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

