/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.gradle.api.Action;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.logging.LogLevel;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentInternal;
import org.gradle.deployment.internal.DeploymentRegistryInternal;
import org.gradle.execution.CancellableOperationManager;
import org.gradle.execution.DefaultCancellableOperationManager;
import org.gradle.execution.PassThruCancellableOperationManager;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.ContinuousExecutionGate;
import org.gradle.initialization.DefaultContinuousExecutionGate;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.filewatch.DefaultFileWatcherEventListener;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileSystemChangeWaiterFactory;
import org.gradle.internal.filewatch.FileWatcherEventListener;
import org.gradle.internal.filewatch.PendingChangesListener;
import org.gradle.internal.filewatch.SingleFirePendingChangesListener;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.util.DisconnectableInputStream;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final BuildActionExecuter<BuildActionParameters> delegate;
    private final TaskInputsListener inputsListener;
    private final OperatingSystem operatingSystem;
    private final FileSystemChangeWaiterFactory changeWaiterFactory;
    private final ExecutorFactory executorFactory;
    private final StyledTextOutput logger;

    public ContinuousBuildActionExecuter(BuildActionExecuter<BuildActionParameters> delegate, FileSystemChangeWaiterFactory changeWaiterFactory, TaskInputsListener inputsListener, StyledTextOutputFactory styledTextOutputFactory, ExecutorFactory executorFactory) {
        this.delegate = delegate;
        this.inputsListener = inputsListener;
        this.operatingSystem = OperatingSystem.current();
        this.executorFactory = executorFactory;
        this.changeWaiterFactory = changeWaiterFactory;
        this.logger = styledTextOutputFactory.create(ContinuousBuildActionExecuter.class, LogLevel.QUIET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry buildSessionScopeServices) {
        BuildCancellationToken cancellationToken = requestContext.getCancellationToken();
        if (actionParameters.isContinuous()) {
            SingleMessageLogger.incubatingFeatureUsed((String)"Continuous build");
            DefaultContinuousExecutionGate alwaysOpenExecutionGate = new DefaultContinuousExecutionGate();
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(actionParameters, cancellationToken);
            return this.executeMultipleBuilds(action, requestContext, actionParameters, buildSessionScopeServices, cancellableOperationManager, (ContinuousExecutionGate)alwaysOpenExecutionGate);
        }
        try {
            Object object = this.delegate.execute(action, requestContext, actionParameters, buildSessionScopeServices);
            return object;
        }
        finally {
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(actionParameters, cancellationToken);
            this.waitForDeployments(action, requestContext, actionParameters, buildSessionScopeServices, cancellableOperationManager);
        }
    }

    private CancellableOperationManager createCancellableOperationManager(BuildActionParameters actionParameters, BuildCancellationToken cancellationToken) {
        PassThruCancellableOperationManager cancellableOperationManager;
        if (actionParameters.isInteractive()) {
            if (!(System.in instanceof DisconnectableInputStream)) {
                System.setIn((InputStream)new DisconnectableInputStream(System.in));
            }
            DisconnectableInputStream inputStream = (DisconnectableInputStream)System.in;
            cancellableOperationManager = new DefaultCancellableOperationManager((ExecutorService)this.executorFactory.create("Cancel signal monitor"), inputStream, cancellationToken);
        } else {
            cancellableOperationManager = new PassThruCancellableOperationManager(cancellationToken);
        }
        return cancellableOperationManager;
    }

    private void waitForDeployments(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry buildSessionScopeServices, CancellableOperationManager cancellableOperationManager) {
        DeploymentRegistryInternal deploymentRegistry = (DeploymentRegistryInternal)buildSessionScopeServices.get(DeploymentRegistryInternal.class);
        if (!deploymentRegistry.getRunningDeployments().isEmpty()) {
            for (Deployment deployment : deploymentRegistry.getRunningDeployments()) {
                ((DeploymentInternal)deployment).outOfDate();
            }
            this.logger.println().println((Object)"Reloadable deployment detected. Entering continuous build.");
            ContinuousExecutionGate deploymentRequestExecutionGate = deploymentRegistry.getExecutionGate();
            this.executeMultipleBuilds(action, requestContext, actionParameters, buildSessionScopeServices, cancellableOperationManager, deploymentRequestExecutionGate);
        }
        cancellableOperationManager.closeInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeMultipleBuilds(BuildAction action, BuildRequestContext requestContext, final BuildActionParameters actionParameters, ServiceRegistry buildSessionScopeServices, CancellableOperationManager cancellableOperationManager, ContinuousExecutionGate continuousExecutionGate) {
        Object lastResult;
        BuildCancellationToken cancellationToken = requestContext.getCancellationToken();
        BuildStartedTime buildStartedTime = (BuildStartedTime)buildSessionScopeServices.get(BuildStartedTime.class);
        Clock clock = (Clock)buildSessionScopeServices.get(Clock.class);
        while (true) {
            PendingChangesListener pendingChangesListener = (PendingChangesListener)((ListenerManager)buildSessionScopeServices.get(ListenerManager.class)).getBroadcaster(PendingChangesListener.class);
            final FileSystemChangeWaiter waiter = this.changeWaiterFactory.createChangeWaiter((PendingChangesListener)new SingleFirePendingChangesListener(pendingChangesListener), cancellationToken, continuousExecutionGate);
            try {
                try {
                    lastResult = this.executeBuildAndAccumulateInputs(action, requestContext, actionParameters, waiter, buildSessionScopeServices);
                }
                catch (ReportedException t) {
                    lastResult = t;
                }
                if (!waiter.isWatching()) {
                    this.logger.println().withStyle(StyledTextOutput.Style.Failure).println((Object)"Exiting continuous build as no executed tasks declared file system inputs.");
                    if (lastResult instanceof ReportedException) {
                        throw lastResult;
                    }
                    Object object = lastResult;
                    return object;
                }
                cancellableOperationManager.monitorInput((Action)new Action<BuildCancellationToken>(){

                    public void execute(BuildCancellationToken cancellationToken) {
                        DefaultFileWatcherEventListener reporter = new DefaultFileWatcherEventListener();
                        waiter.wait(new Runnable(){

                            public void run() {
                                ContinuousBuildActionExecuter.this.logger.println().println((Object)("Waiting for changes to input files of tasks..." + ContinuousBuildActionExecuter.this.determineExitHint(actionParameters)));
                            }
                        }, (FileWatcherEventListener)reporter);
                        if (!cancellationToken.isCancellationRequested()) {
                            reporter.reportChanges(ContinuousBuildActionExecuter.this.logger);
                        }
                    }
                });
            }
            finally {
                waiter.stop();
            }
            if (cancellationToken.isCancellationRequested()) break;
            this.logger.println((Object)"Change detected, executing build...").println();
            buildStartedTime.reset(clock.getCurrentTime());
        }
        this.logger.println((Object)"Build cancelled.");
        if (lastResult instanceof ReportedException) {
            throw lastResult;
        }
        return lastResult;
    }

    private String determineExitHint(BuildActionParameters actionParameters) {
        if (actionParameters.isInteractive()) {
            if (this.operatingSystem.isWindows()) {
                return " (ctrl-d then enter to exit)";
            }
            return " (ctrl-d to exit)";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeBuildAndAccumulateInputs(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, FileSystemChangeWaiter waiter, ServiceRegistry buildSessionScopeServices) {
        try {
            this.inputsListener.setFileSystemWaiter(waiter);
            Object object = this.delegate.execute(action, requestContext, actionParameters, buildSessionScopeServices);
            return object;
        }
        finally {
            this.inputsListener.setFileSystemWaiter(null);
        }
    }
}

