/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.Cancel;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.InputMessage;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.launcher.daemon.server.api.DaemonConnection;
import org.gradle.launcher.daemon.server.api.StdinHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonConnection
implements DaemonConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDaemonConnection.class);
    private final RemoteConnection<Message> connection;
    private final ManagedExecutor executor;
    private final StdinQueue stdinQueue;
    private final DisconnectQueue disconnectQueue;
    private final CancelQueue cancelQueue;
    private final ReceiveQueue receiveQueue;
    private volatile boolean stopping;

    public DefaultDaemonConnection(final RemoteConnection<Message> connection, ExecutorFactory executorFactory) {
        this.connection = connection;
        this.stdinQueue = new StdinQueue(executorFactory);
        this.disconnectQueue = new DisconnectQueue();
        this.cancelQueue = new CancelQueue(executorFactory);
        this.receiveQueue = new ReceiveQueue();
        this.executor = executorFactory.create("Handler for " + connection.toString());
        this.executor.execute(new Runnable(){

            public void run() {
                Exception failure = null;
                try {
                    while (true) {
                        Object message;
                        try {
                            message = connection.receive();
                        }
                        catch (Exception e) {
                            if (!DefaultDaemonConnection.this.stopping && LOGGER.isDebugEnabled()) {
                                LOGGER.debug(String.format("thread %s: Could not receive message from client.", Thread.currentThread().getId()), (Throwable)e);
                            }
                            failure = e;
                            DefaultDaemonConnection.this.stdinQueue.disconnect();
                            DefaultDaemonConnection.this.cancelQueue.disconnect();
                            DefaultDaemonConnection.this.disconnectQueue.disconnect();
                            DefaultDaemonConnection.this.receiveQueue.disconnect(failure);
                            return;
                        }
                        if (message == null) {
                            LOGGER.debug("thread {}: Received end-of-input from client.", (Object)Thread.currentThread().getId());
                            return;
                        }
                        if (message instanceof InputMessage) {
                            LOGGER.debug("thread {}: Received IO message from client: {}", (Object)Thread.currentThread().getId(), message);
                            DefaultDaemonConnection.this.stdinQueue.add((InputMessage)message);
                            continue;
                        }
                        if (message instanceof Cancel) {
                            LOGGER.debug("thread {}: Received cancel message from client: {}", (Object)Thread.currentThread().getId(), message);
                            DefaultDaemonConnection.this.cancelQueue.add((Cancel)message);
                            continue;
                        }
                        LOGGER.debug("thread {}: Received non-IO message from client: {}", (Object)Thread.currentThread().getId(), message);
                        DefaultDaemonConnection.this.receiveQueue.add(message);
                    }
                }
                finally {
                    DefaultDaemonConnection.this.stdinQueue.disconnect();
                    DefaultDaemonConnection.this.cancelQueue.disconnect();
                    DefaultDaemonConnection.this.disconnectQueue.disconnect();
                    DefaultDaemonConnection.this.receiveQueue.disconnect(failure);
                }
            }
        });
    }

    @Override
    public void onStdin(StdinHandler handler) {
        this.stdinQueue.useHandler(handler);
    }

    @Override
    public void onDisconnect(Runnable handler) {
        this.disconnectQueue.useHandler(handler);
    }

    @Override
    public void onCancel(Runnable handler) {
        this.cancelQueue.useHandler(handler);
    }

    @Override
    public Object receive(long timeoutValue, TimeUnit timeoutUnits) {
        return this.receiveQueue.take(timeoutValue, timeoutUnits);
    }

    @Override
    public void daemonUnavailable(DaemonUnavailable unavailable) {
        this.connection.dispatch((Object)unavailable);
        this.connection.flush();
    }

    @Override
    public void buildStarted(BuildStarted buildStarted) {
        this.connection.dispatch((Object)buildStarted);
        this.connection.flush();
    }

    @Override
    public void logEvent(OutputEvent logEvent) {
        this.connection.dispatch((Object)new OutputMessage(logEvent));
        this.connection.flush();
    }

    @Override
    public void event(Object event) {
        this.connection.dispatch((Object)new BuildEvent(event));
        this.connection.flush();
    }

    @Override
    public void completed(Result result) {
        this.connection.dispatch((Object)result);
        this.connection.flush();
    }

    @Override
    public void stop() {
        this.stopping = true;
        CompositeStoppable.stoppable((Object[])new Object[]{this.disconnectQueue, this.connection, this.executor, this.receiveQueue, this.stdinQueue, this.cancelQueue}).stop();
    }

    public String toString() {
        return "DefaultDaemonConnection: " + this.connection;
    }

    private static class ReceiveQueue
    implements Stoppable {
        private static final Object END = new Object();
        private final BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();

        private ReceiveQueue() {
        }

        public void stop() {
        }

        public void disconnect(Throwable failure) {
            this.queue.clear();
            if (failure != null) {
                this.add(failure);
            }
            this.add(END);
        }

        public void add(Object message) {
            try {
                this.queue.put(message);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        public Object take(long timeoutValue, TimeUnit timeoutUnits) {
            Object result;
            try {
                result = this.queue.poll(timeoutValue, timeoutUnits);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            if (result instanceof Throwable) {
                Throwable failure = (Throwable)result;
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
            return result == END ? null : result;
        }
    }

    private static class DisconnectQueue
    implements Stoppable {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private Runnable handler;
        private boolean notifying;
        private boolean disconnected;

        private DisconnectQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            Runnable action;
            this.lock.lock();
            try {
                this.disconnected = true;
                if (this.handler == null) {
                    return;
                }
                action = this.handler;
                this.notifying = true;
            }
            finally {
                this.lock.unlock();
            }
            this.runAction(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runAction(Runnable action) {
            try {
                action.run();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to notify disconnect handler.", (Throwable)e);
            }
            finally {
                this.lock.lock();
                try {
                    this.notifying = false;
                    this.condition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public void stop() {
            this.useHandler(null);
        }

        public void useHandler(Runnable handler) {
            if (handler != null) {
                this.startMonitoring(handler);
            } else {
                this.stopMonitoring();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startMonitoring(Runnable handler) {
            Runnable action;
            this.lock.lock();
            try {
                if (this.handler != null) {
                    throw new UnsupportedOperationException("Multiple disconnect handlers not supported.");
                }
                this.handler = handler;
                if (!this.disconnected) {
                    return;
                }
                action = handler;
                this.notifying = true;
            }
            finally {
                this.lock.unlock();
            }
            this.runAction(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopMonitoring() {
            this.lock.lock();
            try {
                while (this.notifying) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                this.handler = null;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CancelQueue
    extends CommandQueue<Cancel, Runnable> {
        private CancelQueue(ExecutorFactory executorFactory) {
            super(executorFactory, "Cancel handler");
        }

        @Override
        protected boolean doHandleCommand(Runnable handler, Cancel command) {
            try {
                handler.run();
            }
            catch (Exception e) {
                LOGGER.warn("Could not process cancel request from client.", (Throwable)e);
            }
            return true;
        }

        @Override
        protected void doHandleDisconnect() {
            this.queue.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StdinQueue
    extends CommandQueue<InputMessage, StdinHandler> {
        private StdinQueue(ExecutorFactory executorFactory) {
            super(executorFactory, "Stdin handler");
        }

        @Override
        protected boolean doHandleCommand(StdinHandler handler, InputMessage command) {
            try {
                if (command instanceof CloseInput) {
                    handler.onEndOfInput();
                    return true;
                }
                handler.onInput((ForwardInput)command);
            }
            catch (Exception e) {
                LOGGER.warn("Could not forward client stdin.", (Throwable)e);
                return true;
            }
            return false;
        }

        @Override
        protected void doHandleDisconnect() {
            this.queue.clear();
            this.queue.add(new CloseInput());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CommandQueue<C extends Message, H>
    implements Stoppable {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        protected final LinkedList<C> queue = new LinkedList();
        private final String name;
        private ManagedExecutor executor;
        private boolean removed;
        private final ExecutorFactory executorFactory;

        private CommandQueue(ExecutorFactory executorFactory, String name) {
            this.executorFactory = executorFactory;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            ManagedExecutor executor;
            this.lock.lock();
            try {
                executor = this.executor;
            }
            finally {
                this.lock.unlock();
            }
            if (executor != null) {
                executor.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(C command) {
            this.lock.lock();
            try {
                this.queue.add(command);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void useHandler(H handler) {
            if (handler != null) {
                this.startConsuming(handler);
            } else {
                this.stopConsuming();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopConsuming() {
            ManagedExecutor executor;
            this.lock.lock();
            try {
                this.queue.clear();
                this.removed = true;
                this.condition.signalAll();
                executor = this.executor;
            }
            finally {
                this.lock.unlock();
            }
            if (executor != null) {
                executor.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void startConsuming(final H handler) {
            this.lock.lock();
            try {
                if (this.executor != null) {
                    throw new UnsupportedOperationException("More instances of " + this.name + " not supported.");
                }
                this.executor = this.executorFactory.create(this.name);
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Message command;
                        do {
                            CommandQueue.this.lock.lock();
                            try {
                                while (!CommandQueue.this.removed && CommandQueue.this.queue.isEmpty()) {
                                    try {
                                        CommandQueue.this.condition.await();
                                    }
                                    catch (InterruptedException e) {
                                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                                    }
                                }
                                if (CommandQueue.this.removed) {
                                    return;
                                }
                                command = (Message)CommandQueue.this.queue.removeFirst();
                            }
                            finally {
                                CommandQueue.this.lock.unlock();
                            }
                        } while (!CommandQueue.this.doHandleCommand(handler, command));
                    }
                });
            }
            finally {
                this.lock.unlock();
            }
        }

        protected abstract boolean doHandleCommand(H var1, C var2);

        protected abstract void doHandleDisconnect();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            this.lock.lock();
            try {
                this.doHandleDisconnect();
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

