/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.cache.FileAccess;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.internal.FileIntegrityViolationSuppressingPersistentStateCacheDecorator;
import org.gradle.cache.internal.OnDemandFileAccess;
import org.gradle.cache.internal.SimpleStateCache;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.remote.Address;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonRegistryContent;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentDaemonRegistry
implements DaemonRegistry {
    private final PersistentStateCache<DaemonRegistryContent> cache;
    private final Lock lock = new ReentrantLock();
    private final File registryFile;
    private static final Logger LOGGER = Logging.getLogger(PersistentDaemonRegistry.class);

    public PersistentDaemonRegistry(File registryFile, FileLockManager fileLockManager, Chmod chmod) {
        this.registryFile = registryFile;
        this.cache = new FileIntegrityViolationSuppressingPersistentStateCacheDecorator((PersistentStateCache)new SimpleStateCache(registryFile, (FileAccess)new OnDemandFileAccess(registryFile, "daemon addresses registry", fileLockManager), DaemonRegistryContent.SERIALIZER, chmod));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DaemonInfo> getAll() {
        this.lock.lock();
        try {
            DaemonRegistryContent content = (DaemonRegistryContent)this.cache.get();
            if (content == null) {
                LinkedList<DaemonInfo> linkedList = new LinkedList<DaemonInfo>();
                return linkedList;
            }
            List<DaemonInfo> list = content.getInfos();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<DaemonInfo> getIdle() {
        return this.getDaemonsMatching(new Spec<DaemonInfo>(){

            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return daemonInfo.getState() == DaemonStateControl.State.Idle;
            }
        });
    }

    @Override
    public List<DaemonInfo> getNotIdle() {
        return this.getDaemonsMatching(new Spec<DaemonInfo>(){

            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return daemonInfo.getState() != DaemonStateControl.State.Idle;
            }
        });
    }

    @Override
    public List<DaemonInfo> getCanceled() {
        return this.getDaemonsMatching(new Spec<DaemonInfo>(){

            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return daemonInfo.getState() == DaemonStateControl.State.Canceled;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DaemonInfo> getDaemonsMatching(Spec<DaemonInfo> spec) {
        this.lock.lock();
        try {
            LinkedList<DaemonInfo> out = new LinkedList<DaemonInfo>();
            List<DaemonInfo> all = this.getAll();
            for (DaemonInfo d : all) {
                if (!spec.isSatisfiedBy((Object)d)) continue;
                out.add(d);
            }
            LinkedList<DaemonInfo> linkedList = out;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(final Address address) {
        this.lock.lock();
        LOGGER.debug("Removing daemon address: {}", (Object)address);
        try {
            this.cache.update((PersistentStateCache.UpdateAction)new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    if (oldValue == null) {
                        return oldValue;
                    }
                    oldValue.removeInfo(address);
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markState(final Address address, final DaemonStateControl.State state) {
        this.lock.lock();
        LOGGER.debug("Marking busy by address: {}", (Object)address);
        try {
            this.cache.update((PersistentStateCache.UpdateAction)new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    DaemonInfo daemonInfo;
                    DaemonInfo daemonInfo2 = daemonInfo = oldValue != null ? oldValue.getInfo(address) : null;
                    if (daemonInfo != null) {
                        daemonInfo.setState(state);
                    }
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeStopEvent(final DaemonStopEvent stopEvent) {
        this.lock.lock();
        LOGGER.debug("Storing daemon stop event with timestamp {}", (Object)stopEvent.getTimestamp().getTime());
        try {
            this.cache.update((PersistentStateCache.UpdateAction)new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent content) {
                    if (content == null) {
                        content = new DaemonRegistryContent();
                    }
                    content.addStopEvent(stopEvent);
                    return content;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DaemonStopEvent> getStopEvents() {
        this.lock.lock();
        LOGGER.debug("Getting daemon stop events");
        try {
            DaemonRegistryContent content = (DaemonRegistryContent)this.cache.get();
            if (content == null) {
                LinkedList<DaemonStopEvent> linkedList = new LinkedList<DaemonStopEvent>();
                return linkedList;
            }
            List<DaemonStopEvent> list = content.getStopEvents();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStopEvents(final Collection<DaemonStopEvent> events) {
        this.lock.lock();
        LOGGER.info("Removing {} daemon stop events from registry", (Object)events.size());
        try {
            this.cache.update((PersistentStateCache.UpdateAction)new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent content) {
                    if (content != null) {
                        content.removeStopEvents(events);
                    }
                    return content;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(DaemonInfo info) {
        final Address address = info.getAddress();
        final DaemonContext daemonContext = info.getContext();
        final byte[] token = info.getToken();
        final DaemonStateControl.State state = info.getState();
        this.lock.lock();
        LOGGER.debug("Storing daemon address: {}, context: {}", (Object)address, (Object)daemonContext);
        try {
            this.cache.update((PersistentStateCache.UpdateAction)new PersistentStateCache.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    if (oldValue == null) {
                        oldValue = new DaemonRegistryContent();
                    }
                    DaemonInfo daemonInfo = new DaemonInfo(address, daemonContext, token, state);
                    oldValue.setStatus(address, daemonInfo);
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("PersistentDaemonRegistry[file=%s]", this.registryFile);
    }
}

