/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "migrationHelper", "Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "(Lorg/jetbrains/plugins/github/util/GithubSettings;Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;)V", "DEFAULT_SERVER", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getAccessibleRemoteUrls", "", "", "repository", "Lgit4idea/repo/GitRepository;", "getPossibleRepositories", "", "Lorg/jetbrains/plugins/github/api/GithubRepositoryPath;", "getRemoteUrl", "server", "user", "repo", "repoPath", "Lorg/jetbrains/plugins/github/api/GithubFullPath;", "hasAccessibleRemotes", "", "isRemoteUrlAccessible", "url", "Companion", "intellij.vcs.github"})
public final class GithubGitHelper {
    private final GithubServerPath DEFAULT_SERVER;
    private final GithubSettings githubSettings;
    private final GithubAuthenticationManager authenticationManager;
    private final GithubAccountsMigrationHelper migrationHelper;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull GithubFullPath repoPath) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)repoPath, (String)"repoPath");
        String string = repoPath.getUser();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repoPath.user");
        String string2 = repoPath.getRepository();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"repoPath.repository");
        return this.getRemoteUrl(server, string, string2);
    }

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull String user, @NotNull String repo) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        if (this.githubSettings.isCloneGitUsingSsh()) {
            String string2;
            String string3;
            StringBuilder stringBuilder;
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append("git@").append(server.getHost()).append(':');
            String string5 = server.getSuffix();
            if (string5 != null) {
                string4 = string5;
                int n = 1;
                stringBuilder = stringBuilder2;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string3 = string7;
                stringBuilder2 = stringBuilder;
                string2 = string3;
            } else {
                string2 = null;
            }
            string4 = string2;
            stringBuilder = stringBuilder2;
            String string8 = string4;
            if (string8 == null) {
                string8 = "";
            }
            string3 = string8;
            string = stringBuilder.append(string3).append('/').append(user).append('/').append(repo).append(".git").toString();
        } else {
            String string9 = server.getSuffix();
            StringBuilder stringBuilder = new StringBuilder().append("https://").append(server.getHost());
            String string10 = string9;
            if (string10 == null) {
                string10 = "";
            }
            String string11 = string10;
            string = stringBuilder.append(string11).append('/').append(user).append('/').append(repo).append(".git").toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAccessibleRemoteUrls(@NotNull GitRepository repository) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Collection collection = repository.getRemotes();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repository.remotes");
        Iterable $receiver$iv = collection;
        Object object = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            GitRemote gitRemote = (GitRemote)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            List list = v1.getUrls();
            collection2.add(list);
        }
        $receiver$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        object = this;
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String p1 = (String)element$iv$iv;
            if (!((GithubGitHelper)object).isRemoteUrlAccessible(p1)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasAccessibleRemotes(@NotNull GitRepository repository) {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Collection collection = repository.getRemotes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repository.remotes");
            Iterable $receiver$iv = collection;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                GitRemote gitRemote = (GitRemote)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                List list = v1.getUrls();
                collection2.add(list);
            }
            $receiver$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            object = this;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String p1 = (String)element$iv;
                    if (!((GithubGitHelper)object).isRemoteUrlAccessible(p1)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isRemoteUrlAccessible(String url) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.authenticationManager.getAccounts();
            for (Object t : iterable2) {
                GithubAccount it = (GithubAccount)t;
                if (!it.getServer().matches(url)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<GithubRepositoryPath> getPossibleRepositories(@NotNull GitRepository repository) {
        GithubServerPath it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        List list;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Set registeredServers = SetsKt.mutableSetOf((Object[])new GithubServerPath[]{this.DEFAULT_SERVER});
        GithubServerPath githubServerPath = this.migrationHelper.getOldServer$intellij_vcs_github();
        if (githubServerPath != null) {
            GithubServerPath githubServerPath2 = githubServerPath;
            Set set = registeredServers;
            GithubServerPath p1 = githubServerPath2;
            set.add(p1);
        }
        Iterable $receiver$iv2 = this.authenticationManager.getAccounts();
        for (Object item$iv : $receiver$iv2) {
            void it2;
            GithubAccount $i$a$1$unknown = (GithubAccount)item$iv;
            collection = registeredServers;
            Intrinsics.checkExpressionValueIsNotNull((Object)it2.getServer(), (String)"it.server");
            collection.add(list);
        }
        Set repositoryPaths = new LinkedHashSet();
        Collection collection2 = repository.getRemotes();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"repository.remotes");
        Iterable $i$a$2$mapTo = $receiver$iv = (Iterable)collection2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            GitRemote gitRemote = (GitRemote)item$iv$iv;
            collection = destination$iv$iv;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            list = v2.getUrls();
            collection.add(list);
        }
        for (String url : CollectionsKt.flatten((Iterable)((List)destination$iv$iv))) {
            $receiver$iv$iv = $receiver$iv = (Iterable)registeredServers;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (GithubServerPath)element$iv$iv;
                if (!it.matches(url)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                GithubRepositoryPath githubRepositoryPath;
                GithubRepositoryPath githubRepositoryPath2;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                GithubServerPath server = (GithubServerPath)element$iv;
                if (GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url) != null) {
                    GithubFullPath githubFullPath;
                    GithubFullPath it3;
                    GithubFullPath githubFullPath2 = it3 = githubFullPath;
                    Intrinsics.checkExpressionValueIsNotNull((Object)githubFullPath2, (String)"it");
                    githubRepositoryPath2 = new GithubRepositoryPath(server, githubFullPath2);
                } else {
                    githubRepositoryPath2 = null;
                }
                if (githubRepositoryPath2 == null) continue;
                GithubRepositoryPath it$iv = githubRepositoryPath = githubRepositoryPath2;
                ((Collection)repositoryPaths).add(it$iv);
            }
        }
        return repositoryPaths;
    }

    public GithubGitHelper(@NotNull GithubSettings githubSettings, @NotNull GithubAuthenticationManager authenticationManager, @NotNull GithubAccountsMigrationHelper migrationHelper) {
        Intrinsics.checkParameterIsNotNull((Object)githubSettings, (String)"githubSettings");
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkParameterIsNotNull((Object)migrationHelper, (String)"migrationHelper");
        this.githubSettings = githubSettings;
        this.authenticationManager = authenticationManager;
        this.migrationHelper = migrationHelper;
        this.DEFAULT_SERVER = new GithubServerPath("github.com");
    }

    @JvmStatic
    @Nullable
    public static final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @NotNull
    public static final GithubGitHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper$Companion;", "", "()V", "findGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
            GitRepository repository;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
            GitRepositoryManager manager = gitRepositoryManager;
            List list = manager.getRepositories();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"manager.repositories");
            List repositories = list;
            if (repositories.size() == 0) {
                return null;
            }
            if (repositories.size() == 1) {
                return (GitRepository)repositories.get(0);
            }
            if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
                return repository;
            }
            return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
        }

        @JvmStatic
        @NotNull
        public final GithubGitHelper getInstance() {
            Object object = ServiceManager.getService(GithubGitHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (GithubGitHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

