/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.progress.ProgressVisibilityManager;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecorator;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecoratorRenderer;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountsPanel;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t*\u0002\u0010\u0019\b\u0000\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ\r\u0010\u001e\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001fJ\r\u0010 \u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\fH\u0002J\"\u0010%\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170'\u0012\u0006\u0012\u0004\u0018\u00010\u00160&J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010,\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.2\b\u0010/\u001a\u0004\u0018\u00010\u0016J\u0010\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\fH\u0002J\u0006\u00102\u001a\u00020\u001cJ\u001e\u00103\u001a\u00020\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.2\b\u0010/\u001a\u0004\u0018\u00010\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "apiTaskExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;", "accountInformationProvider", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;)V", "accountList", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecorator;", "accountListModel", "Lcom/intellij/ui/CollectionListModel;", "errorLinkHandler", "org/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1;", "errorLinkHandlerInstalled", "", "newTokensMap", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "progressManager", "org/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1;", "addAccount", "", "clearNewTokens", "createLinkActivationListener", "()Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1;", "createListProgressManager", "()Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1;", "dispose", "editAccount", "decorator", "getAccounts", "Lkotlin/Pair;", "", "isAccountUnique", "login", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "isModified", "accounts", "", "defaultAccount", "loadAccountDetails", "accountData", "loadExistingAccountsDetails", "setAccounts", "setLinkHandlerEnabled", "enabled", "Companion", "intellij.vcs.github"})
public final class GithubAccountsPanel
extends BorderLayoutPanel
implements Disposable {
    private final CollectionListModel<GithubAccountDecorator> accountListModel;
    private final JBList<GithubAccountDecorator> accountList;
    private final createListProgressManager.1 progressManager;
    private final createLinkActivationListener.1 errorLinkHandler;
    private boolean errorLinkHandlerInstalled;
    private final Map<GithubAccount, String> newTokensMap;
    private final Project project;
    private final GithubApiTaskExecutor apiTaskExecutor;
    private final GithubAccountInformationProvider accountInformationProvider;
    public static final Companion Companion = new Companion(null);

    private final void addAccount() {
        GithubLoginDialog dialog2 = new GithubLoginDialog(this.project, (Component)((Object)this), (Function2)new Function2<String, GithubServerPath, Boolean>(this){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return GithubAccountsPanel.access$isAccountUnique((GithubAccountsPanel)((Object)this.receiver), p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAccountsPanel.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        }, null, null, 24, null);
        if (dialog2.showAndGet()) {
            GithubAccount githubAccount = GithubAccountManager.Companion.createAccount(dialog2.getLogin(), dialog2.getServer());
            Map<GithubAccount, String> map = this.newTokensMap;
            String string = dialog2.getToken();
            map.put(githubAccount, string);
            GithubAccountDecorator accountData = new GithubAccountDecorator(githubAccount, false);
            this.accountListModel.add((Object)accountData);
            this.loadAccountDetails(accountData);
        }
    }

    private final void editAccount(GithubAccountDecorator decorator) {
        Object object = new GithubLoginDialog(this.project, (Component)((Object)this), null, null, null, 28, null);
        GithubLoginDialog $receiver = object;
        String string = decorator.getAccount().getServer().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decorator.account.server.toString()");
        $receiver.withServer(string, false);
        GithubLoginDialog.withCredentials$default($receiver, decorator.getAccount().getName(), null, 2, null);
        GithubLoginDialog dialog2 = object;
        if (dialog2.showAndGet()) {
            decorator.getAccount().setName(dialog2.getLogin());
            object = this.newTokensMap;
            GithubAccount githubAccount = decorator.getAccount();
            String string2 = dialog2.getToken();
            object.put(githubAccount, string2);
            this.loadAccountDetails(decorator);
        }
    }

    private final boolean isAccountUnique(String login2, GithubServerPath server) {
        boolean bl;
        block3: {
            List list = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    GithubAccountDecorator it = (GithubAccountDecorator)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getAccount().getName(), (Object)login2) && Intrinsics.areEqual((Object)it.getAccount().getServer(), (Object)server))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final createLinkActivationListener.1 createLinkActivationListener() {
        return new MouseAdapter(this){
            final /* synthetic */ GithubAccountsPanel this$0;

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Point point = e.getPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                GithubAccountDecorator decorator = this.findDecoratorWithLoginLinkAt(point);
                if (decorator != null) {
                    UIUtil.setCursor((Component)((Component)GithubAccountsPanel.access$getAccountList$p(this.this$0)), (Cursor)Cursor.getPredefinedCursor(12));
                } else {
                    UIUtil.setCursor((Component)((Component)GithubAccountsPanel.access$getAccountList$p(this.this$0)), (Cursor)Cursor.getDefaultCursor());
                }
                boolean hasChanges = false;
                for (GithubAccountDecorator item : GithubAccountsPanel.access$getAccountListModel$p(this.this$0).getItems()) {
                    boolean isLinkPointedAt = Intrinsics.areEqual((Object)item, (Object)decorator);
                    hasChanges = hasChanges || isLinkPointedAt != item.getErrorLinkPointedAt();
                    item.setErrorLinkPointedAt(isLinkPointedAt);
                }
                if (hasChanges) {
                    GithubAccountsPanel.access$getAccountListModel$p(this.this$0).allContentsChanged();
                }
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Point point = e.getPoint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                    GithubAccountDecorator githubAccountDecorator = this.findDecoratorWithLoginLinkAt(point);
                    if (githubAccountDecorator == null) break block0;
                    GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                    GithubAccountsPanel githubAccountsPanel = this.this$0;
                    GithubAccountDecorator p1 = githubAccountDecorator2;
                    GithubAccountsPanel.access$editAccount(githubAccountsPanel, p1);
                }
            }

            private final GithubAccountDecorator findDecoratorWithLoginLinkAt(Point point) {
                GithubAccountDecorator decorator;
                int idx = GithubAccountsPanel.access$getAccountList$p(this.this$0).locationToIndex(point);
                if (idx < 0) {
                    return null;
                }
                Rectangle cellBounds = GithubAccountsPanel.access$getAccountList$p(this.this$0).getCellBounds(idx, idx);
                if (!cellBounds.contains(point)) {
                    return null;
                }
                GithubAccountDecorator githubAccountDecorator = decorator = (GithubAccountDecorator)GithubAccountsPanel.access$getAccountListModel$p(this.this$0).getElementAt(idx);
                if ((githubAccountDecorator != null ? githubAccountDecorator.getLoadingError() : null) == null) {
                    return null;
                }
                Component rendererComponent = GithubAccountsPanel.access$getAccountList$p(this.this$0).getCellRenderer().getListCellRendererComponent((JList)GithubAccountsPanel.access$getAccountList$p(this.this$0), decorator, idx, true, true);
                rendererComponent.setBounds(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
                Component component = rendererComponent;
                Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"rendererComponent");
                org.jetbrains.plugins.github.authentication.ui.GithubAccountsPanel$Companion.access$layoutRecursively(GithubAccountsPanel.Companion, component);
                int rendererRelativeX = point.x - cellBounds.x;
                int rendererRelativeY = point.y - cellBounds.y;
                Component childComponent = UIUtil.getDeepestComponentAt((Component)rendererComponent, (int)rendererRelativeX, (int)rendererRelativeY);
                if (!(childComponent instanceof SimpleColoredComponent)) {
                    return null;
                }
                Container container = ((SimpleColoredComponent)childComponent).getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)container, (String)"childComponent.parent");
                int childRelativeX = rendererRelativeX - container.getX() - ((SimpleColoredComponent)childComponent).getX();
                return Intrinsics.areEqual((Object)((SimpleColoredComponent)childComponent).getFragmentTagAt(childRelativeX), (Object)"EDIT_LINK") ? decorator : null;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    private final void setLinkHandlerEnabled(boolean enabled) {
        if (enabled) {
            if (!this.errorLinkHandlerInstalled) {
                this.accountList.addMouseListener((MouseListener)this.errorLinkHandler);
                this.accountList.addMouseMotionListener((MouseMotionListener)this.errorLinkHandler);
                this.errorLinkHandlerInstalled = true;
            }
        } else if (this.errorLinkHandlerInstalled) {
            this.accountList.removeMouseListener((MouseListener)this.errorLinkHandler);
            this.accountList.removeMouseMotionListener((MouseMotionListener)this.errorLinkHandler);
            this.errorLinkHandlerInstalled = false;
        }
    }

    public final void loadExistingAccountsDetails() {
        Iterator iterator = this.accountListModel.getItems().iterator();
        while (iterator.hasNext()) {
            GithubAccountDecorator accountData;
            GithubAccountDecorator githubAccountDecorator = accountData = (GithubAccountDecorator)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAccountDecorator, (String)"accountData");
            this.loadAccountDetails(githubAccountDecorator);
        }
    }

    private final void loadAccountDetails(GithubAccountDecorator accountData) {
        String newToken = this.newTokensMap.get(accountData.getAccount());
        this.progressManager.run(new Task.Backgroundable(this, newToken, accountData, this.project, "Not Visible"){
            @NotNull
            public Pair<? extends GithubUserDetailed, ? extends Image> data;
            final /* synthetic */ GithubAccountsPanel this$0;
            final /* synthetic */ String $newToken;
            final /* synthetic */ GithubAccountDecorator $accountData;

            @NotNull
            public final Pair<GithubUserDetailed, Image> getData() {
                Pair<? extends GithubUserDetailed, ? extends Image> pair = this.data;
                if (pair == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                return pair;
            }

            public final void setData(@NotNull Pair<? extends GithubUserDetailed, ? extends Image> pair) {
                Intrinsics.checkParameterIsNotNull(pair, (String)"<set-?>");
                this.data = pair;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                GithubUserDetailed githubUserDetailed;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ThrowableConvertor<GithubConnection, GithubUserDetailed, IOException> task = GithubAccountsPanel.access$getAccountInformationProvider$p(this.this$0).getInformationTask();
                if (this.$newToken != null) {
                    GithubServerPath githubServerPath = this.$accountData.getAccount().getServer();
                    Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"accountData.account.server");
                    githubUserDetailed = GithubApiTaskExecutor.Companion.execute(indicator, githubServerPath, this.$newToken, task);
                } else {
                    githubUserDetailed = GithubAccountsPanel.access$getApiTaskExecutor$p(this.this$0).execute(indicator, this.$accountData.getAccount(), task, true);
                }
                GithubUserDetailed details = githubUserDetailed;
                this.data = TuplesKt.to((Object)details, (Object)ImageIO.read(new URL(details.getAvatarUrl())));
            }

            public void onSuccess() {
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                CollectionListModel collectionListModel = GithubAccountsPanel.access$getAccountListModel$p(this.this$0);
                GithubAccountDecorator $receiver = githubAccountDecorator;
                Pair<? extends GithubUserDetailed, ? extends Image> pair = this.data;
                if (pair == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                $receiver.setFullName(((GithubUserDetailed)pair.getFirst()).getName());
                Pair<? extends GithubUserDetailed, ? extends Image> pair2 = this.data;
                if (pair2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                $receiver.setProfilePicture((Image)pair2.getSecond());
                $receiver.setLoadingError(null);
                $receiver.setShowLoginLink(false);
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                CollectionListModel collectionListModel = GithubAccountsPanel.access$getAccountListModel$p(this.this$0);
                GithubAccountDecorator $receiver = githubAccountDecorator;
                $receiver.setLoadingError(String.valueOf(error.getMessage()));
                $receiver.setShowLoginLink(error instanceof GithubAuthenticationException);
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            }
            {
                this.this$0 = $outer;
                this.$newToken = $captured_local_variable$1;
                this.$accountData = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final createListProgressManager.1 createListProgressManager() {
        return new ProgressVisibilityManager(this){
            final /* synthetic */ GithubAccountsPanel this$0;

            protected void setProgressVisible(boolean visible) {
                GithubAccountsPanel.access$getAccountList$p(this.this$0).setPaintBusy(visible);
            }

            @NotNull
            protected ModalityState getModalityState() {
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"ModalityState.any()");
                return modalityState;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final void setAccounts(@NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount) {
        Collection<GithubAccountDecorator> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
        this.accountListModel.removeAll();
        Iterable iterable = accounts;
        int n = 0;
        CollectionListModel<GithubAccountDecorator> collectionListModel = this.accountListModel;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GithubAccount githubAccount = (GithubAccount)item$iv$iv;
            collection = destination$iv$iv;
            GithubAccountDecorator githubAccountDecorator = new GithubAccountDecorator((GithubAccount)it, Intrinsics.areEqual((Object)it, (Object)defaultAccount));
            collection.add(githubAccountDecorator);
        }
        collection = (List)destination$iv$iv;
        collectionListModel.addAll(n, (List)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Map<GithubAccount, String>, GithubAccount> getAccounts() {
        Object v2;
        Map map;
        block2: {
            void $receiver$iv$iv;
            List list = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
            Iterable $receiver$iv = list;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            Iterable iterable = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                Map map2 = destination$iv$iv;
                GithubAccountDecorator it = (GithubAccountDecorator)element$iv$iv;
                Pair pair = TuplesKt.to((Object)it.getAccount(), (Object)this.newTokensMap.get(it.getAccount()));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"accountListModel.items");
            Iterable iterable2 = list2;
            map = destination$iv$iv;
            Iterable iterable3 = iterable2;
            for (Object e : iterable3) {
                GithubAccountDecorator it = (GithubAccountDecorator)e;
                if (!it.getProjectDefault()) continue;
                v2 = e;
                break block2;
            }
            v2 = null;
        }
        Object var14_12 = v2;
        GithubAccountDecorator githubAccountDecorator = var14_12;
        return TuplesKt.to((Object)map, (Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null));
    }

    public final void clearNewTokens() {
        this.newTokensMap.clear();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModified(@NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object v1;
        Iterable iterable;
        Map<GithubAccount, String> map;
        block2: {
            Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
            List list = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
            map = list;
            iterable = map;
            for (Object t : iterable) {
                GithubAccountDecorator it = (GithubAccountDecorator)t;
                if (!it.getProjectDefault()) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        GithubAccountDecorator githubAccountDecorator = v1;
        if (Intrinsics.areEqual((Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null), (Object)defaultAccount) ^ true) return true;
        List list = this.accountListModel.getItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
        iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GithubAccountDecorator $i$a$1$find = (GithubAccountDecorator)item$iv$iv;
            Collection collection = destination$iv$iv;
            GithubAccount githubAccount = it.getAccount();
            collection.add(githubAccount);
        }
        if (Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), accounts) ^ true) return true;
        map = this.newTokensMap;
        if (map.isEmpty()) return false;
        return true;
    }

    public void dispose() {
    }

    public GithubAccountsPanel(@NotNull Project project, @NotNull GithubApiTaskExecutor apiTaskExecutor, @NotNull GithubAccountInformationProvider accountInformationProvider) {
        StatusText statusText;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)apiTaskExecutor, (String)"apiTaskExecutor");
        Intrinsics.checkParameterIsNotNull((Object)accountInformationProvider, (String)"accountInformationProvider");
        this.project = project;
        this.apiTaskExecutor = apiTaskExecutor;
        this.accountInformationProvider = accountInformationProvider;
        CollectionListModel collectionListModel = new CollectionListModel((Object[])new GithubAccountDecorator[0]);
        GithubAccountsPanel githubAccountsPanel = this;
        CollectionListModel $receiver = collectionListModel;
        $receiver.addListDataListener(new ListDataListener($receiver, this){
            final /* synthetic */ CollectionListModel receiver$0;
            final /* synthetic */ GithubAccountsPanel this$0;
            {
                this.receiver$0 = $receiver;
                this.this$0 = githubAccountsPanel;
            }

            public void contentsChanged(@Nullable ListDataEvent e) {
                boolean bl;
                GithubAccountsPanel githubAccountsPanel;
                block3: {
                    List list = this.receiver$0.getItems();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"items");
                    Iterable $receiver$iv = list;
                    githubAccountsPanel = this.this$0;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            GithubAccountDecorator it = (GithubAccountDecorator)element$iv;
                            if (!(it.getLoadingError() != null)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl2 = bl;
                GithubAccountsPanel.access$setLinkHandlerEnabled(githubAccountsPanel, bl2);
            }

            public void intervalRemoved(@Nullable ListDataEvent e) {
            }

            public void intervalAdded(@Nullable ListDataEvent e) {
            }
        });
        githubAccountsPanel.accountListModel = object = collectionListModel;
        collectionListModel = new JBList((ListModel)this.accountListModel);
        githubAccountsPanel = this;
        $receiver = collectionListModel;
        $receiver.setCellRenderer((ListCellRenderer)new GithubAccountDecoratorRenderer());
        $receiver.setSelectionMode(0);
        $receiver.setSelectionForeground(UIUtil.getListForeground());
        $receiver.setSelectionBackground((Color)new JBColor(15331061, 4606541));
        StatusText $receiver2 = statusText = $receiver.getEmptyText();
        $receiver2.appendText("No GitHub accounts added.");
        $receiver2.appendSecondaryText("Add account", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
            final /* synthetic */ GithubAccountsPanel this$0;
            {
                this.this$0 = githubAccountsPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                GithubAccountsPanel.access$addAccount(this.this$0);
            }
        });
        $receiver2.appendSecondaryText(" (" + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getNew()) + ')', StatusText.DEFAULT_ATTRIBUTES, null);
        githubAccountsPanel.accountList = object = collectionListModel;
        this.progressManager = this.createListProgressManager();
        this.errorLinkHandler = this.createLinkActivationListener();
        githubAccountsPanel = this;
        githubAccountsPanel.newTokensMap = object = (Map)new LinkedHashMap();
        this.addToCenter(ToolbarDecorator.createDecorator((JList)((JList)this.accountList)).disableUpDownActions().setPanelBorder(IdeBorderFactory.createBorder((int)10)).setAddAction(new AnActionButtonRunnable(){

            public final void run(AnActionButton it) {
                this.addAccount();
            }
        }).addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton("Set default", AllIcons.Actions.Checked){

            public void actionPerformed(@Nullable AnActionEvent e) {
                if (((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault()) {
                    return;
                }
                for (GithubAccountDecorator accountData : accountListModel.getItems()) {
                    if (Intrinsics.areEqual((Object)accountData, (Object)((GithubAccountDecorator)accountList.getSelectedValue()))) {
                        accountData.setProjectDefault(true);
                        accountListModel.contentsChanged((Object)accountData);
                        continue;
                    }
                    if (!accountData.getProjectDefault()) continue;
                    accountData.setProjectDefault(false);
                    accountListModel.contentsChanged((Object)accountData);
                }
            }

            public void updateButton(@Nullable AnActionEvent e) {
                this.setEnabled(this.isEnabled() && !((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault());
            }
        }).createPanel());
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.progressManager));
    }

    public static final /* synthetic */ boolean access$isAccountUnique(GithubAccountsPanel $this, @NotNull String login2, @NotNull GithubServerPath server) {
        return $this.isAccountUnique(login2, server);
    }

    public static final /* synthetic */ void access$editAccount(GithubAccountsPanel $this, @NotNull GithubAccountDecorator decorator) {
        $this.editAccount(decorator);
    }

    @NotNull
    public static final /* synthetic */ GithubAccountInformationProvider access$getAccountInformationProvider$p(GithubAccountsPanel $this) {
        return $this.accountInformationProvider;
    }

    @NotNull
    public static final /* synthetic */ GithubApiTaskExecutor access$getApiTaskExecutor$p(GithubAccountsPanel $this) {
        return $this.apiTaskExecutor;
    }

    public static final /* synthetic */ void access$setLinkHandlerEnabled(GithubAccountsPanel $this, boolean enabled) {
        $this.setLinkHandlerEnabled(enabled);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$Companion;", "", "()V", "layoutRecursively", "", "component", "Ljava/awt/Component;", "intellij.vcs.github"})
    public static final class Companion {
        private final void layoutRecursively(Component component) {
            if (component instanceof JComponent) {
                component.doLayout();
                Component[] componentArray = ((JComponent)component).getComponents();
                int n = componentArray.length;
                for (int i = 0; i < n; ++i) {
                    Component child;
                    Component component2 = child = componentArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)component2, (String)"child");
                    this.layoutRecursively(component2);
                }
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$layoutRecursively(Companion $this, @NotNull Component component) {
            $this.layoutRecursively(component);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

