/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastLiteralUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0003\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u000e\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u000e\u001a\n\u0010\u0012\u001a\u00020\u0010*\u00020\u000e\u001a\n\u0010\u0013\u001a\u00020\u0010*\u00020\u000e\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u000e\u001a\n\u0010\u0015\u001a\u00020\u0010*\u00020\u000e\u001a\n\u0010\u0016\u001a\u00020\u0010*\u00020\u000e\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"injectedReferences", "", "Lcom/intellij/psi/PsiReference;", "Lorg/jetbrains/uast/ULiteralExpression;", "getInjectedReferences", "(Lorg/jetbrains/uast/ULiteralExpression;)Ljava/lang/Iterable;", "psiLanguageInjectionHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "getPsiLanguageInjectionHost", "(Lorg/jetbrains/uast/ULiteralExpression;)Lcom/intellij/psi/PsiLanguageInjectionHost;", "getLongValue", "", "getValueIfStringLiteral", "", "Lorg/jetbrains/uast/UElement;", "isBooleanLiteral", "", "isFalseLiteral", "isIntegralLiteral", "isNullLiteral", "isNumberLiteral", "isStringLiteral", "isTrueLiteral", "intellij.platform.uast"})
@JvmName(name="UastLiteralUtils")
public final class UastLiteralUtils {
    public static final boolean isNullLiteral(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ULiteralExpression && ((ULiteralExpression)$receiver).isNull();
    }

    public static final boolean isBooleanLiteral(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ULiteralExpression && ((ULiteralExpression)$receiver).isBoolean();
    }

    public static final boolean isTrueLiteral(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ULiteralExpression && ((ULiteralExpression)$receiver).isBoolean() && Intrinsics.areEqual((Object)((ULiteralExpression)$receiver).getValue(), (Object)true);
    }

    public static final boolean isFalseLiteral(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ULiteralExpression && ((ULiteralExpression)$receiver).isBoolean() && Intrinsics.areEqual((Object)((ULiteralExpression)$receiver).getValue(), (Object)false);
    }

    public static final boolean isStringLiteral(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ULiteralExpression && ((ULiteralExpression)$receiver).isString();
    }

    @Nullable
    public static final String getValueIfStringLiteral(@NotNull UElement $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (UastLiteralUtils.isStringLiteral($receiver)) {
            Object object = ((ULiteralExpression)$receiver).getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)object;
        } else {
            string = null;
        }
        return string;
    }

    public static final boolean isNumberLiteral(@NotNull UElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ULiteralExpression && ((ULiteralExpression)$receiver).getValue() instanceof Number;
    }

    public static final boolean isIntegralLiteral(@NotNull UElement $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ULiteralExpression && ((object = ((ULiteralExpression)$receiver).getValue()) instanceof Integer ? true : (object instanceof Long ? true : (object instanceof Short ? true : (object instanceof Character ? true : object instanceof Byte))));
    }

    public static final long getLongValue(@NotNull ULiteralExpression $receiver) {
        Object object;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object2 = it = (object = $receiver.getValue());
        return object2 instanceof Long ? ((Number)it).longValue() : (object2 instanceof Integer ? (long)((Number)it).intValue() : (object2 instanceof Short ? (long)((Number)it).shortValue() : (object2 instanceof Character ? (long)((Character)it).charValue() : (object2 instanceof Byte ? (long)((Number)it).byteValue() : 0L))));
    }

    @Nullable
    public static final PsiLanguageInjectionHost getPsiLanguageInjectionHost(@NotNull ULiteralExpression $receiver) {
        PsiLanguageInjectionHost psiLanguageInjectionHost;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement = $receiver.getPsi();
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = psiElement;
            psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)it, PsiLanguageInjectionHost.class, (boolean)false);
        } else {
            psiLanguageInjectionHost = null;
        }
        return psiLanguageInjectionHost;
    }

    @NotNull
    public static final Iterable<PsiReference> getInjectedReferences(@NotNull ULiteralExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiLanguageInjectionHost psiLanguageInjectionHost = UastLiteralUtils.getPsiLanguageInjectionHost($receiver);
        if (psiLanguageInjectionHost == null) {
            return CollectionsKt.emptyList();
        }
        PsiLanguageInjectionHost element = psiLanguageInjectionHost;
        Object[] objectArray = element.getReferences();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"element.references");
        Sequence references = ArraysKt.asSequence((Object[])objectArray);
        Object[] objectArray2 = element.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"element.children");
        Sequence innerReferences2 = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray2), (Function1)injectedReferences.innerReferences.1.INSTANCE);
        return SequencesKt.asIterable((Sequence)SequencesKt.plus((Sequence)references, (Sequence)innerReferences2));
    }
}

