/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard ourOverloadGuard = RecursionManager.createGuard((String)"overload.guard");
    public static final ThreadLocal<Map<PsiElement, CurrentCandidateProperties>> CURRENT_CANDIDATE = new ThreadLocal();
    @ApplicabilityLevelConstant
    private volatile int myApplicabilityLevel;
    @ApplicabilityLevelConstant
    private volatile int myPertinentApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private volatile String myInferenceError;
    private final ThreadLocal<String> myApplicabilityError;
    private final LanguageLevel myLanguageLevel;

    public MethodCandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments) {
        if (candidate == null) {
            MethodCandidateInfo.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(1);
        }
        this(candidate, substitutor, accessProblem, staticsProblem, argumentList, currFileContext, argumentTypes, typeArguments, PsiUtil.getLanguageLevel(argumentList));
    }

    public MethodCandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments, @NotNull LanguageLevel languageLevel) {
        if (candidate == null) {
            MethodCandidateInfo.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(3);
        }
        if (languageLevel == null) {
            MethodCandidateInfo.$$$reportNull$$$0(4);
        }
        super(candidate, substitutor, accessProblem, staticsProblem, currFileContext);
        this.myApplicabilityError = new ThreadLocal();
        this.myArgumentList = argumentList;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isVarargs() {
        return false;
    }

    public boolean isApplicable() {
        return this.getPertinentApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        PsiType[] argumentTypes = this.getArgumentTypes();
        if (argumentTypes == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), argumentTypes, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        int result = this.myApplicabilityLevel;
        if (result == 0) {
            this.myApplicabilityLevel = result = this.getApplicabilityLevelInner();
        }
        return result;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        int result = this.myPertinentApplicabilityLevel;
        if (result == 0) {
            this.myPertinentApplicabilityLevel = result = this.getPertinentApplicabilityLevelInner();
        }
        return result;
    }

    @ApplicabilityLevelConstant
    private int getPertinentApplicabilityLevelInner() {
        if (this.myArgumentList == null || !this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return this.getApplicabilityLevel();
        }
        PsiMethod method = this.getElement();
        if (this.isToInferApplicability()) {
            if (!MethodCandidateInfo.isOverloadCheck()) {
                this.getSubstitutor(false);
            }
            if (this.myApplicabilityError.get() != null || this.isPotentiallyCompatible() != ThreeState.YES) {
                return 1;
            }
            return this.isVarargs() ? 2 : 3;
        }
        PsiSubstitutor substitutor = this.getSubstitutor(false);
        int level = (Integer)this.computeForOverloadedCandidate(() -> {
            PsiType[] argumentTypes = this.getArgumentTypes();
            if (argumentTypes == null) {
                return 1;
            }
            int level1 = PsiUtil.getApplicabilityLevel(method, substitutor, argumentTypes, this.myLanguageLevel);
            if (!this.isVarargs() && level1 < 3) {
                return 1;
            }
            return level1;
        }, substitutor, this.isVarargs(), true);
        if (level > 1 && !this.isTypeArgumentsApplicable((Computable<PsiSubstitutor>)((Computable)() -> substitutor))) {
            level = 1;
        }
        return level;
    }

    public boolean isToInferApplicability() {
        return this.myTypeArguments == null && this.getElement().hasTypeParameters() && !this.isRawSubstitution();
    }

    public ThreeState isPotentiallyCompatible() {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiMethod method = this.getElement();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiExpression[] expressions = ((PsiExpressionList)this.myArgumentList).getExpressions();
            if (!this.isVarargs() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                if (expressions.length != parameters.length) {
                    return ThreeState.NO;
                }
            } else {
                if (expressions.length < parameters.length - 1) {
                    return ThreeState.NO;
                }
                if (parameters.length == 0 && expressions.length != parameters.length) {
                    return ThreeState.NO;
                }
            }
            boolean unsure = false;
            for (int i = 0; i < expressions.length; ++i) {
                ThreeState compatible;
                PsiType formalParameterType;
                PsiExpression expression = expressions[i];
                PsiType psiType = formalParameterType = i < parameters.length ? parameters[i].getType() : parameters[parameters.length - 1].getType();
                if (formalParameterType instanceof PsiEllipsisType && this.isVarargs()) {
                    formalParameterType = ((PsiEllipsisType)formalParameterType).getComponentType();
                }
                if ((compatible = MethodCandidateInfo.isPotentialCompatible(expression, this.getSiteSubstitutor().substitute(formalParameterType), method)) == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (compatible != ThreeState.UNSURE) continue;
                unsure = true;
            }
            if (unsure) {
                return ThreeState.UNSURE;
            }
            if (method.hasTypeParameters() && this.myTypeArguments != null) {
                return ThreeState.fromBoolean((method.getTypeParameters().length == this.myTypeArguments.length ? 1 : 0) != 0);
            }
        }
        return ThreeState.YES;
    }

    private static ThreeState isPotentialCompatible(PsiExpression expression, PsiType formalType, PsiMethod method) {
        if (expression instanceof PsiFunctionalExpression) {
            PsiClass targetTypeParameter = PsiUtil.resolveClassInClassTypeOnly(formalType);
            if (targetTypeParameter instanceof PsiTypeParameter && method.equals(((PsiTypeParameter)targetTypeParameter).getOwner())) {
                return ThreeState.YES;
            }
            if (!LambdaUtil.isFunctionalType(formalType)) {
                return ThreeState.NO;
            }
            if (!((PsiFunctionalExpression)expression).isPotentiallyCompatible(formalType)) {
                return ThreeState.UNSURE;
            }
        } else {
            if (expression instanceof PsiParenthesizedExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiParenthesizedExpression)expression).getExpression(), formalType, method);
            }
            if (expression instanceof PsiConditionalExpression) {
                ThreeState thenCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression).getThenExpression(), formalType, method);
                ThreeState elseCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression).getElseExpression(), formalType, method);
                if (thenCompatible == ThreeState.NO || elseCompatible == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (thenCompatible == ThreeState.UNSURE || elseCompatible == ThreeState.UNSURE) {
                    return ThreeState.UNSURE;
                }
            }
        }
        return ThreeState.YES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T computeForOverloadedCandidate(Computable<T> computable, PsiSubstitutor substitutor, boolean varargs, boolean applicabilityCheck) {
        ConcurrentMap map = CURRENT_CANDIDATE.get();
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakMap();
            CURRENT_CANDIDATE.set(map);
        }
        PsiElement argumentList = this.getMarkerList();
        CurrentCandidateProperties alreadyThere = map.put(argumentList, new CurrentCandidateProperties(this, substitutor, varargs, applicabilityCheck));
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (alreadyThere == null) {
                map.remove(argumentList);
            } else {
                map.put(argumentList, alreadyThere);
            }
        }
    }

    @NotNull
    public PsiSubstitutor getSiteSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        if (this.myTypeArguments != null) {
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParams = method.getTypeParameters();
            for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
            }
        }
        PsiSubstitutor psiSubstitutor = incompleteSubstitutor;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.getSubstitutor(true);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(6);
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor = this.myCalcedSubstitutor;
        if (substitutor == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || MethodCandidateInfo.isOverloadCheck()) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                this.myApplicabilityError.remove();
                try {
                    PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                    if (!stackStamp.mayCacheNow() || MethodCandidateInfo.isOverloadCheck() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || this.getMarkerList() != null && PsiResolveHelper.ourGraphGuard.currentStack().contains(this.getMarkerList().getParent()) || LambdaUtil.isLambdaParameterCheck()) {
                        PsiSubstitutor psiSubstitutor = inferredSubstitutor;
                        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
                        if (psiSubstitutor2 == null) {
                            MethodCandidateInfo.$$$reportNull$$$0(7);
                        }
                        return psiSubstitutor2;
                    }
                    this.myInferenceError = this.myApplicabilityError.get();
                    this.myCalcedSubstitutor = substitutor = inferredSubstitutor;
                }
                finally {
                    if (includeReturnConstraint) {
                        this.myApplicabilityError.remove();
                    }
                }
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]), ++i) {
                }
                this.myCalcedSubstitutor = substitutor = incompleteSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(8);
        }
        return psiSubstitutor;
    }

    public static boolean isOverloadCheck() {
        return !ourOverloadGuard.currentStack().isEmpty();
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable((Computable<PsiSubstitutor>)((Computable)() -> this.getSubstitutor(false)));
    }

    private boolean isTypeArgumentsApplicable(Computable<PsiSubstitutor> computable) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, (PsiSubstitutor)computable.compute(), this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : null;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    @NotNull
    public PsiMethod getElement() {
        PsiMethod psiMethod = (PsiMethod)super.getElement();
        if (psiMethod == null) {
            MethodCandidateInfo.$$$reportNull$$$0(9);
        }
        return psiMethod;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(10);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(11);
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor inferSubstitutorFromArgs(@NotNull ParameterTypeInferencePolicy policy, PsiExpression[] arguments) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(12);
        }
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy, arguments, true);
        }
        return this.getSiteSubstitutor();
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, @NotNull PsiExpression[] arguments, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(13);
        }
        if (arguments == null) {
            MethodCandidateInfo.$$$reportNull$$$0(14);
        }
        PsiSubstitutor psiSubstitutor = (PsiSubstitutor)this.computeForOverloadedCandidate(() -> {
            if (arguments == null) {
                MethodCandidateInfo.$$$reportNull$$$0(16);
            }
            if (policy == null) {
                MethodCandidateInfo.$$$reportNull$$$0(17);
            }
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParameters = method.getTypeParameters();
            if (this.isRawSubstitution()) {
                return JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(this.mySubstitutor, typeParameters);
            }
            PsiElement parent = this.getParent();
            if (parent == null) {
                return PsiSubstitutor.EMPTY;
            }
            Project project = method.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
            return javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters, method.getParameterList().getParameters(), arguments, this.mySubstitutor, parent, policy, this.myLanguageLevel);
        }, super.getSubstitutor(), policy.isVarargsIgnored() || this.isVarargs(), !includeReturnConstraint);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(15);
        }
        return psiSubstitutor;
    }

    public boolean isRawSubstitution() {
        PsiClass containingClass;
        PsiMethod method = this.getElement();
        return !method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor);
    }

    protected PsiElement getMarkerList() {
        return this.myArgumentList;
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public static CurrentCandidateProperties getCurrentMethod(PsiElement context) {
        Map<PsiElement, CurrentCandidateProperties> currentMethodCandidates = CURRENT_CANDIDATE.get();
        return currentMethodCandidates != null ? currentMethodCandidates.get(context) : null;
    }

    public static void updateSubstitutor(PsiElement context, PsiSubstitutor newSubstitutor) {
        CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(context);
        if (candidateProperties != null) {
            candidateProperties.setSubstitutor(newSubstitutor);
        }
    }

    @Nullable
    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.isVarargs() == ((MethodCandidateInfo)o).isVarargs();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isVarargs() ? 1 : 0);
    }

    public void setApplicabilityError(String applicabilityError) {
        this.myApplicabilityError.set(applicabilityError);
    }

    public String getInferenceErrorMessage() {
        this.getSubstitutor();
        return this.myInferenceError;
    }

    public String getInferenceErrorMessageAssumeAlreadyComputed() {
        return this.myInferenceError;
    }

    public CurrentCandidateProperties createProperties() {
        return new CurrentCandidateProperties(this, this.getSiteSubstitutor(), this.isVarargs(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiteSubstitutor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: {
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inferSubstitutorFromArgs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inferTypeArguments$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }

    public static class CurrentCandidateProperties {
        private final MethodCandidateInfo myMethod;
        private PsiSubstitutor mySubstitutor;
        private final boolean myVarargs;
        private final boolean myApplicabilityCheck;

        private CurrentCandidateProperties(MethodCandidateInfo info, PsiSubstitutor substitutor, boolean varargs, boolean applicabilityCheck) {
            this.myMethod = info;
            this.mySubstitutor = substitutor;
            this.myVarargs = varargs;
            this.myApplicabilityCheck = applicabilityCheck;
        }

        public PsiMethod getMethod() {
            return this.myMethod.getElement();
        }

        public MethodCandidateInfo getInfo() {
            return this.myMethod;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public void setSubstitutor(PsiSubstitutor substitutor) {
            this.mySubstitutor = substitutor;
        }

        public boolean isVarargs() {
            return this.myVarargs;
        }

        public boolean isApplicabilityCheck() {
            return this.myApplicabilityCheck;
        }
    }
}

