/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UExpression;

@ApiStatus.Experimental
public interface UastCallMatcher {
    @Contract(value="null -> false")
    public boolean testCallExpression(@Nullable UCallExpression var1);

    @Contract(value="null -> false")
    public boolean testCallableReferenceExpression(@Nullable UCallableReferenceExpression var1);

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            UastCallMatcher.$$$reportNull$$$0(0);
        }
        return builder;
    }

    @NotNull
    public static UastCallMatcher anyOf(final UastCallMatcher ... matchers) {
        if (matchers == null) {
            UastCallMatcher.$$$reportNull$$$0(1);
        }
        UastCallMatcher uastCallMatcher = new UastCallMatcher(){

            @Override
            public boolean testCallExpression(@Nullable UCallExpression expression) {
                return Arrays.stream(matchers).anyMatch(matcher -> matcher.testCallExpression(expression));
            }

            @Override
            public boolean testCallableReferenceExpression(@Nullable UCallableReferenceExpression expression) {
                return Arrays.stream(matchers).anyMatch(matcher -> matcher.testCallableReferenceExpression(expression));
            }
        };
        if (uastCallMatcher == null) {
            UastCallMatcher.$$$reportNull$$$0(2);
        }
        return uastCallMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/UastCallMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/UastCallMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "anyOf";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "anyOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private String myMethodName;
        private String[] myArguments;
        private boolean myMatchArgumentTypeInheritors;
        private String myReceiverTypeClassFqn;
        private String myReturnTypeClassFqn;

        @NotNull
        public Builder withMethodName(@NotNull String methodName) {
            if (methodName == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myMethodName = methodName;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder withReceiverType(@NotNull String receiverTypeClassFqn) {
            if (receiverTypeClassFqn == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myReceiverTypeClassFqn = receiverTypeClassFqn;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder withReturnType(@NotNull String returnTypeClassFqn) {
            if (returnTypeClassFqn == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myReturnTypeClassFqn = returnTypeClassFqn;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder withArgumentsCount(int argumentsCount) {
            this.myArguments = new String[argumentsCount];
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder withArgumentTypes(String ... arguments) {
            if (arguments == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myArguments = arguments;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder withMatchArgumentTypeInheritors(boolean matchArgumentTypeInheritors) {
            this.myMatchArgumentTypeInheritors = matchArgumentTypeInheritors;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public UastCallMatcher build() {
            SimpleUastCallMatcher simpleUastCallMatcher = new SimpleUastCallMatcher(this.myMethodName, this.myArguments, this.myMatchArgumentTypeInheritors, this.myReceiverTypeClassFqn, this.myReturnTypeClassFqn);
            if (simpleUastCallMatcher == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return simpleUastCallMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/UastCallMatcher$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiverTypeClassFqn";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnTypeClassFqn";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/UastCallMatcher$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withMethodName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withReceiverType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withReturnType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withArgumentsCount";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withArgumentTypes";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withMatchArgumentTypeInheritors";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withMethodName";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withReceiverType";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withReturnType";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withArgumentTypes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SimpleUastCallMatcher
    implements UastCallMatcher {
        private final String myMethodName;
        private final String[] myArguments;
        private final boolean myMatchArgumentTypeInheritors;
        private final String myReceiverTypeClassFqn;
        private final String myReturnTypeClassFqn;

        public SimpleUastCallMatcher(@Nullable String methodName, @Nullable String[] arguments, boolean matchArgumentTypeInheritors, @Nullable String receiverTypeClassFqn, @Nullable String returnTypeClassFqn) {
            if (methodName == null && arguments == null && receiverTypeClassFqn == null && returnTypeClassFqn == null) {
                throw new IllegalArgumentException("At least one qualifier must be specified");
            }
            this.myMethodName = methodName;
            this.myArguments = arguments;
            this.myMatchArgumentTypeInheritors = matchArgumentTypeInheritors;
            this.myReceiverTypeClassFqn = receiverTypeClassFqn;
            this.myReturnTypeClassFqn = returnTypeClassFqn;
        }

        @Override
        public boolean testCallExpression(@Nullable UCallExpression expression) {
            if (expression == null || expression.getMethodName() == null) {
                return false;
            }
            return this.methodNameMatches(expression) && this.receiverTypeMatches(expression) && this.returnTypeMatches(expression) && this.argumentsMatch(expression);
        }

        @Override
        public boolean testCallableReferenceExpression(@Nullable UCallableReferenceExpression expression) {
            return false;
        }

        private boolean methodNameMatches(@NotNull UCallExpression expression) {
            if (expression == null) {
                SimpleUastCallMatcher.$$$reportNull$$$0(0);
            }
            return this.myMethodName == null || this.myMethodName.equals(expression.getMethodName());
        }

        private boolean receiverTypeMatches(@NotNull UCallExpression expression) {
            if (expression == null) {
                SimpleUastCallMatcher.$$$reportNull$$$0(1);
            }
            return this.myReceiverTypeClassFqn == null || this.myReceiverTypeClassFqn.equals(AnalysisUastUtil.getExpressionReceiverTypeClassFqn(expression));
        }

        private boolean returnTypeMatches(@NotNull UCallExpression expression) {
            if (expression == null) {
                SimpleUastCallMatcher.$$$reportNull$$$0(2);
            }
            return this.myReturnTypeClassFqn == null || this.myReturnTypeClassFqn.equals(AnalysisUastUtil.getExpressionReturnTypePsiClassFqn(expression));
        }

        private boolean argumentsMatch(@NotNull UCallExpression expression) {
            if (expression == null) {
                SimpleUastCallMatcher.$$$reportNull$$$0(3);
            }
            if (this.myArguments == null) {
                return true;
            }
            if (this.myArguments.length != expression.getValueArgumentCount()) {
                return false;
            }
            List<UExpression> argumentExpressions = null;
            for (int i = 0; i < this.myArguments.length; ++i) {
                String requiredArgumentTypeClassFqn = this.myArguments[i];
                if (requiredArgumentTypeClassFqn == null) continue;
                if (argumentExpressions == null) {
                    argumentExpressions = expression.getValueArguments();
                }
                UExpression argumentExpression = argumentExpressions.get(i);
                PsiType argumentExpressionType = argumentExpression.getExpressionType();
                if (!this.myMatchArgumentTypeInheritors) {
                    if (requiredArgumentTypeClassFqn.equals(AnalysisUastUtil.getTypeClassFqn(argumentExpressionType))) continue;
                    return false;
                }
                PsiClass argumentExpressionTypeClass = AnalysisUastUtil.getTypePsiClass(argumentExpressionType);
                if (argumentExpressionTypeClass == null) {
                    return false;
                }
                LinkedHashSet<PsiClass> expressionTypeSupers = InheritanceUtil.getSuperClasses(argumentExpressionTypeClass);
                boolean argumentMatches = false;
                for (PsiClass expressionTypeSuper : expressionTypeSupers) {
                    if (!requiredArgumentTypeClassFqn.equals(expressionTypeSuper.getQualifiedName())) continue;
                    argumentMatches = true;
                    break;
                }
                if (argumentMatches) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/intellij/codeInspection/UastCallMatcher$SimpleUastCallMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "methodNameMatches";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "receiverTypeMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "returnTypeMatches";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "argumentsMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

