/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@ApiStatus.Experimental
public final class AnalysisUastUtil {
    @Nullable
    public static UCallExpression getUCallExpression(@NotNull PsiElement element) {
        UCallExpression callExpression;
        if (element == null) {
            AnalysisUastUtil.$$$reportNull$$$0(0);
        }
        if ((callExpression = UastContextKt.toUElement(element, UCallExpression.class)) == null) {
            return null;
        }
        if (callExpression.getSourcePsi() != element) {
            return null;
        }
        return callExpression;
    }

    @Nullable
    public static PsiElement getMethodIdentifierSourcePsi(@NotNull UCallExpression callExpression) {
        UIdentifier methodIdentifier;
        if (callExpression == null) {
            AnalysisUastUtil.$$$reportNull$$$0(1);
        }
        if ((methodIdentifier = callExpression.getMethodIdentifier()) == null) {
            return null;
        }
        return methodIdentifier.getSourcePsi();
    }

    @Nullable
    public static String getExpressionReturnTypePsiClassFqn(@NotNull UCallExpression expression) {
        if (expression == null) {
            AnalysisUastUtil.$$$reportNull$$$0(2);
        }
        return AnalysisUastUtil.getTypeClassFqn(expression.getReturnType());
    }

    @Nullable
    public static PsiClass getTypePsiClass(@Nullable PsiType type) {
        if (!((type = GenericsUtil.eliminateWildcards(type)) instanceof PsiClassType)) {
            return null;
        }
        return ((PsiClassType)type).rawType().resolve();
    }

    @Nullable
    public static String getExpressionReceiverTypeClassFqn(@NotNull UCallExpression expression) {
        if (expression == null) {
            AnalysisUastUtil.$$$reportNull$$$0(3);
        }
        return AnalysisUastUtil.getTypeClassFqn(expression.getReceiverType());
    }

    @Nullable
    public static String getTypeClassFqn(@Nullable PsiType type) {
        PsiClass psiClass = AnalysisUastUtil.getTypePsiClass(type);
        if (psiClass == null) {
            return null;
        }
        return psiClass.getQualifiedName();
    }

    public static boolean isExpressionResultValueUsed(@NotNull UCallExpression expression) {
        if (expression == null) {
            AnalysisUastUtil.$$$reportNull$$$0(4);
        }
        UElement currentParent = expression;
        while ((currentParent = currentParent.getUastParent()) != null) {
            UExpression selector;
            ProgressManager.checkCanceled();
            if (currentParent instanceof UReturnExpression || currentParent instanceof ULocalVariable || currentParent instanceof UField || currentParent instanceof UBinaryExpression || currentParent instanceof UCallExpression) {
                return true;
            }
            if (currentParent instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)currentParent).getSelector()) instanceof UCallExpression && !selector.equals(expression)) {
                return true;
            }
            if (!(currentParent instanceof UMethod) && !(currentParent instanceof UClass) && !(currentParent instanceof UFile)) continue;
        }
        return currentParent instanceof UMethod && !(((UMethod)currentParent).getUastBody() instanceof UBlockExpression);
    }

    public static PsiType getContainingMethodOrLambdaReturnType(UCallExpression expression) {
        for (UElement parent = expression.getUastParent(); parent != null; parent = parent.getUastParent()) {
            if (parent instanceof UMethod) {
                return ((UMethod)parent).getReturnType();
            }
            if (parent instanceof ULambdaExpression) {
                PsiType lambdaType = ((ULambdaExpression)parent).getBody().getExpressionType();
                if (lambdaType != null) {
                    return lambdaType;
                }
                PsiType functionalInterfaceType = ((ULambdaExpression)parent).getFunctionalInterfaceType();
                if (functionalInterfaceType != null) {
                    return LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                }
                UElement lambdaParent = parent.getUastParent();
                if (lambdaParent instanceof UCallExpression) {
                    PsiParameter lambdaParameter = UastUtils.getParameterForArgument((UCallExpression)lambdaParent, (ULambdaExpression)parent);
                    if (lambdaParameter == null) {
                        return null;
                    }
                    return LambdaUtil.getFunctionalInterfaceReturnType(lambdaParameter.getType());
                }
                return null;
            }
            if (!(parent instanceof UClass)) continue;
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/AnalysisUastUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUCallExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodIdentifierSourcePsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionReturnTypePsiClassFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionReceiverTypeClassFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpressionResultValueUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

