/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CheckerFrameworkNullityUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;
    protected static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    protected static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "javax.annotation.CheckForNull", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable", "androidx.annotation.Nullable", "org.checkerframework.checker.nullness.qual.Nullable", "org.checkerframework.checker.nullness.compatqual.NullableDecl", "org.checkerframework.checker.nullness.compatqual.NullableType"};
    static final String[] DEFAULT_NOT_NULLS = new String[]{NotNull.class.getName(), "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull", "androidx.annotation.NonNull", "org.checkerframework.checker.nullness.qual.NonNull", "org.checkerframework.checker.nullness.compatqual.NonNullDecl", "org.checkerframework.checker.nullness.compatqual.NonNullType"};
    private static final List<String> DEFAULT_ALL = Arrays.asList(ArrayUtil.mergeArrays((String[])DEFAULT_NULLABLES, (String[])DEFAULT_NOT_NULLS));

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    public static NullableNotNullManager getInstance(Project project) {
        return (NullableNotNullManager)ServiceManager.getService((Project)project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(0);
        }
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(1);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, true);
    }

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(2);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, false);
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(3);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(4);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(5);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(6);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(7);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(8);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation, PsiModifierListOwner target) {
        PsiModifierList modifierList;
        String qualifiedName;
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(9);
        }
        if (!AnnotationTargetUtil.isTypeAnnotation(annotation) && (qualifiedName = annotation.getQualifiedName()) != null && (modifierList = target.getModifierList()) != null && !modifierList.hasAnnotation(qualifiedName)) {
            return modifierList.addAnnotation(qualifiedName);
        }
        return null;
    }

    public PsiAnnotation copyNotNullAnnotation(PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info = this.findOwnNullabilityInfo(owner);
        if (info == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(owner, info.getAnnotation());
    }

    private static PsiAnnotation copyAnnotation(PsiModifierListOwner owner, @NotNull PsiAnnotation annotation) {
        String qualifiedName;
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(10);
        }
        return (qualifiedName = annotation.getQualifiedName()) != null ? JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + qualifiedName, owner) : null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    private PsiAnnotation findNullityAnnotationWithDefault(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        List<PsiParameter> superParameters;
        int flags;
        PsiAnnotation annotation;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(11);
        }
        if ((annotation = this.findPlainNullityAnnotation(owner, checkBases)) != null) {
            List<String> contradictory;
            String qName = annotation.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list = contradictory = nullable ? this.getNotNullsWithNickNames() : this.getNullablesWithNickNames();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation;
        }
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> annotations = Arrays.asList(nullable ? DEFAULT_NOT_NULLS : DEFAULT_NULLABLES);
        if (AnnotationUtil.isAnnotated(owner, annotations, flags = (checkBases ? 1 : 0) | 2 | 4 | 8)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        if (owner instanceof PsiParameter && !nullable && checkBases && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            return this.takeAnnotationFromSuperParameters((PsiParameter)owner, superParameters);
        }
        NullabilityAnnotationInfo nullityDefault = this.findNullityDefaultInHierarchy(owner);
        Nullability wantedNullability = nullable ? Nullability.NULLABLE : Nullability.NOT_NULL;
        return nullityDefault != null && nullityDefault.getNullability() == wantedNullability ? nullityDefault.getAnnotation() : null;
    }

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(12);
        }
        if ((type = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> nullables = this.getNullablesWithNickNames();
        HashSet annotationNames = ContainerUtil.newHashSet(nullables);
        annotationNames.addAll(this.getNotNullsWithNickNames());
        PsiAnnotation annotation = this.findPlainNullityAnnotation(owner, false);
        if (annotation != null) {
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        return null;
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(13);
        }
        if ((type = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue((PsiElement)owner, () -> {
            if (owner == null) {
                NullableNotNullManager.$$$reportNull$$$0(30);
            }
            return CachedValueProvider.Result.create((Object)this.doFindEffectiveNullabilityAnnotation(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(14);
        }
        List<String> nullables = this.getNullablesWithNickNames();
        HashSet annotationNames = ContainerUtil.newHashSet(nullables);
        annotationNames.addAll(this.getNotNullsWithNickNames());
        Set extraAnnotations = DEFAULT_ALL.stream().filter(anno -> !annotationNames.contains(anno)).collect(Collectors.toSet());
        annotationNames.addAll(extraAnnotations);
        PsiAnnotation annotation = NullableNotNullManager.findPlainAnnotation(owner, true, annotationNames);
        if (annotation != null) {
            if (extraAnnotations.contains(annotation.getQualifiedName())) {
                return null;
            }
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                PsiAnnotation plain = NullableNotNullManager.findPlainAnnotation(parameter, false, annotationNames);
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(parameter);
                if (defaultInfo == null) continue;
                return defaultInfo.getNullability() == Nullability.NOT_NULL ? defaultInfo : null;
            }
            return null;
        }
        NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(owner);
        if (!(defaultInfo == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    private PsiAnnotation takeAnnotationFromSuperParameters(@NotNull PsiParameter owner, List<PsiParameter> superOwners) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(15);
        }
        return (PsiAnnotation)RecursionManager.doPreventingRecursion((Object)owner, (boolean)true, () -> {
            for (PsiParameter superOwner : superOwners) {
                PsiAnnotation anno = this.findNullityAnnotationWithDefault(superOwner, false, false);
                if (anno == null) continue;
                return anno;
            }
            return null;
        });
    }

    private PsiAnnotation findPlainNullityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(16);
        }
        HashSet qNames = ContainerUtil.newHashSet(this.getNullablesWithNickNames());
        qNames.addAll(this.getNotNullsWithNickNames());
        return NullableNotNullManager.findPlainAnnotation(owner, checkBases, qNames);
    }

    @Nullable
    private static PsiAnnotation findPlainAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, Set<String> qualifiedNames) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(17);
        }
        PsiAnnotation memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qualifiedNames) : AnnotationUtil.findAnnotation(owner, qualifiedNames);
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null) {
            return NullableNotNullManager.preferTypeAnnotation(memberAnno, type);
        }
        if (type != null) {
            return (PsiAnnotation)ContainerUtil.find((Object[])type.getAnnotations(), a -> qualifiedNames.contains(a.getQualifiedName()));
        }
        return null;
    }

    private static PsiAnnotation preferTypeAnnotation(@NotNull PsiAnnotation memberAnno, @Nullable PsiType type) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(18);
        }
        if (type != null) {
            for (PsiAnnotation typeAnno : type.getApplicableAnnotations()) {
                if (!NullableNotNullManager.areDifferentNullityAnnotations(memberAnno, typeAnno)) continue;
                return typeAnno;
            }
        }
        return memberAnno;
    }

    private static boolean areDifferentNullityAnnotations(@NotNull PsiAnnotation memberAnno, PsiAnnotation typeAnno) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(19);
        }
        return NullableNotNullManager.isNullableAnnotation(typeAnno) && NullableNotNullManager.isNotNullAnnotation(memberAnno) || NullableNotNullManager.isNullableAnnotation(memberAnno) && NullableNotNullManager.isNotNullAnnotation(typeAnno);
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List<String> list = this.getNullables();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List<String> list = this.getNotNulls();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    protected boolean hasHardcodedContracts(PsiElement element) {
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(PsiModifierListOwner owner) {
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(22);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(23);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    @Nullable
    NullabilityAnnotationInfo findNullityDefaultInHierarchy(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(24);
        }
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result;
            if (element instanceof PsiModifierListOwner && (result = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, false)) != null) {
                return result;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            return this.findNullityDefaultOnPackage(placeTargetTypes, JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName));
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(PsiAnnotation.TargetType[] placeTargetTypes, @Nullable PsiPackage psiPackage) {
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo getNullityDefault(PsiModifierListOwner container, PsiAnnotation.TargetType[] placeTargetTypes, boolean superPackage) {
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList == null) {
            return null;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            NullabilityAnnotationInfo result = this.checkNullityDefault(annotation, placeTargetTypes, superPackage);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo checkNullityDefault(PsiAnnotation annotation, PsiAnnotation.TargetType[] placeTargetTypes, boolean superPackage) {
        NullabilityAnnotationInfo jsr = superPackage ? null : this.isJsr305Default(annotation, placeTargetTypes);
        return jsr != null ? jsr : CheckerFrameworkNullityUtil.isCheckerDefault(annotation, placeTargetTypes);
    }

    @Nullable
    protected abstract NullabilityAnnotationInfo isJsr305Default(@NotNull PsiAnnotation var1, @NotNull PsiAnnotation.TargetType[] var2);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(25);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(26);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(27);
        }
        return (info = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner)) == null ? Nullability.UNKNOWN : info.getNullability();
    }

    @NotNull
    public abstract List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullableAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(28);
        }
        return NullableNotNullManager.getInstance(annotation.getProject()).getNullablesWithNickNames().contains(annotation.getQualifiedName());
    }

    public static boolean isNotNullAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(29);
        }
        return NullableNotNullManager.getInstance(annotation.getProject()).getNotNullsWithNickNames().contains(annotation.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 9: 
            case 10: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberAnno";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasNullability";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNullableAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullAnnotation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyNotNullAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableAnnotation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableOrNotNullAnnotation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findNullityAnnotationWithDefault";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOwnNullabilityInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findEffectiveNullabilityInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doFindEffectiveNullabilityAnnotation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "takeAnnotationFromSuperParameters";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPlainNullityAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPlainAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "preferTypeAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "areDifferentNullityAnnotations";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultInHierarchy";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNullability";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isNullableAnnotation";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullAnnotation";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findEffectiveNullabilityInfo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

