/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class NullableNotNullDialog
extends DialogWrapper {
    private final Project myProject;
    private final AnnotationsPanel myNullablePanel;
    private final AnnotationsPanel myNotNullPanel;
    private final boolean myShowInstrumentationOptions;

    public NullableNotNullDialog(@NotNull Project project) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    private NullableNotNullDialog(@NotNull Project project, boolean showInstrumentationOptions) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myShowInstrumentationOptions = showInstrumentationOptions;
        NullableNotNullManager manager = NullableNotNullManager.getInstance(this.myProject);
        this.myNullablePanel = new AnnotationsPanel("Nullable", manager.getDefaultNullable(), manager.getNullables(), NullableNotNullManager.DEFAULT_NULLABLES, Collections.emptySet(), false);
        this.myNotNullPanel = new AnnotationsPanel("NotNull", manager.getDefaultNotNull(), manager.getNotNulls(), NullableNotNullManager.DEFAULT_NOT_NULLS, ContainerUtil.newHashSet(manager.getInstrumentedNotNulls()), showInstrumentationOptions);
        this.init();
        this.setTitle("Nullable/NotNull Configuration");
    }

    public static JButton createConfigureAnnotationsButton(Component context) {
        JButton button = new JButton(InspectionsBundle.message((String)"configure.annotations.option", (Object[])new Object[0]));
        button.addActionListener(NullableNotNullDialog.createActionListener(context));
        return button;
    }

    public static ActionListener createActionListener(final Component context) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NullableNotNullDialog.showDialog(context, false);
            }
        };
    }

    public static void showDialogWithInstrumentationOptions(@NotNull Component context) {
        if (context == null) {
            NullableNotNullDialog.$$$reportNull$$$0(2);
        }
        NullableNotNullDialog.showDialog(context, true);
    }

    private static void showDialog(Component context, boolean showInstrumentationOptions) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context));
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        NullableNotNullDialog dialog = new NullableNotNullDialog(project, showInstrumentationOptions);
        dialog.show();
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent(this.myNullablePanel.getComponent());
        splitter.setSecondComponent(this.myNotNullPanel.getComponent());
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setPreferredSize((Dimension)JBUI.size((int)300, (int)400));
        return splitter;
    }

    protected void doOKAction() {
        NullableNotNullManager manager = NullableNotNullManager.getInstance(this.myProject);
        manager.setNotNulls(this.myNotNullPanel.getAnnotations());
        manager.setDefaultNotNull(this.myNotNullPanel.getDefaultAnnotation());
        manager.setNullables(this.myNullablePanel.getAnnotations());
        manager.setDefaultNullable(this.myNullablePanel.getDefaultAnnotation());
        if (this.myShowInstrumentationOptions) {
            manager.setInstrumentedNotNulls(this.myNotNullPanel.getCheckedAnnotations());
        }
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/NullableNotNullDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogWithInstrumentationOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AnnotationsPanel {
        private String myDefaultAnnotation;
        private final Set<String> myDefaultAnnotations;
        private final JBTable myTable;
        private final JPanel myComponent;
        private final DefaultTableModel myTableModel;

        private AnnotationsPanel(String name, String defaultAnnotation, List<String> annotations, String[] defaultAnnotations, Set<String> checkedAnnotations, boolean showInstrumentationOptions) {
            this.myDefaultAnnotation = defaultAnnotation;
            this.myDefaultAnnotations = new HashSet<String>(Arrays.asList(defaultAnnotations));
            this.myTableModel = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 1;
                }
            };
            this.myTableModel.setColumnCount(showInstrumentationOptions ? 2 : 1);
            for (String annotation : annotations) {
                this.addRow(annotation, checkedAnnotations.contains(annotation));
            }
            DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
            columnModel.addColumn(new TableColumn(0, 100, (TableCellRenderer)new ColoredTableCellRenderer(){

                public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.acquireState(table, isSelected, false, row, column);
                }

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (value.equals(AnnotationsPanel.this.myDefaultAnnotation)) {
                        this.setIcon(AllIcons.Diff.CurrentLine);
                    } else {
                        this.setIcon(EmptyIcon.ICON_16);
                    }
                }
            }, null));
            if (showInstrumentationOptions) {
                columnModel.getColumn(0).setHeaderValue("Annotation");
                TableColumn checkColumn = new TableColumn(1, 100, (TableCellRenderer)new BooleanTableCellRenderer(), (TableCellEditor)new BooleanTableCellEditor());
                columnModel.addColumn(checkColumn);
                checkColumn.setHeaderValue(" Instrument ");
                DefaultTableCellHeaderRenderer renderer = new DefaultTableCellHeaderRenderer();
                renderer.setToolTipText("Add runtime assertions for notnull-annotated methods and parameters");
                checkColumn.setHeaderRenderer(renderer);
                checkColumn.sizeWidthToFit();
            }
            this.myTable = new JBTable((TableModel)this.myTableModel, (TableColumnModel)columnModel);
            AnActionButton selectButton = new AnActionButton("Select annotation used for code generation", AllIcons.Actions.Checked){

                public void actionPerformed(AnActionEvent e) {
                    String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                    if (selectedValue == null) {
                        return;
                    }
                    AnnotationsPanel.this.myDefaultAnnotation = selectedValue;
                    AnnotationsPanel.this.myTableModel.fireTableRowsUpdated(AnnotationsPanel.this.myTable.getSelectedRow(), AnnotationsPanel.this.myTable.getSelectedRow());
                }

                public void updateButton(AnActionEvent e) {
                    String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                    e.getPresentation().setEnabled(selectedValue != null && !selectedValue.equals(AnnotationsPanel.this.myDefaultAnnotation));
                }
            };
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().setAddAction(b -> this.chooseAnnotation(name)).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton anActionButton) {
                    String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                    if (selectedValue == null) {
                        return;
                    }
                    if (AnnotationsPanel.this.myDefaultAnnotation.equals(selectedValue)) {
                        AnnotationsPanel.this.myDefaultAnnotation = (String)AnnotationsPanel.this.myTable.getValueAt(0, 0);
                    }
                    AnnotationsPanel.this.myTableModel.removeRow(AnnotationsPanel.this.myTable.getSelectedRow());
                }
            }).setRemoveActionUpdater(e -> !this.myDefaultAnnotations.contains(this.getSelectedAnnotation())).addExtraAction(selectButton);
            JPanel panel = toolbarDecorator.createPanel();
            this.myComponent = new JPanel(new BorderLayout());
            this.myComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)(name + " annotations"), (boolean)false, (Insets)JBUI.insetsTop((int)10)));
            this.myComponent.add(panel);
            this.myComponent.setPreferredSize((Dimension)new JBDimension(this.myComponent.getPreferredSize().width, 200));
            this.myTable.setSelectionMode(0);
            this.myTable.setRowSelectionAllowed(true);
            this.myTable.setShowGrid(false);
            this.selectAnnotation(this.myDefaultAnnotation);
        }

        private void addRow(String annotation, boolean checked) {
            this.myTableModel.addRow(new Object[]{annotation, checked});
        }

        private Integer selectAnnotation(String annotation) {
            for (int i = 0; i < this.myTable.getRowCount(); ++i) {
                if (!annotation.equals(this.myTable.getValueAt(i, 0))) continue;
                this.myTable.setRowSelectionInterval(i, i);
                return i;
            }
            return null;
        }

        private String getSelectedAnnotation() {
            int selectedRow = this.myTable.getSelectedRow();
            return selectedRow < 0 ? null : (String)this.myTable.getValueAt(selectedRow, 0);
        }

        private void chooseAnnotation(String title) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance(NullableNotNullDialog.this.myProject).createNoInnerClassesScopeChooser("Choose " + title + " annotation", GlobalSearchScope.allScope((Project)NullableNotNullDialog.this.myProject), new ClassFilter(){

                @Override
                public boolean isAccepted(PsiClass aClass) {
                    return aClass.isAnnotationType();
                }
            }, null);
            chooser.showDialog();
            PsiClass selected = chooser.getSelected();
            if (selected == null) {
                return;
            }
            String qualifiedName = selected.getQualifiedName();
            if (this.selectAnnotation(qualifiedName) == null) {
                this.addRow(qualifiedName, false);
            }
        }

        JComponent getComponent() {
            return this.myComponent;
        }

        String getDefaultAnnotation() {
            return this.myDefaultAnnotation;
        }

        String[] getAnnotations() {
            int size = this.myTable.getRowCount();
            String[] result = new String[size];
            for (int i = 0; i < size; ++i) {
                result[i] = (String)this.myTable.getValueAt(i, 0);
            }
            return result;
        }

        List<String> getCheckedAnnotations() {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.myTable.getRowCount(); ++i) {
                if (!Boolean.TRUE.equals(this.myTable.getValueAt(i, 1))) continue;
                result.add((String)this.myTable.getValueAt(i, 0));
            }
            return result;
        }
    }
}

