/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.eclipse.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.eclipse.model.JpsEclipseClasspathReader;
import org.jetbrains.jps.eclipse.model.JpsIdeaSpecificSettings;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;

public class JpsEclipseClasspathSerializer
extends JpsModuleClasspathSerializer {
    @NonNls
    public static final String CLASSPATH_STORAGE_ID = "eclipse";
    private static final Logger LOG = Logger.getInstance(JpsEclipseClasspathSerializer.class);

    public JpsEclipseClasspathSerializer() {
        super(CLASSPATH_STORAGE_ID);
    }

    public void loadClasspath(@NotNull JpsModule module, @Nullable String classpathDir, @NotNull String baseModulePath, JpsMacroExpander expander, List<String> paths, JpsSdkType<?> projectSdkType) {
        if (module == null) {
            JpsEclipseClasspathSerializer.$$$reportNull$$$0(0);
        }
        if (baseModulePath == null) {
            JpsEclipseClasspathSerializer.$$$reportNull$$$0(1);
        }
        JpsDependenciesList dependenciesList = module.getDependenciesList();
        dependenciesList.clear();
        try {
            JpsIdeaSpecificSettings settings;
            Element root;
            File classpathFile;
            if (classpathDir == null) {
                classpathDir = baseModulePath;
            }
            if (!(classpathFile = new File(classpathDir, ".classpath")).exists()) {
                return;
            }
            String eml = module.getName() + ".eml";
            File emlFile = new File(baseModulePath, eml);
            HashMap<String, String> levels = new HashMap<String, String>();
            if (emlFile.isFile()) {
                root = JDOMUtil.load((File)emlFile);
                settings = new JpsIdeaSpecificSettings(expander);
                settings.initLevels(root, module, levels);
            } else {
                settings = null;
                root = null;
            }
            JpsEclipseClasspathReader reader = new JpsEclipseClasspathReader(classpathDir, paths, new HashSet<String>(), levels);
            reader.readClasspath(module, null, JDOMUtil.load((File)classpathFile), expander);
            if (settings != null) {
                settings.updateEntries(root, module, projectSdkType);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "baseModulePath";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/eclipse/model/JpsEclipseClasspathSerializer";
        objectArray[2] = "loadClasspath";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

