/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.javaee;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.Ear;
import org.jetbrains.plugins.gradle.model.data.EarConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.WebResource;
import org.jetbrains.plugins.gradle.model.ear.EarConfiguration;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaEEGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(JavaEEGradleProjectResolverExtension.class);

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, final @NotNull DataNode<ModuleData> ideModule) {
        EarConfiguration earConfiguration;
        if (gradleModule == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(0);
        }
        if (ideModule == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(1);
        }
        WebConfiguration webConfiguration = (WebConfiguration)this.resolverCtx.getExtraProject(gradleModule, WebConfiguration.class);
        NotNullLazyValue<DataNode<? extends ModuleData>> findTargetModuleNode = new NotNullLazyValue<DataNode<? extends ModuleData>>(){

            @NotNull
            protected DataNode<? extends ModuleData> compute() {
                String mainSourceSetModuleId = ((ModuleData)ideModule.getData()).getId() + ":main";
                DataNode targetModuleNode = ExternalSystemApiUtil.find((DataNode)ideModule, (Key)GradleSourceSetData.KEY, node -> mainSourceSetModuleId.equals(((GradleSourceSetData)node.getData()).getId()));
                if (targetModuleNode == null) {
                    targetModuleNode = ideModule;
                }
                DataNode dataNode = targetModuleNode;
                if (dataNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension$1", "compute"));
            }
        };
        if (webConfiguration != null) {
            List warModels = ContainerUtil.map((Collection)webConfiguration.getWarModels(), model -> {
                War war = new War(model.getWarName(), model.getWebAppDirName(), model.getWebAppDir());
                war.setWebXml(model.getWebXml());
                war.setWebResources(JavaEEGradleProjectResolverExtension.mapWebResources(model.getWebResources()));
                war.setClasspath(model.getClasspath());
                war.setManifestContent(model.getManifestContent());
                war.setArchivePath(model.getArchivePath());
                return war;
            });
            ((DataNode)findTargetModuleNode.getValue()).createChild(WebConfigurationModelData.KEY, (Object)new WebConfigurationModelData(GradleConstants.SYSTEM_ID, warModels));
        }
        if ((earConfiguration = (EarConfiguration)this.resolverCtx.getExtraProject(gradleModule, EarConfiguration.class)) != null) {
            List warModels = ContainerUtil.map((Collection)earConfiguration.getEarModels(), model -> {
                Ear ear = new Ear(model.getEarName(), model.getAppDirName(), model.getLibDirName());
                ear.setManifestContent(model.getManifestContent());
                ear.setDeploymentDescriptor(model.getDeploymentDescriptor());
                ear.setResources(JavaEEGradleProjectResolverExtension.mapEarResources(model.getResources()));
                ear.setArchivePath(model.getArchivePath());
                return ear;
            });
            Collection deployDependencies = GradleProjectResolverUtil.getIdeDependencies((ProjectResolverContext)this.resolverCtx, (DataNode)((DataNode)findTargetModuleNode.getValue()), (Collection)earConfiguration.getDeployDependencies());
            Collection earlibDependencies = GradleProjectResolverUtil.getIdeDependencies((ProjectResolverContext)this.resolverCtx, (DataNode)((DataNode)findTargetModuleNode.getValue()), (Collection)earConfiguration.getEarlibDependencies());
            ((DataNode)findTargetModuleNode.getValue()).createChild(EarConfigurationModelData.KEY, (Object)new EarConfigurationModelData(GradleConstants.SYSTEM_ID, warModels, deployDependencies, earlibDependencies));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{WebConfiguration.class, EarConfiguration.class});
        if (set == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static List<WebResource> mapWebResources(List<WebConfiguration.WebResource> webResources) {
        return ContainerUtil.mapNotNull(webResources, resource -> {
            if (resource == null) {
                return null;
            }
            WarDirectory warDirectory = WarDirectory.fromPath((String)resource.getWarDirectory());
            return new WebResource(warDirectory, resource.getRelativePath(), resource.getFile());
        });
    }

    private static List<EarResource> mapEarResources(List<EarConfiguration.EarResource> resources) {
        return ContainerUtil.mapNotNull(resources, resource -> {
            if (resource == null) {
                return null;
            }
            return new EarResource(resource.getEarDirectory(), resource.getRelativePath(), resource.getFile());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

