/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleApplicationEnvironmentProvider
implements GradleExecutionEnvironmentProvider {
    public boolean isApplicable(ExecuteRunConfigurationTask task) {
        return task.getRunProfile() instanceof ApplicationConfiguration;
    }

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask executeRunConfigurationTask, @Nullable Executor executor) {
        if (project == null) {
            GradleApplicationEnvironmentProvider.$$$reportNull$$$0(0);
        }
        if (executeRunConfigurationTask == null) {
            GradleApplicationEnvironmentProvider.$$$reportNull$$$0(1);
        }
        if (!this.isApplicable(executeRunConfigurationTask)) {
            return null;
        }
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)executeRunConfigurationTask.getRunProfile();
        PsiClass mainClass = applicationConfiguration.getMainClass();
        if (mainClass == null) {
            return null;
        }
        VirtualFile virtualFile = mainClass.getContainingFile().getVirtualFile();
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(virtualFile);
        if (module == null) {
            return null;
        }
        JavaParameters params = new JavaParameters();
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)applicationConfiguration);
        params.getVMParametersList().addParametersString(applicationConfiguration.getVMParameters());
        String javaModuleName = null;
        String javaExePath = null;
        try {
            Sdk jdk = JavaParametersUtil.createProjectJdk((Project)project, (String)applicationConfiguration.getAlternativeJrePath());
            if (jdk == null) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
            }
            SdkTypeId type = jdk.getSdkType();
            if (!(type instanceof JavaSdkType)) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
            }
            javaExePath = ((JavaSdkType)type).getVMExecutablePath(jdk);
            if (javaExePath == null) {
                throw new RuntimeException(ExecutionBundle.message((String)"run.configuration.cannot.find.vm.executable", (Object[])new Object[0]));
            }
            javaExePath = FileUtil.toSystemIndependentName((String)javaExePath);
            javaModuleName = GradleApplicationEnvironmentProvider.findJavaModuleName(jdk, (JavaRunConfigurationModule)applicationConfiguration.getConfigurationModule(), mainClass);
        }
        catch (CantRunException e) {
            ExecutionErrorDialog.show((ExecutionException)e, (String)"Cannot use specified JRE", (Project)project);
        }
        ExternalSystemTaskExecutionSettings taskSettings = new ExternalSystemTaskExecutionSettings();
        taskSettings.setPassParentEnvs(params.isPassParentEnvs());
        taskSettings.setEnv((Map)ContainerUtil.newHashMap((Map)params.getEnv()));
        taskSettings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        String projectPath = GradleRunnerUtil.resolveProjectPath(module);
        taskSettings.setExternalProjectPath(projectPath);
        String runAppTaskName = mainClass.getName() + ".main()";
        taskSettings.setTaskNames(Collections.singletonList(runAppTaskName));
        String executorId = executor == null ? DefaultRunExecutor.EXECUTOR_ID : executor.getId();
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskExecutionSettings)taskSettings, (String)executorId);
        if (environment != null) {
            String sourceSetName;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
            assert (runnerAndConfigurationSettings != null);
            ExternalSystemRunConfiguration gradleRunConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            String gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module);
            if (gradlePath == null) {
                return null;
            }
            if ("sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
                sourceSetName = GradleProjectResolverUtil.getSourceSetName((Module)module);
            } else {
                String string = sourceSetName = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile) ? "test" : "main";
            }
            if (sourceSetName == null) {
                return null;
            }
            String workingDir = ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)applicationConfiguration, (Project)project, (Module)module);
            workingDir = workingDir == null ? null : FileUtil.toSystemIndependentName((String)workingDir);
            String parametersString = GradleApplicationEnvironmentProvider.createEscapedParameters(params.getProgramParametersList().getParameters(), "args");
            String vmParametersString = GradleApplicationEnvironmentProvider.createEscapedParameters(params.getVMParametersList().getParameters(), "jvmArgs");
            String initScript = "allprojects {\n    afterEvaluate { project ->\n      if(project.path == '" + gradlePath + "' && project?.convention?.findPlugin(JavaPluginConvention)) {\n         project.tasks.create(name: '" + runAppTaskName + "', overwrite: true, type: JavaExec) {\n" + (javaExePath == null ? "" : "           executable = '" + javaExePath + "'\n") + "           classpath = project.sourceSets.'" + sourceSetName + "'.runtimeClasspath\n           main = '" + mainClass.getQualifiedName() + "'\n" + parametersString + vmParametersString + (StringUtil.isNotEmpty((String)workingDir) ? "           workingDir = '" + workingDir + "'\n" : "") + "           standardInput = System.in\n" + (javaModuleName == null ? "" : "           inputs.property('moduleName', '" + javaModuleName + "')\n           doFirst {\n             jvmArgs += [\n               '--module-path', classpath.asPath,\n               '--module', '" + javaModuleName + "/" + mainClass.getQualifiedName() + "'\n             ]\n             classpath = files()\n           }\n") + "         }\n      }\n    }\n}\n";
            gradleRunConfiguration.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
            List tasks = RunManagerImpl.getInstanceImpl((Project)project).getBeforeRunTasks((RunConfiguration)applicationConfiguration).stream().filter(task -> task.getProviderId() != CompileStepBeforeRun.ID).collect(Collectors.toList());
            gradleRunConfiguration.setBeforeRunTasks(tasks);
            return environment;
        }
        return null;
    }

    private static String createEscapedParameters(List<String> parameters, String prefix) {
        StringBuilder result = new StringBuilder();
        for (String parameter : parameters) {
            if (StringUtil.isEmpty((String)parameter)) continue;
            String escaped = StringUtil.escapeChars((String)parameter, (char[])new char[]{'\\', '\"', '\''});
            result.append(prefix).append(" '").append(escaped).append("'\n");
        }
        return result.toString();
    }

    @Nullable
    private static String findJavaModuleName(Sdk sdk, JavaRunConfigurationModule module, PsiClass mainClass) {
        PsiJavaModule mainModule;
        if (JavaSdkUtil.isJdkAtLeast((Sdk)sdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (mainModule = (PsiJavaModule)DumbService.getInstance((Project)module.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByElement((PsiElement)module.findClass(mainClass.getQualifiedName())))) != null) {
            return mainModule.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "executeRunConfigurationTask";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider";
        objectArray[2] = "createExecutionEnvironment";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

