/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.Location;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleTaskLocation;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GradleRunnerUtil {
    @Nullable
    public static Location<PsiMethod> getMethodLocation(@NotNull Location contextLocation) {
        PsiClass containingClass;
        MethodLocation methodLocation;
        if (contextLocation == null) {
            GradleRunnerUtil.$$$reportNull$$$0(0);
        }
        if ((methodLocation = GradleRunnerUtil.getTestMethod(contextLocation)) == null) {
            return null;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation && (containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
            methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
        }
        return methodLocation;
    }

    @Nullable
    public static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!TestFrameworks.getInstance().isTestMethod((PsiMethod)methodLocation.getPsiElement())) continue;
            return methodLocation;
        }
        return null;
    }

    @Nullable
    public static String resolveProjectPath(@NotNull Module module) {
        List buildParticipants;
        String compositeProjectPath;
        if (module == null) {
            GradleRunnerUtil.$$$reportNull$$$0(1);
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (rootProjectPath == null || projectPath == null) {
            return null;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)module.getProject()).getLinkedProjectSettings(rootProjectPath);
        if (projectSettings != null && projectSettings.getCompositeBuild() != null && projectSettings.getCompositeBuild().getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT && (compositeProjectPath = (String)(buildParticipants = projectSettings.getCompositeBuild().getCompositeParticipants()).stream().filter(participant -> participant.getProjects().contains(projectPath)).findFirst().map(BuildParticipant::getRootPath).orElse(null)) != null) {
            return compositeProjectPath;
        }
        return rootProjectPath;
    }

    public static boolean isFromGroovyGradleScript(@Nullable Location location) {
        if (location == null) {
            return false;
        }
        return GradleRunnerUtil.isFromGroovyGradleScript(location.getPsiElement());
    }

    public static boolean isFromGroovyGradleScript(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            GradleRunnerUtil.$$$reportNull$$$0(2);
        }
        if (!((file = element.getContainingFile()) instanceof GroovyFile)) {
            return false;
        }
        return "gradle".equals(file.getVirtualFile().getExtension());
    }

    @NotNull
    public static List<String> getTasksTarget(@Nullable Location location) {
        if (location == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GradleRunnerUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (location instanceof GradleTaskLocation) {
            List list = ((GradleTaskLocation)location).getTasks();
            if (list == null) {
                GradleRunnerUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        Module module = location.getModule();
        List<String> list = GradleRunnerUtil.getTasksTarget(location.getPsiElement(), module);
        if (list == null) {
            GradleRunnerUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<String> getTasksTarget(@NotNull PsiElement element, @Nullable Module module) {
        GrMethodCallExpression methodCallExpression;
        if (element == null) {
            GradleRunnerUtil.$$$reportNull$$$0(6);
        }
        PsiElement parent = element;
        while (parent.getParent() != null && !(parent.getParent() instanceof PsiFile)) {
            parent = parent.getParent();
        }
        if (GradleRunnerUtil.isCreateTaskMethod(parent)) {
            GrExpression[] arguments = ((GrMethodCallExpression)parent).getExpressionArguments();
            if (arguments.length > 0 && arguments[0] instanceof GrLiteral && ((GrLiteral)arguments[0]).getValue() instanceof String) {
                List<String> list = Collections.singletonList((String)((GrLiteral)arguments[0]).getValue());
                if (list == null) {
                    GradleRunnerUtil.$$$reportNull$$$0(7);
                }
                return list;
            }
        } else if (parent instanceof GrApplicationStatement) {
            PsiElement shiftExpression = parent.getChildren()[1].getChildren()[0];
            if (GradleResolverUtil.isLShiftElement(shiftExpression)) {
                PsiElement shiftiesChild = shiftExpression.getChildren()[0];
                if (shiftiesChild instanceof GrReferenceExpression) {
                    List<String> list = Collections.singletonList(shiftiesChild.getText());
                    if (list == null) {
                        GradleRunnerUtil.$$$reportNull$$$0(8);
                    }
                    return list;
                }
                if (shiftiesChild instanceof GrMethodCallExpression) {
                    List<String> list = Collections.singletonList(shiftiesChild.getChildren()[0].getText());
                    if (list == null) {
                        GradleRunnerUtil.$$$reportNull$$$0(9);
                    }
                    return list;
                }
            } else if (shiftExpression instanceof GrMethodCallExpression) {
                List<String> list = Collections.singletonList(shiftExpression.getChildren()[0].getText());
                if (list == null) {
                    GradleRunnerUtil.$$$reportNull$$$0(10);
                }
                return list;
            }
        }
        if ((methodCallExpression = (GrMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethodCallExpression.class)) != null) {
            GradleExtensionsSettings.GradleExtensionsData extensionsData;
            String taskNameCandidate = methodCallExpression.getChildren()[0].getText();
            Project project = element.getProject();
            if (module == null) {
                module = GradleRunnerUtil.getModule(element, project);
            }
            if ((extensionsData = GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(module)) != null) {
                for (GradleExtensionsSettings.GradleTask task : extensionsData.tasks) {
                    if (!taskNameCandidate.equals(task.name)) continue;
                    List<String> list = Collections.singletonList(taskNameCandidate);
                    if (list == null) {
                        GradleRunnerUtil.$$$reportNull$$$0(11);
                    }
                    return list;
                }
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GradleRunnerUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static Module getModule(@NotNull PsiElement element, @NotNull Project project) {
        VirtualFile virtualFile;
        PsiFile containingFile;
        if (element == null) {
            GradleRunnerUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GradleRunnerUtil.$$$reportNull$$$0(14);
        }
        if ((containingFile = element.getContainingFile()) != null && (virtualFile = containingFile.getVirtualFile()) != null) {
            return ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(virtualFile);
        }
        return null;
    }

    @NotNull
    public static List<String> getTasksTarget(@NotNull PsiElement element) {
        if (element == null) {
            GradleRunnerUtil.$$$reportNull$$$0(15);
        }
        List<String> list = GradleRunnerUtil.getTasksTarget(element, null);
        if (list == null) {
            GradleRunnerUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static boolean isCreateTaskMethod(PsiElement parent) {
        return parent instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCall)((GrMethodCallExpression)parent), (String)"createTask");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLocation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFromGroovyGradleScript";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 6: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTasksTarget";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

