/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.query.ComponentParentQuery;
import org.fest.util.Maps;
import org.fest.util.Sets;

class WindowEventQueueMapping {
    final Map<EventQueue, Map<Window, Boolean>> queueMap = Maps.newWeakHashMap();

    WindowEventQueueMapping() {
    }

    void addQueueFor(@Nonnull Toolkit toolkit) {
        WeakHashMap map = Maps.newWeakHashMap();
        this.queueMap.put(toolkit.getSystemEventQueue(), map);
    }

    void addQueueFor(@Nonnull Component component) {
        EventQueue queue = component.getToolkit().getSystemEventQueue();
        Map<Window, Boolean> windowMapping = this.queueMap.get(queue);
        if (windowMapping == null) {
            windowMapping = this.createWindowMapping(queue);
        }
        if (!(component instanceof Window) || ComponentParentQuery.parentOf(component) != null) {
            return;
        }
        windowMapping.put((Window)component, Boolean.TRUE);
    }

    @Nonnull
    private Map<Window, Boolean> createWindowMapping(EventQueue queue) {
        WeakHashMap windowMapping = Maps.newWeakHashMap();
        this.queueMap.put(queue, windowMapping);
        return windowMapping;
    }

    @RunsInCurrentThread
    void removeMappingFor(@Nonnull Component component) {
        EventQueue queue = component.getToolkit().getSystemEventQueue();
        this.removeComponent(component, queue);
        for (EventQueue q : this.queueMap.keySet()) {
            this.removeComponent(component, q);
        }
    }

    private void removeComponent(@Nonnull Component component, @Nonnull EventQueue queue) {
        Map<Window, Boolean> windowMapping = this.queueMap.get(queue);
        if (windowMapping != null) {
            windowMapping.remove(component);
        }
    }

    @Nonnull
    Collection<Window> windows() {
        HashSet rootWindows = Sets.newHashSet();
        for (EventQueue queue : this.queueMap.keySet()) {
            rootWindows.addAll(this.queueMap.get(queue).keySet());
        }
        return rootWindows;
    }

    @Nonnull
    Collection<EventQueue> eventQueues() {
        return this.queueMap.keySet();
    }
}

