/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.util.Colors;
import org.fest.util.Preconditions;

public class ColorFixture {
    private final Color target;
    private final Description description;

    public ColorFixture(@Nonnull Color target) {
        this(target, (Description)null);
    }

    public ColorFixture(@Nonnull Color target, @Nonnull String description) {
        this(target, (Description)new BasicDescription(description));
    }

    public ColorFixture(@Nonnull Color target, @Nullable Description description) {
        this.target = (Color)Preconditions.checkNotNull((Object)target);
        this.description = description;
    }

    @Nonnull
    public ColorFixture requireEqualTo(@Nonnull String hexValue) {
        return this.requireEqualTo(Colors.colorFromHexString(hexValue));
    }

    @Nonnull
    public ColorFixture requireEqualTo(@Nullable Color color) {
        ((ObjectAssert)Assertions.assertThat((Object)this.target).as(this.description)).isEqualTo((Object)color);
        return this;
    }

    @Nonnull
    public ColorFixture requireNotEqualTo(@Nonnull String hexValue) {
        return this.requireNotEqualTo(Colors.colorFromHexString(hexValue));
    }

    @Nonnull
    public ColorFixture requireNotEqualTo(@Nullable Color color) {
        ((ObjectAssert)Assertions.assertThat((Object)this.target).as(this.description)).isNotEqualTo((Object)color);
        return this;
    }

    @Nonnull
    public Color target() {
        return this.target;
    }

    @Nullable
    public final String description() {
        return this.description != null ? this.description.value() : null;
    }
}

