/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTreeLocation;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JTreeNodeTextQuery {
    @Nullable
    @RunsInEDT
    static String nodeText(final @Nonnull JTree tree, final int row, final @Nonnull JTreeLocation location, final @Nonnull JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                TreePath matchingPath = location.pathFor(tree, row);
                return pathFinder.cellReader().valueAt(tree, Preconditions.checkNotNull((Object)matchingPath.getLastPathComponent()));
            }
        });
    }

    @Nullable
    @RunsInEDT
    static String nodeText(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                TreePath matchingPath = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
                return pathFinder.cellReader().valueAt(tree, Preconditions.checkNotNull((Object)matchingPath.getLastPathComponent()));
            }
        });
    }

    private JTreeNodeTextQuery() {
    }
}

