/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTableCellPreconditions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;

final class JTableCancelCellEditingTask {
    @RunsInEDT
    static void cancelEditing(final @Nonnull JTable table, final int row, final int column) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
                JTableCellPreconditions.validateCellIsEditable(table, row, column);
                TableCellEditor cellEditor = table.getCellEditor(row, column);
                JTableCancelCellEditingTask.doCancelEditing(cellEditor);
            }
        });
    }

    @RunsInEDT
    static void cancelEditing(final @Nonnull TableCellEditor cellEditor) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCancelCellEditingTask.doCancelEditing(cellEditor);
            }
        });
    }

    private static void doCancelEditing(@Nullable TableCellEditor cellEditor) {
        if (cellEditor == null) {
            return;
        }
        cellEditor.cancelCellEditing();
    }

    private JTableCancelCellEditingTask() {
    }
}

