/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Preconditions;

public class ComponentDragAndDrop {
    private final Robot robot;
    public static final int DRAG_THRESHOLD = Platform.isWindows() || Platform.isMacintosh() ? 10 : 16;

    public ComponentDragAndDrop(@Nonnull Robot robot) {
        this.robot = robot;
    }

    @RunsInEDT
    public void drag(@Nonnull Component target, @Nonnull Point where) {
        this.robot.pressMouse(target, where, MouseButton.LEFT_BUTTON);
        int dragDelay = this.settings().dragDelay();
        if (dragDelay > this.delayBetweenEvents()) {
            Pause.pause(dragDelay);
        }
        this.mouseMove(target, where.x, where.y);
        this.robot.waitForIdle();
    }

    private void mouseMove(@Nonnull Component target, int x, int y) {
        if (Platform.isWindows() || Platform.isMacintosh()) {
            this.mouseMoveOnWindowsAndMacintosh(target, x, y);
            return;
        }
        this.mouseMove(target, ComponentDragAndDrop.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), ComponentDragAndDrop.point(x + DRAG_THRESHOLD, y + DRAG_THRESHOLD), ComponentDragAndDrop.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), ComponentDragAndDrop.point(x, y));
    }

    @RunsInEDT
    private void mouseMoveOnWindowsAndMacintosh(@Nonnull Component target, int x, int y) {
        Dimension size = target.getSize();
        int dx = ComponentDragAndDrop.distance(x, size.width);
        int dy = ComponentDragAndDrop.distance(y, size.height);
        if (dx == 0 && dy == 0) {
            dx = DRAG_THRESHOLD;
        }
        this.mouseMove(target, ComponentDragAndDrop.point(x + dx / 4, y + dy / 4), ComponentDragAndDrop.point(x + dx / 2, y + dy / 2), ComponentDragAndDrop.point(x + dx, y + dy), ComponentDragAndDrop.point(x + dx + 1, y + dy));
    }

    private static int distance(int coordinate, int dimension) {
        return coordinate + DRAG_THRESHOLD < dimension ? DRAG_THRESHOLD : 0;
    }

    @Nonnull
    private static Point point(int x, int y) {
        return new Point(x, y);
    }

    @RunsInEDT
    public void drop(@Nonnull Component target, @Nonnull Point where) {
        int delayBetweenEvents;
        this.dragOver(target, where);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.settings().eventPostingDelay() * 4);
        while (!this.robot.isDragging()) {
            if (watch.isTimeOut()) {
                throw ActionFailedException.actionFailure("There is no drag in effect");
            }
            Pause.pause();
        }
        int dropDelay = this.settings().dropDelay();
        if (dropDelay > (delayBetweenEvents = this.delayBetweenEvents())) {
            Pause.pause(dropDelay - delayBetweenEvents);
        }
        this.robot.releaseMouseButtons();
        this.robot.waitForIdle();
    }

    private int delayBetweenEvents() {
        return this.settings().delayBetweenEvents();
    }

    @Nonnull
    private Settings settings() {
        return this.robot.settings();
    }

    public void dragOver(@Nonnull Component target, @Nonnull Point where) {
        this.dragOver(target, where.x, where.y);
    }

    private void dragOver(@Nonnull Component target, int x, int y) {
        this.robot.moveMouse(target, x - 4, y);
        this.robot.moveMouse(target, x, y);
    }

    private void mouseMove(@Nonnull Component target, Point ... points) {
        ArrayList<Point> translatedPoints = new ArrayList<Point>(points.length);
        for (Point point : points) {
            Point newPoint = (Point)Preconditions.checkNotNull((Object)AWT.locationOnScreenOf(target));
            newPoint.translate(point.x, point.y);
            translatedPoints.add(newPoint);
        }
        for (Point point : translatedPoints) {
            this.robot.moveMouse(point.x, point.y);
        }
    }
}

