/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.spec;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.initialization.definition.InjectedPluginDependencies;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.definition.DefaultInjectedPluginDependencies;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.vcs.VersionControlSpec;

public abstract class AbstractVersionControlSpec
implements VersionControlSpec {
    private String rootDir = "";
    private final StartParameter rootBuildStartParameter;
    private final DefaultInjectedPluginDependencies pluginDependencies;

    protected AbstractVersionControlSpec(StartParameter rootBuildStartParameter, ClassLoaderScope classLoaderScope) {
        this.rootBuildStartParameter = rootBuildStartParameter;
        this.pluginDependencies = new DefaultInjectedPluginDependencies(classLoaderScope);
    }

    @Override
    public String getRootDir() {
        return this.rootDir;
    }

    @Override
    public void setRootDir(String rootDir) {
        Preconditions.checkNotNull((Object)rootDir, (String)"rootDir should be non-null for '%s'.", (Object[])new Object[]{this.getDisplayName()});
        this.rootDir = rootDir;
    }

    @Override
    public void plugins(Action<? super InjectedPluginDependencies> configuration) {
        configuration.execute(this.pluginDependencies);
    }

    public BuildDefinition getBuildDefinition(File buildDirectory) {
        return BuildDefinition.fromStartParameterForBuild(this.rootBuildStartParameter, buildDirectory, this.pluginDependencies.getRequests());
    }
}

