/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import org.gradle.StartParameter;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.git.internal.DefaultGitVersionControlSpec;
import org.gradle.vcs.internal.spec.DirectoryRepositorySpec;

public class VersionControlSpecFactory {
    private final Instantiator instantiator;
    private final StartParameter rootBuildStartParameter;

    public VersionControlSpecFactory(Instantiator instantiator, StartParameter rootBuildStartParameter) {
        this.instantiator = instantiator;
        this.rootBuildStartParameter = rootBuildStartParameter;
    }

    public <T extends VersionControlSpec> T create(Class<T> specType, ClassLoaderScope classLoaderScope) {
        if (GitVersionControlSpec.class.isAssignableFrom(specType)) {
            return (T)((VersionControlSpec)Cast.uncheckedCast(this.instantiator.newInstance(DefaultGitVersionControlSpec.class, this.rootBuildStartParameter, classLoaderScope)));
        }
        if (DirectoryRepositorySpec.class.isAssignableFrom(specType)) {
            return (T)((VersionControlSpec)Cast.uncheckedCast(this.instantiator.newInstance(DirectoryRepositorySpec.class, this.rootBuildStartParameter, classLoaderScope)));
        }
        throw new IllegalArgumentException(String.format("Do not know how to create an instance of %s.", specType.getName()));
    }
}

