/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.util.GFileUtils;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.DefaultVersionRef;
import org.gradle.vcs.internal.VersionControlSystem;
import org.gradle.vcs.internal.VersionRef;
import org.gradle.vcs.internal.spec.DirectoryRepositorySpec;

public class SimpleVersionControlSystem
implements VersionControlSystem {
    @Override
    public Set<VersionRef> getAvailableVersions(VersionControlSpec spec) {
        return Sets.newHashSet((Object[])new VersionRef[]{this.getDefaultBranch(spec)});
    }

    @Override
    public VersionRef getDefaultBranch(VersionControlSpec spec) {
        return new DefaultVersionRef();
    }

    @Override
    @Nullable
    public VersionRef getBranch(VersionControlSpec spec, String branch) {
        return null;
    }

    @Override
    public File populate(File versionDir, VersionRef ref, VersionControlSpec spec) {
        File sourceDir = ((DirectoryRepositorySpec)spec).getSourceDir();
        File workingDir = new File(versionDir, sourceDir.getName());
        File checkoutFlag = new File(workingDir, "checkedout");
        try {
            if (!checkoutFlag.exists()) {
                GFileUtils.copyDirectory(sourceDir, workingDir);
                checkoutFlag.createNewFile();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return workingDir;
    }
}

