/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CleanupActionFactory;
import org.gradle.cache.internal.FixedAgeOldestCacheCleanup;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.util.GFileUtils;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.internal.GitVersionControlSystem;
import org.gradle.vcs.internal.SimpleVersionControlSystem;
import org.gradle.vcs.internal.VcsWorkingDirectoryRoot;
import org.gradle.vcs.internal.VersionControlSystem;
import org.gradle.vcs.internal.VersionControlSystemFactory;
import org.gradle.vcs.internal.VersionRef;
import org.gradle.vcs.internal.spec.DirectoryRepositorySpec;

public class DefaultVersionControlSystemFactory
implements VersionControlSystemFactory,
Stoppable {
    private final PersistentCache vcsWorkingDirCache;

    DefaultVersionControlSystemFactory(VcsWorkingDirectoryRoot workingDirectoryRoot, CacheRepository cacheRepository, CleanupActionFactory cleanupActionFactory) {
        this.vcsWorkingDirCache = cacheRepository.cache(workingDirectoryRoot.getDir()).withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).withDisplayName("VCS Checkout Cache").withCleanup(cleanupActionFactory.create(new FixedAgeOldestCacheCleanup(7L))).open();
    }

    @Override
    public VersionControlSystem create(VersionControlSpec spec) {
        VersionControlSystem vcs = spec instanceof DirectoryRepositorySpec ? new SimpleVersionControlSystem() : new GitVersionControlSystem();
        return new LockingVersionControlSystem(vcs, this.vcsWorkingDirCache);
    }

    @Override
    public void stop() {
        this.vcsWorkingDirCache.close();
    }

    private static final class LockingVersionControlSystem
    implements VersionControlSystem {
        private final VersionControlSystem delegate;
        private final CacheAccess cacheAccess;

        private LockingVersionControlSystem(VersionControlSystem delegate, CacheAccess cacheAccess) {
            this.delegate = delegate;
            this.cacheAccess = cacheAccess;
        }

        @Override
        public VersionRef getDefaultBranch(VersionControlSpec spec) {
            try {
                return this.delegate.getDefaultBranch(spec);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not locate default branch for '%s'.", spec.getDisplayName()), e);
            }
        }

        @Override
        @Nullable
        public VersionRef getBranch(VersionControlSpec spec, String branch) {
            try {
                return this.delegate.getBranch(spec, branch);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not locate branch '%s' for '%s'.", branch, spec.getDisplayName()), e);
            }
        }

        @Override
        public Set<VersionRef> getAvailableVersions(VersionControlSpec spec) {
            try {
                return this.delegate.getAvailableVersions(spec);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not list available versions for '%s'.", spec.getDisplayName()), e);
            }
        }

        @Override
        public File populate(final File versionDir, final VersionRef ref, final VersionControlSpec spec) {
            return this.cacheAccess.useCache(new Factory<File>(){

                @Override
                @Nullable
                public File create() {
                    GFileUtils.mkdirs(versionDir);
                    GFileUtils.touch(versionDir);
                    try {
                        return LockingVersionControlSystem.this.delegate.populate(versionDir, ref, spec);
                    }
                    catch (Exception e) {
                        throw new GradleException(String.format("Could not populate %s from '%s'.", versionDir, spec.getDisplayName()), e);
                    }
                }
            });
        }
    }
}

