/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Actions;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.util.CollectionUtils;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.DefaultVcsMapping;
import org.gradle.vcs.internal.VcsMappingFactory;
import org.gradle.vcs.internal.VcsMappingInternal;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.gradle.vcs.internal.VcsResolver;

public class DefaultVcsMappingsStore
implements VcsMappingsStore,
VcsResolver {
    private final Set<Action<? super VcsMapping>> rootVcsMappings = Sets.newLinkedHashSet();
    private final Map<Gradle, Set<Action<? super VcsMapping>>> vcsMappings = Maps.newHashMap();
    private final VcsMappingFactory vcsMappingFactory;

    public DefaultVcsMappingsStore(VcsMappingFactory vcsMappingFactory) {
        this.vcsMappingFactory = vcsMappingFactory;
    }

    @Override
    public VcsResolver asResolver() {
        return this;
    }

    @Override
    @Nullable
    public VersionControlSpec locateVcsFor(ModuleComponentSelector selector) {
        if (!this.hasRules()) {
            return null;
        }
        VcsMappingInternal mapping = this.vcsMappingFactory.create(selector);
        this.applyTo(mapping);
        if (mapping.hasRepository()) {
            return mapping.getRepository();
        }
        return null;
    }

    private void applyTo(VcsMappingInternal mapping) {
        Actions.composite(this.rootVcsMappings).execute(mapping);
        if (!mapping.hasRepository()) {
            HashSet resolutions = Sets.newHashSet();
            for (Gradle gradle : this.vcsMappings.keySet()) {
                Actions.composite((Iterable)this.vcsMappings.get(gradle)).execute(mapping);
                if (!mapping.hasRepository()) continue;
                resolutions.add(mapping.getRepository());
            }
            if (resolutions.size() > 1) {
                Set<String> resolutionDisplayNames = CollectionUtils.collect(resolutions, new Transformer<String, VersionControlSpec>(){

                    @Override
                    public String transform(VersionControlSpec versionControlSpec) {
                        return versionControlSpec.getDisplayName();
                    }
                });
                throw new GradleException("Conflicting external source dependency rules were found in nested builds for " + mapping.getRequested().getDisplayName() + ":\n  " + CollectionUtils.join("\n  ", resolutionDisplayNames));
            }
        }
    }

    @Override
    public boolean hasRules() {
        return !this.vcsMappings.isEmpty() || !this.rootVcsMappings.isEmpty();
    }

    @Override
    public void addRule(final Action<? super VcsMapping> rule, final Gradle gradle) {
        Action<VcsMapping> classloaderWrapping = new Action<VcsMapping>(){

            @Override
            public void execute(VcsMapping vcsMapping) {
                ((DefaultVcsMapping)vcsMapping).setClassLoaderScope(((GradleInternal)gradle).getSettings().getClassLoaderScope());
                rule.execute(vcsMapping);
            }
        };
        if (gradle.getParent() == null) {
            this.rootVcsMappings.add((Action<? super VcsMapping>)classloaderWrapping);
        } else {
            if (!this.vcsMappings.containsKey(gradle)) {
                this.vcsMappings.put(gradle, Sets.newLinkedHashSet());
            }
            this.vcsMappings.get(gradle).add((Action<? super VcsMapping>)classloaderWrapping);
        }
    }
}

