/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.git.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.eclipse.jgit.api.CloneCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.Git;
import org.gradle.internal.impldep.org.eclipse.jgit.api.ResetCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.StoredConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.URIish;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.git.internal.GitVersionRef;
import org.gradle.vcs.internal.VersionControlSystem;
import org.gradle.vcs.internal.VersionRef;

public class GitVersionControlSystem
implements VersionControlSystem {
    private static final Logger LOGGER = Logging.getLogger(GitVersionControlSystem.class);

    @Override
    public File populate(File versionDir, VersionRef ref, VersionControlSpec spec) {
        GitVersionControlSpec gitSpec = GitVersionControlSystem.cast(spec);
        File workingDir = new File(versionDir, gitSpec.getRepoName());
        File dbDir = new File(workingDir, ".git");
        LOGGER.info("Populating VCS workingDir {}/{} with ref {}", versionDir.getName(), workingDir.getName(), ref);
        if (dbDir.exists() && dbDir.isDirectory()) {
            GitVersionControlSystem.updateRepo(workingDir, gitSpec, ref);
        } else {
            GitVersionControlSystem.cloneRepo(workingDir, gitSpec, ref);
        }
        return workingDir;
    }

    @Override
    public Set<VersionRef> getAvailableVersions(VersionControlSpec spec) {
        Collection refs;
        GitVersionControlSpec gitSpec = GitVersionControlSystem.cast(spec);
        try {
            refs = Git.lsRemoteRepository().setRemote(GitVersionControlSystem.normalizeUri(gitSpec.getUrl())).setTags(true).setHeads(false).call();
        }
        catch (URISyntaxException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, e);
        }
        catch (GitAPIException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, (Exception)((Object)e));
        }
        HashSet versions = Sets.newHashSet();
        for (Ref ref : refs) {
            GitVersionRef gitRef = GitVersionRef.from(ref);
            versions.add(gitRef);
        }
        return versions;
    }

    @Override
    public VersionRef getDefaultBranch(VersionControlSpec spec) {
        Collection refs;
        GitVersionControlSpec gitSpec = GitVersionControlSystem.cast(spec);
        try {
            refs = Git.lsRemoteRepository().setRemote(GitVersionControlSystem.normalizeUri(gitSpec.getUrl())).setTags(false).call();
        }
        catch (URISyntaxException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, e);
        }
        catch (GitAPIException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, (Exception)((Object)e));
        }
        for (Ref ref : refs) {
            if (!ref.getName().equals("refs/heads/master")) continue;
            return GitVersionRef.from(ref);
        }
        throw new UnsupportedOperationException("Git repository has no master branch");
    }

    @Override
    @Nullable
    public VersionRef getBranch(VersionControlSpec spec, String branch) {
        Collection refs;
        GitVersionControlSpec gitSpec = GitVersionControlSystem.cast(spec);
        try {
            refs = Git.lsRemoteRepository().setRemote(GitVersionControlSystem.normalizeUri(gitSpec.getUrl())).setHeads(true).setTags(false).call();
        }
        catch (URISyntaxException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, e);
        }
        catch (GitAPIException e) {
            throw GitVersionControlSystem.wrapGitCommandException("ls-remote", gitSpec.getUrl(), null, (Exception)((Object)e));
        }
        String refName = "refs/heads/" + branch;
        for (Ref ref : refs) {
            if (!ref.getName().equals(refName)) continue;
            return GitVersionRef.from(ref);
        }
        return null;
    }

    private static void cloneRepo(File workingDir, GitVersionControlSpec gitSpec, VersionRef ref) {
        CloneCommand clone = Git.cloneRepository().setURI(gitSpec.getUrl().toString()).setDirectory(workingDir).setCloneSubmodules(true);
        try (Git git = null;){
            git = clone.call();
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef(ref.getCanonicalId()).call();
        }
    }

    private static void updateRepo(File workingDir, GitVersionControlSpec gitSpec, VersionRef ref) {
        try (Git git = null;){
            git = Git.open((File)workingDir);
            git.fetch().setRemote(GitVersionControlSystem.getRemoteForUrl(git.getRepository(), gitSpec.getUrl())).call();
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef(ref.getCanonicalId()).call();
            GitVersionControlSystem.updateSubModules(git);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSubModules(Git git) throws IOException, GitAPIException {
        try (SubmoduleWalk walker = SubmoduleWalk.forIndex((Repository)git.getRepository());){
            while (walker.next()) {
                try (Repository submodule = walker.getRepository();){
                    Git submoduleGit = Git.wrap((Repository)submodule);
                    submoduleGit.fetch().call();
                    git.submoduleUpdate().addPath(walker.getPath()).call();
                    submoduleGit.reset().setMode(ResetCommand.ResetType.HARD).call();
                    GitVersionControlSystem.updateSubModules(submoduleGit);
                }
            }
        }
    }

    private static String getRemoteForUrl(Repository repository, URI url) throws URISyntaxException {
        StoredConfig config = repository.getConfig();
        Set remotes = config.getSubsections("remote");
        HashSet<String> foundUrls = new HashSet<String>();
        String normalizedUrl = GitVersionControlSystem.normalizeUri(url);
        for (String remote : remotes) {
            String remoteUrl = config.getString("remote", remote, "url");
            if (remoteUrl.equals(normalizedUrl)) {
                return remote;
            }
            foundUrls.add(remoteUrl);
        }
        throw new GradleException(String.format("Could not find remote with url: %s. Found: %s", url, foundUrls));
    }

    private static String normalizeUri(URI uri) throws URISyntaxException {
        return new URIish(uri.toString()).toString();
    }

    private static GitVersionControlSpec cast(VersionControlSpec spec) {
        if (!(spec instanceof GitVersionControlSpec)) {
            throw new IllegalArgumentException("The GitVersionControlSystem can only handle GitVersionControlSpec instances.");
        }
        return (GitVersionControlSpec)spec;
    }

    private static GradleException wrapGitCommandException(String commandName, URI repoUrl, File workingDir, Exception e) {
        if (workingDir == null) {
            return new GradleException(String.format("Could not run %s for %s", commandName, repoUrl), e);
        }
        return new GradleException(String.format("Could not %s from %s in %s", commandName, repoUrl, workingDir), e);
    }
}

