/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMapInterner
implements Interner<String> {
    private final Map<String, String> internedStrings;

    private SimpleMapInterner(Map<String, String> interned) {
        this.internedStrings = interned;
    }

    public static SimpleMapInterner notThreadSafe() {
        return new SimpleMapInterner(Maps.newHashMap());
    }

    public static SimpleMapInterner threadSafe() {
        return new SimpleMapInterner(Maps.newConcurrentMap());
    }

    public String intern(String sample) {
        if (sample == null) {
            return null;
        }
        String interned = this.internedStrings.get(sample);
        if (interned != null) {
            return interned;
        }
        this.internedStrings.put(sample, sample);
        return sample;
    }
}

