/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectOutputStream;
import org.gradle.internal.serialize.TopLevelExceptionPlaceholder;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PayloadSerializerObjectOutputStream
extends ExceptionReplacingObjectOutputStream {
    static final int SAME_CLASSLOADER_TOKEN = 0;
    private final SerializeMap map;

    public PayloadSerializerObjectOutputStream(OutputStream outputStream, SerializeMap map) throws IOException {
        super(outputStream);
        this.map = map;
    }

    @Override
    protected ExceptionReplacingObjectOutputStream createNewInstance(OutputStream outputStream) throws IOException {
        return new PayloadSerializerObjectOutputStream(outputStream, this.map);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        Class<?> targetClass = desc.forClass();
        this.writeClass(targetClass);
    }

    @Override
    protected void annotateProxyClass(Class<?> cl) throws IOException {
        this.writeInt(cl.getInterfaces().length);
        for (Class<?> type : cl.getInterfaces()) {
            this.writeClass(type);
        }
    }

    private void writeClass(Class<?> targetClass) throws IOException {
        this.writeClassLoader(targetClass);
        this.writeUTF(targetClass.getName());
    }

    private void writeClassLoader(Class<?> targetClass) throws IOException {
        if (TopLevelExceptionPlaceholder.class.getPackage().equals(targetClass.getPackage())) {
            this.writeShort(0);
        } else {
            this.writeShort(this.map.visitClass(targetClass));
        }
    }
}

