/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.SubscribableBuildAction;
import org.gradle.tooling.internal.provider.SubscribableBuildActionRunnerRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribableBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final List<BuildOperationListener> listeners = new ArrayList<BuildOperationListener>();
    private final List<? extends SubscribableBuildActionRunnerRegistration> registrations;

    public SubscribableBuildActionRunner(BuildActionRunner delegate, BuildOperationListenerManager buildOperationListenerManager, List<? extends SubscribableBuildActionRunnerRegistration> registrations) {
        this.delegate = delegate;
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.registrations = registrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(BuildAction action, BuildController buildController) {
        boolean subscribable = action instanceof SubscribableBuildAction;
        if (subscribable) {
            GradleInternal gradle = buildController.getGradle();
            SubscribableBuildAction subscribableBuildAction = (SubscribableBuildAction)action;
            this.registerListenersForClientSubscriptions(subscribableBuildAction.getClientSubscriptions(), gradle);
        }
        try {
            this.delegate.run(action, buildController);
        }
        finally {
            for (BuildOperationListener listener : this.listeners) {
                this.buildOperationListenerManager.removeListener(listener);
            }
            this.listeners.clear();
        }
    }

    private void registerListenersForClientSubscriptions(BuildClientSubscriptions clientSubscriptions, GradleInternal gradle) {
        BuildEventConsumer eventConsumer = gradle.getServices().get(BuildEventConsumer.class);
        for (SubscribableBuildActionRunnerRegistration subscribableBuildActionRunnerRegistration : this.registrations) {
            for (BuildOperationListener listener : subscribableBuildActionRunnerRegistration.createListeners(clientSubscriptions, eventConsumer)) {
                this.registerListener(listener);
            }
        }
    }

    private void registerListener(BuildOperationListener listener) {
        this.listeners.add(listener);
        this.buildOperationListenerManager.addListener(listener);
    }
}

