/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.initialization.BuildEventConsumer;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.protocol.PhasedActionResultListener;
import org.gradle.tooling.internal.provider.PhasedBuildActionResult;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class PhasedActionEventConsumer
implements BuildEventConsumer {
    private final PhasedActionResultListener phasedActionResultListener;
    private final PayloadSerializer payloadSerializer;
    private final BuildEventConsumer delegate;

    PhasedActionEventConsumer(PhasedActionResultListener phasedActionResultListener, PayloadSerializer payloadSerializer, BuildEventConsumer delegate) {
        this.phasedActionResultListener = phasedActionResultListener;
        this.payloadSerializer = payloadSerializer;
        this.delegate = delegate;
    }

    public void dispatch(Object event) {
        if (event instanceof PhasedBuildActionResult) {
            final PhasedBuildActionResult resultEvent = (PhasedBuildActionResult)event;
            final Object deserializedResult = this.payloadSerializer.deserialize(resultEvent.result);
            this.phasedActionResultListener.onResult(new PhasedActionResult<Object>(){

                @Override
                public Object getResult() {
                    return deserializedResult;
                }

                @Override
                public PhasedActionResult.Phase getPhase() {
                    return resultEvent.phase;
                }
            });
        } else {
            this.delegate.dispatch(event);
        }
    }
}

