/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.OutputStream;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.io.NullOutputStream;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingBridgingBuildActionExecuter
implements BuildActionExecuter<ProviderOperationParameters> {
    private final LoggingManagerInternal loggingManager;
    private final BuildActionExecuter<ProviderOperationParameters> executer;

    public LoggingBridgingBuildActionExecuter(BuildActionExecuter<ProviderOperationParameters> executer, LoggingManagerInternal loggingManager) {
        this.executer = executer;
        this.loggingManager = loggingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(BuildAction action, BuildRequestContext buildRequestContext, ProviderOperationParameters actionParameters, ServiceRegistry contextServices) {
        if (Boolean.TRUE.equals(actionParameters.isColorOutput(null)) && actionParameters.getStandardOutput() != null) {
            this.loggingManager.attachConsole(actionParameters.getStandardOutput(), this.notNull(actionParameters.getStandardError()), ConsoleOutput.Rich);
        } else if (actionParameters.getStandardOutput() != null || actionParameters.getStandardError() != null) {
            this.loggingManager.attachConsole(this.notNull(actionParameters.getStandardOutput()), this.notNull(actionParameters.getStandardError()), ConsoleOutput.Plain);
        }
        ProgressListenerVersion1 progressListener = actionParameters.getProgressListener();
        OutputEventListenerAdapter listener = new OutputEventListenerAdapter(progressListener);
        this.loggingManager.addOutputEventListener(listener);
        this.loggingManager.setLevelInternal(actionParameters.getBuildLogLevel());
        this.loggingManager.start();
        try {
            Object object = this.executer.execute(action, buildRequestContext, actionParameters, contextServices);
            return object;
        }
        finally {
            this.loggingManager.stop();
        }
    }

    private OutputStream notNull(OutputStream outputStream) {
        if (outputStream == null) {
            return NullOutputStream.INSTANCE;
        }
        return outputStream;
    }

    private static class OutputEventListenerAdapter
    implements OutputEventListener {
        private final ProgressListenerVersion1 progressListener;

        public OutputEventListenerAdapter(ProgressListenerVersion1 progressListener) {
            this.progressListener = progressListener;
        }

        public void onOutput(OutputEvent event) {
            if (event instanceof ProgressStartEvent) {
                ProgressStartEvent startEvent = (ProgressStartEvent)event;
                this.progressListener.onOperationStart(startEvent.getDescription());
            } else if (event instanceof ProgressCompleteEvent) {
                this.progressListener.onOperationEnd();
            }
        }
    }
}

