/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.internal.classpath.Module;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.time.Clock;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionInstaller;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;

public class DistributionFactory {
    private final Clock clock;
    private File distributionBaseDir;

    public DistributionFactory(Clock clock) {
        this.clock = clock;
    }

    public void setDistributionBaseDir(File distributionBaseDir) {
        this.distributionBaseDir = distributionBaseDir;
    }

    public Distribution getDefaultDistribution(File projectDir, boolean searchUpwards) {
        BuildLayout layout = new BuildLayoutFactory().getLayoutFor(projectDir, searchUpwards);
        WrapperExecutor wrapper = WrapperExecutor.forProjectDirectory((File)layout.getRootDirectory());
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration(), this.distributionBaseDir, this.clock);
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    public Distribution getDistribution(File gradleHomeDir) {
        return new InstalledDistribution(gradleHomeDir, "Gradle installation '" + gradleHomeDir + "'", "Gradle installation directory '" + gradleHomeDir + "'");
    }

    public Distribution getDistribution(String gradleVersion) {
        return this.getDownloadedDistribution(gradleVersion);
    }

    public Distribution getDistribution(URI gradleDistribution) {
        WrapperConfiguration configuration = new WrapperConfiguration();
        configuration.setDistribution(gradleDistribution);
        return new ZippedDistribution(configuration, this.distributionBaseDir, this.clock);
    }

    public Distribution getClasspathDistribution() {
        return new ClasspathDistribution();
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version(gradleVersion));
        return this.getDistribution(distUri);
    }

    private static class ClasspathDistribution
    implements Distribution {
        private ClasspathDistribution() {
        }

        public String getDisplayName() {
            return "Gradle classpath distribution";
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, File userHomeDir, BuildCancellationToken cancellationToken) {
            DefaultModuleRegistry registry = new DefaultModuleRegistry(null);
            ClassPath classpath = ClassPath.EMPTY;
            for (Module module : registry.getModule("gradle-launcher").getAllRequiredModules()) {
                classpath = classpath.plus(module.getClasspath());
            }
            return classpath;
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, File userHomeDir, BuildCancellationToken cancellationToken) {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            Object[] files = libDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return FileUtils.hasExtension(file, ".jar");
                }
            });
            Arrays.sort(files);
            return DefaultClassPath.of((File[])files);
        }
    }

    private static class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;
        private final File distributionBaseDir;
        private final Clock clock;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration, File distributionBaseDir, Clock clock) {
            this.wrapperConfiguration = wrapperConfiguration;
            this.distributionBaseDir = distributionBaseDir;
            this.clock = clock;
        }

        public String getDisplayName() {
            return "Gradle distribution '" + this.wrapperConfiguration.getDistribution() + "'";
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, File userHomeDir, BuildCancellationToken cancellationToken) {
            if (this.installedDistribution == null) {
                File installDir;
                final DistributionInstaller installer = new DistributionInstaller(progressLoggerFactory, progressListener, this.clock);
                try {
                    cancellationToken.addCallback(new Runnable(){

                        public void run() {
                            installer.cancel();
                        }
                    });
                    installDir = installer.install(this.determineRealUserHomeDir(userHomeDir), this.wrapperConfiguration);
                }
                catch (CancellationException e) {
                    throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", this.wrapperConfiguration.getDistribution()), e);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.getDisplayName()), e);
                }
                catch (Exception e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), e);
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, progressListener, userHomeDir, cancellationToken);
        }

        private File determineRealUserHomeDir(File userHomeDir) {
            if (this.distributionBaseDir != null) {
                return this.distributionBaseDir;
            }
            return userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
        }
    }
}

