/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.child.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionExecutionWorker
implements Action<WorkerContext>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionExecutionWorker.class);
    private final Action<? super WorkerProcessContext> action;
    private final Object workerId;
    private final String displayName;
    private final File gradleUserHomeDir;

    public ActionExecutionWorker(Action<? super WorkerProcessContext> action, Object workerId, String displayName, File gradleUserHomeDir) {
        this.action = action;
        this.workerId = workerId;
        this.displayName = displayName;
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final WorkerContext workerContext) {
        final ObjectConnection clientConnection = workerContext.getServerConnection();
        final ServiceRegistry serviceRegistry = workerContext.getServiceRegistry();
        LOGGER.debug("Starting {}.", (Object)this.displayName);
        WorkerProcessContext context = new WorkerProcessContext(){

            public ObjectConnection getServerConnection() {
                return clientConnection;
            }

            public ClassLoader getApplicationClassLoader() {
                return workerContext.getApplicationClassLoader();
            }

            public Object getWorkerId() {
                return ActionExecutionWorker.this.workerId;
            }

            public String getDisplayName() {
                return ActionExecutionWorker.this.displayName;
            }

            public ServiceRegistry getServiceRegistry() {
                return serviceRegistry;
            }
        };
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
        NativeServices.initialize(this.gradleUserHomeDir, false);
        try {
            this.action.execute(context);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        LOGGER.debug("Completed {}.", (Object)this.displayName);
    }
}

