/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerControl;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessException;
import org.gradle.process.internal.worker.WorkerProcessSettings;
import org.gradle.process.internal.worker.request.Receiver;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.ResponseProtocol;
import org.gradle.process.internal.worker.request.WorkerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMultiRequestWorkerProcessBuilder<WORKER>
implements MultiRequestWorkerProcessBuilder<WORKER> {
    private static final Method START_METHOD;
    private static final Method STOP_METHOD;
    private final Class<WORKER> workerType;
    private final Class<?> workerImplementation;
    private final DefaultWorkerProcessBuilder workerProcessBuilder;

    public DefaultMultiRequestWorkerProcessBuilder(Class<WORKER> workerType, Class<?> workerImplementation, DefaultWorkerProcessBuilder workerProcessBuilder) {
        this.workerType = workerType;
        this.workerImplementation = workerImplementation;
        this.workerProcessBuilder = workerProcessBuilder;
        workerProcessBuilder.worker(new WorkerAction(workerImplementation));
        workerProcessBuilder.setImplementationClasspath(ClasspathUtil.getClasspath(workerImplementation.getClassLoader()).getAsURLs());
    }

    @Override
    public WorkerProcessSettings applicationClasspath(Iterable<File> files) {
        this.workerProcessBuilder.applicationClasspath((Iterable)files);
        return this;
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.workerProcessBuilder.getApplicationClasspath();
    }

    @Override
    public String getBaseName() {
        return this.workerProcessBuilder.getBaseName();
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.workerProcessBuilder.getJavaCommand();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.workerProcessBuilder.getLogLevel();
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.workerProcessBuilder.getSharedPackages();
    }

    @Override
    public WorkerProcessSettings setBaseName(String baseName) {
        this.workerProcessBuilder.setBaseName(baseName);
        return this;
    }

    @Override
    public WorkerProcessSettings setLogLevel(LogLevel logLevel) {
        this.workerProcessBuilder.setLogLevel(logLevel);
        return this;
    }

    @Override
    public WorkerProcessSettings sharedPackages(Iterable<String> packages) {
        this.workerProcessBuilder.sharedPackages((Iterable)packages);
        return this;
    }

    @Override
    public WorkerProcessSettings sharedPackages(String ... packages) {
        this.workerProcessBuilder.sharedPackages(packages);
        return this;
    }

    @Override
    public WORKER build() {
        this.workerProcessBuilder.enableJvmMemoryInfoPublishing(true);
        final WorkerProcess workerProcess = this.workerProcessBuilder.build();
        return this.workerType.cast(Proxy.newProxyInstance(this.workerType.getClassLoader(), new Class[]{this.workerType}, new InvocationHandler(){
            private Receiver receiver;
            private RequestProtocol requestProtocol;
            {
                this.receiver = new Receiver(DefaultMultiRequestWorkerProcessBuilder.this.getBaseName());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(START_METHOD)) {
                    try {
                        workerProcess.start();
                    }
                    catch (Exception e) {
                        throw WorkerProcessException.runFailed(DefaultMultiRequestWorkerProcessBuilder.this.getBaseName(), e);
                    }
                    workerProcess.getConnection().addIncoming(ResponseProtocol.class, this.receiver);
                    workerProcess.getConnection().useJavaSerializationForParameters(DefaultMultiRequestWorkerProcessBuilder.this.workerImplementation.getClassLoader());
                    this.requestProtocol = workerProcess.getConnection().addOutgoing(RequestProtocol.class);
                    workerProcess.getConnection().connect();
                    return workerProcess;
                }
                if (method.equals(STOP_METHOD)) {
                    if (this.requestProtocol != null) {
                        this.requestProtocol.stop();
                    }
                    try {
                        ExecResult e = workerProcess.waitForStop();
                        return e;
                    }
                    finally {
                        this.requestProtocol = null;
                    }
                }
                this.requestProtocol.run(method.getName(), method.getParameterTypes(), args, CurrentBuildOperationRef.instance().get());
                boolean hasResult = this.receiver.awaitNextResult();
                if (!hasResult) {
                    try {
                        this.requestProtocol = null;
                        workerProcess.waitForStop();
                        throw new IllegalStateException(String.format("No response was received from %s but the worker process has finished.", DefaultMultiRequestWorkerProcessBuilder.this.getBaseName()));
                    }
                    catch (Exception e) {
                        throw WorkerProcessException.runFailed(DefaultMultiRequestWorkerProcessBuilder.this.getBaseName(), e);
                    }
                }
                return this.receiver.getNextResult();
            }
        }));
    }

    static {
        try {
            START_METHOD = WorkerControl.class.getMethod("start", new Class[0]);
            STOP_METHOD = WorkerControl.class.getMethod("stop", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

