/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.StreamsHandler;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecHandleBuilder
extends AbstractExecHandleBuilder
implements ExecHandleBuilder {
    private final List<Object> arguments = new ArrayList<Object>();
    private final List<CommandLineArgumentProvider> argumentProviders = new ArrayList<CommandLineArgumentProvider>();

    public DefaultExecHandleBuilder(PathToFileResolver fileResolver, Executor executor) {
        this(fileResolver, executor, new DefaultBuildCancellationToken());
    }

    public DefaultExecHandleBuilder(PathToFileResolver fileResolver, Executor executor, BuildCancellationToken buildCancellationToken) {
        super(fileResolver, executor, buildCancellationToken);
    }

    @Override
    public DefaultExecHandleBuilder executable(Object executable) {
        super.executable(executable);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder commandLine(Object ... arguments) {
        this.commandLine(Arrays.asList(arguments));
        return this;
    }

    @Override
    public DefaultExecHandleBuilder commandLine(Iterable<?> args) {
        ArrayList argsList = Lists.newArrayList(args);
        this.executable(argsList.get(0));
        this.setArgs((Iterable)argsList.subList(1, argsList.size()));
        return this;
    }

    @Override
    public void setCommandLine(List<String> args) {
        this.commandLine(args);
    }

    @Override
    public void setCommandLine(Object ... args) {
        this.commandLine(args);
    }

    @Override
    public void setCommandLine(Iterable<?> args) {
        this.commandLine((Iterable)args);
    }

    @Override
    public DefaultExecHandleBuilder args(Object ... args) {
        if (args == null) {
            throw new IllegalArgumentException("args == null!");
        }
        this.arguments.addAll(Arrays.asList(args));
        return this;
    }

    @Override
    public DefaultExecHandleBuilder args(Iterable<?> args) {
        GUtil.addToCollection(this.arguments, args);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setArgs(List<String> arguments) {
        this.arguments.clear();
        this.arguments.addAll(arguments);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setArgs(Iterable<?> arguments) {
        this.arguments.clear();
        GUtil.addToCollection(this.arguments, arguments);
        return this;
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object argument : this.arguments) {
            args.add(argument.toString());
        }
        return args;
    }

    @Override
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentProviders;
    }

    @Override
    public List<String> getAllArguments() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        for (CommandLineArgumentProvider argumentProvider : this.argumentProviders) {
            Iterables.addAll(args, argumentProvider.asArguments());
        }
        return args;
    }

    @Override
    public DefaultExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        super.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder workingDir(Object dir) {
        super.workingDir(dir);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder redirectErrorStream() {
        super.redirectErrorStream();
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setStandardOutput(OutputStream outputStream) {
        super.setStandardOutput(outputStream);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setStandardInput(InputStream inputStream) {
        super.setStandardInput(inputStream);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder streamsHandler(StreamsHandler streamsHandler) {
        super.streamsHandler(streamsHandler);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder listener(ExecHandleListener listener) {
        super.listener(listener);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setTimeout(int timeoutMillis) {
        super.setTimeout(timeoutMillis);
        return this;
    }

    @Override
    public ExecHandleBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }
}

