/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.concurrent.Executor;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.DefaultExecHandleBuilder;
import org.gradle.process.internal.DefaultJavaExecAction;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecFactory;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.process.internal.JavaExecHandleBuilder;

public class DefaultExecActionFactory
implements ExecFactory,
Stoppable {
    private final FileResolver fileResolver;
    private final DefaultExecutorFactory executorFactory = new DefaultExecutorFactory();
    private final Executor executor;
    private final BuildCancellationToken buildCancellationToken;

    public DefaultExecActionFactory(FileResolver fileResolver) {
        this(fileResolver, new DefaultBuildCancellationToken());
    }

    public DefaultExecActionFactory(FileResolver fileResolver, BuildCancellationToken buildCancellationToken) {
        this.fileResolver = fileResolver;
        this.buildCancellationToken = buildCancellationToken;
        this.executor = this.executorFactory.create("Exec process");
    }

    public void stop() {
        this.executorFactory.stop();
    }

    public ExecFactory forContext(FileResolver fileResolver, Instantiator instantiator) {
        return new DecoratingExecActionFactory(fileResolver, instantiator, this.executor, this.buildCancellationToken);
    }

    public ExecAction newDecoratedExecAction() {
        throw new UnsupportedOperationException();
    }

    public ExecAction newExecAction() {
        return new DefaultExecAction(this.fileResolver, this.executor, this.buildCancellationToken);
    }

    public JavaExecAction newDecoratedJavaExecAction() {
        throw new UnsupportedOperationException();
    }

    public JavaExecAction newJavaExecAction() {
        return new DefaultJavaExecAction(this.fileResolver, this.executor, this.buildCancellationToken);
    }

    public ExecHandleBuilder newExec() {
        return new DefaultExecHandleBuilder(this.fileResolver, this.executor, this.buildCancellationToken);
    }

    public JavaExecHandleBuilder newJavaExec() {
        return new JavaExecHandleBuilder(this.fileResolver, this.executor, this.buildCancellationToken);
    }

    private static class DecoratingExecActionFactory
    implements ExecFactory {
        private final FileResolver fileResolver;
        private final Instantiator instantiator;
        private final Executor executor;
        private final BuildCancellationToken buildCancellationToken;

        DecoratingExecActionFactory(FileResolver fileResolver, Instantiator instantiator, Executor executor, BuildCancellationToken buildCancellationToken) {
            this.fileResolver = fileResolver;
            this.instantiator = instantiator;
            this.executor = executor;
            this.buildCancellationToken = buildCancellationToken;
        }

        public ExecFactory forContext(FileResolver fileResolver, Instantiator instantiator) {
            return new DecoratingExecActionFactory(fileResolver, instantiator, this.executor, this.buildCancellationToken);
        }

        public ExecAction newExecAction() {
            return new DefaultExecAction(this.fileResolver, this.executor, this.buildCancellationToken);
        }

        public JavaExecAction newJavaExecAction() {
            return new DefaultJavaExecAction(this.fileResolver, this.executor, this.buildCancellationToken);
        }

        public ExecHandleBuilder newExec() {
            return new DefaultExecHandleBuilder(this.fileResolver, this.executor, this.buildCancellationToken);
        }

        public JavaExecHandleBuilder newJavaExec() {
            return new JavaExecHandleBuilder(this.fileResolver, this.executor, this.buildCancellationToken);
        }

        public ExecAction newDecoratedExecAction() {
            return this.instantiator.newInstance(DefaultExecAction.class, this.fileResolver, this.executor, this.buildCancellationToken);
        }

        public JavaExecAction newDecoratedJavaExecAction() {
            return this.instantiator.newInstance(DefaultJavaExecAction.class, this.fileResolver, this.executor, this.buildCancellationToken);
        }
    }
}

