/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.StreamsHandler;
import org.gradle.process.internal.streams.EmptyStdInStreamsHandler;
import org.gradle.process.internal.streams.ForwardStdinStreamsHandler;
import org.gradle.process.internal.streams.OutputStreamsForwarder;
import org.gradle.process.internal.streams.SafeStreams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecHandleBuilder
extends DefaultProcessForkOptions
implements BaseExecSpec {
    private static final EmptyStdInStreamsHandler DEFAULT_STDIN = new EmptyStdInStreamsHandler();
    private final BuildCancellationToken buildCancellationToken;
    private final List<ExecHandleListener> listeners = new ArrayList<ExecHandleListener>();
    private OutputStream standardOutput;
    private OutputStream errorOutput;
    private InputStream input;
    private StreamsHandler inputHandler = DEFAULT_STDIN;
    private String displayName;
    private boolean ignoreExitValue;
    private boolean redirectErrorStream;
    private StreamsHandler streamsHandler;
    private int timeoutMillis = Integer.MAX_VALUE;
    protected boolean daemon;
    private Executor executor;

    AbstractExecHandleBuilder(PathToFileResolver fileResolver, Executor executor, BuildCancellationToken buildCancellationToken) {
        super(fileResolver);
        this.buildCancellationToken = buildCancellationToken;
        this.executor = executor;
        this.standardOutput = SafeStreams.systemOut();
        this.errorOutput = SafeStreams.systemErr();
        this.input = SafeStreams.emptyInput();
    }

    public abstract List<String> getAllArguments();

    @Override
    public List<String> getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getExecutable());
        commandLine.addAll(this.getAllArguments());
        return commandLine;
    }

    @Override
    public AbstractExecHandleBuilder setStandardInput(InputStream inputStream) {
        this.input = inputStream;
        this.inputHandler = new ForwardStdinStreamsHandler(inputStream);
        return this;
    }

    public StreamsHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public InputStream getStandardInput() {
        return this.input;
    }

    @Override
    public AbstractExecHandleBuilder setStandardOutput(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream == null!");
        }
        this.standardOutput = outputStream;
        return this;
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    @Override
    public AbstractExecHandleBuilder setErrorOutput(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream == null!");
        }
        this.errorOutput = outputStream;
        return this;
    }

    @Override
    public OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    @Override
    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    @Override
    public AbstractExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    public String getDisplayName() {
        return this.displayName == null ? String.format("command '%s'", this.getExecutable()) : this.displayName;
    }

    public AbstractExecHandleBuilder setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public AbstractExecHandleBuilder listener(ExecHandleListener listener) {
        if (this.listeners == null) {
            throw new IllegalArgumentException("listeners == null!");
        }
        this.listeners.add(listener);
        return this;
    }

    public ExecHandle build() {
        String executable = this.getExecutable();
        if (StringUtils.isEmpty((String)executable)) {
            throw new IllegalStateException("execCommand == null!");
        }
        StreamsHandler effectiveOutputHandler = this.getEffectiveStreamsHandler();
        return new DefaultExecHandle(this.getDisplayName(), this.getWorkingDir(), executable, this.getAllArguments(), this.getActualEnvironment(), effectiveOutputHandler, this.inputHandler, this.listeners, this.redirectErrorStream, this.timeoutMillis, this.daemon, this.executor, this.buildCancellationToken);
    }

    private StreamsHandler getEffectiveStreamsHandler() {
        StreamsHandler effectiveHandler;
        if (this.streamsHandler != null) {
            effectiveHandler = this.streamsHandler;
        } else {
            boolean shouldReadErrorStream = !this.redirectErrorStream;
            effectiveHandler = new OutputStreamsForwarder(this.standardOutput, this.errorOutput, shouldReadErrorStream);
        }
        return effectiveHandler;
    }

    public AbstractExecHandleBuilder streamsHandler(StreamsHandler streamsHandler) {
        this.streamsHandler = streamsHandler;
        return this;
    }

    public AbstractExecHandleBuilder redirectErrorStream() {
        this.redirectErrorStream = true;
        return this;
    }

    public AbstractExecHandleBuilder setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }
}

