/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.envjs.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.plugins.javascript.envjs.browser.BrowserEvaluator;
import org.gradle.plugins.javascript.envjs.internal.EnvJsEvaluateSpec;
import org.gradle.plugins.javascript.envjs.internal.EnvJsEvaluateWorker;
import org.gradle.plugins.javascript.envjs.internal.EnvJvEvaluateProtocol;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoWorkerHandleFactory;

public class EnvJsBrowserEvaluator
implements BrowserEvaluator {
    private final RhinoWorkerHandleFactory rhinoWorkerHandleFactory;
    private final Iterable<File> rhinoClasspath;
    private final LogLevel logLevel;
    private final File workingDir;
    private final Factory<File> envJsFactory;

    public EnvJsBrowserEvaluator(RhinoWorkerHandleFactory rhinoWorkerHandleFactory, Iterable<File> rhinoClasspath, Factory<File> envJsFactory, LogLevel logLevel, File workingDir) {
        this.rhinoWorkerHandleFactory = rhinoWorkerHandleFactory;
        this.rhinoClasspath = rhinoClasspath;
        this.envJsFactory = envJsFactory;
        this.logLevel = logLevel;
        this.workingDir = workingDir;
    }

    @Override
    public void evaluate(String url, Writer writer) {
        EnvJvEvaluateProtocol evaluator = this.rhinoWorkerHandleFactory.create(this.rhinoClasspath, EnvJvEvaluateProtocol.class, EnvJsEvaluateWorker.class, this.logLevel, this.workingDir);
        String result = evaluator.process(new EnvJsEvaluateSpec(this.envJsFactory.create(), url));
        try {
            IOUtils.copy((Reader)new StringReader(result), (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

