/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleProjectTask;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.tooling.internal.gradle.DefaultGradleProject;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class GradleProjectBuilder
implements ToolingModelBuilder {
    @Override
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.GradleProject");
    }

    @Override
    public Object buildAll(String modelName, Project project) {
        return this.buildHierarchy(project.getRootProject());
    }

    public DefaultGradleProject buildAll(Project project) {
        return this.buildHierarchy(project.getRootProject());
    }

    private DefaultGradleProject<LaunchableGradleTask> buildHierarchy(Project project) {
        ArrayList<DefaultGradleProject<LaunchableGradleTask>> children = new ArrayList<DefaultGradleProject<LaunchableGradleTask>>();
        for (Project child : project.getChildProjects().values()) {
            children.add(this.buildHierarchy(child));
        }
        DefaultGradleProject<LaunchableGradleTask> gradleProject = new DefaultGradleProject().setProjectIdentifier(new DefaultProjectIdentifier(project.getRootDir(), project.getPath())).setName(project.getName()).setDescription(project.getDescription()).setBuildDirectory(project.getBuildDir()).setProjectDirectory(project.getProjectDir()).setChildren(children);
        gradleProject.getBuildScript().setSourceFile(project.getBuildFile());
        gradleProject.setTasks(GradleProjectBuilder.tasks(gradleProject, (TaskContainerInternal)project.getTasks()));
        for (DefaultGradleProject defaultGradleProject : children) {
            defaultGradleProject.setParent(gradleProject);
        }
        return gradleProject;
    }

    private static List<LaunchableGradleTask> tasks(DefaultGradleProject owner, TaskContainerInternal tasks) {
        tasks.realize();
        SortedSet<String> taskNames = tasks.getNames();
        ArrayList<LaunchableGradleTask> out = new ArrayList<LaunchableGradleTask>(taskNames.size());
        for (String taskName : taskNames) {
            Task t = (Task)tasks.findByName(taskName);
            if (t == null) continue;
            out.add(ToolingModelBuilderSupport.buildFromTask(new LaunchableGradleProjectTask(), t).setProject(owner).setProjectIdentifier(owner.getProjectIdentifier()));
        }
        return out;
    }
}

