/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.BuildIdentity;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdeArtifactStore;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.CollectionUtils;

public class DefaultIdeArtifactRegistry
implements IdeArtifactRegistry {
    private final IdeArtifactStore store;
    private final ProjectStateRegistry projectRegistry;
    private final FileOperations fileOperations;
    private final ProjectComponentIdentifier currentProject;

    public DefaultIdeArtifactRegistry(IdeArtifactStore store, ProjectStateRegistry projectRegistry, FileOperations fileOperations, DomainObjectContext domainObjectContext, BuildIdentity buildIdentity) {
        this.store = store;
        this.projectRegistry = projectRegistry;
        this.fileOperations = fileOperations;
        this.currentProject = projectRegistry.stateFor(buildIdentity.getCurrentBuild(), domainObjectContext.getProjectPath()).getComponentIdentifier();
    }

    @Override
    public void registerIdeProject(IdeProjectMetadata ideProjectMetadata) {
        this.store.put(this.currentProject, ideProjectMetadata);
    }

    @Override
    @Nullable
    public <T extends IdeProjectMetadata> T getIdeProject(Class<T> type, ProjectComponentIdentifier project) {
        ProjectState projectState = this.projectRegistry.stateFor(project);
        if (!projectState.getOwner().isImplicitBuild()) {
            for (IdeProjectMetadata ideProjectMetadata : this.store.get(project)) {
                if (!type.isInstance(ideProjectMetadata)) continue;
                return (T)((IdeProjectMetadata)type.cast(ideProjectMetadata));
            }
        }
        return null;
    }

    @Override
    public <T extends IdeProjectMetadata> List<IdeArtifactRegistry.Reference<T>> getIdeProjects(Class<T> type) {
        ArrayList result = Lists.newArrayList();
        BuildIdentifier currentBuild = this.currentProject.getBuild();
        for (ProjectState projectState : this.projectRegistry.getAllProjects()) {
            if (projectState.getOwner().isImplicitBuild()) continue;
            ProjectComponentIdentifier projectId = projectState.getComponentIdentifier();
            for (IdeProjectMetadata ideProjectMetadata : this.store.get(projectId)) {
                if (!type.isInstance(ideProjectMetadata)) continue;
                IdeProjectMetadata metadata = (IdeProjectMetadata)type.cast(ideProjectMetadata);
                if (projectId.getBuild().equals(currentBuild)) {
                    result.add(new MetadataFromThisBuild<IdeProjectMetadata>(metadata, projectId));
                    continue;
                }
                result.add(new MetadataFromOtherBuild<IdeProjectMetadata>(metadata, projectId));
            }
        }
        return result;
    }

    @Override
    public FileCollection getIdeProjectFiles(final Class<? extends IdeProjectMetadata> type) {
        return this.fileOperations.files(new Callable<List<FileCollection>>(){

            @Override
            public List<FileCollection> call() {
                return CollectionUtils.collect(DefaultIdeArtifactRegistry.this.getIdeProjects(type), new Transformer<FileCollection, IdeArtifactRegistry.Reference<?>>(){

                    @Override
                    public FileCollection transform(IdeArtifactRegistry.Reference<?> result) {
                        ConfigurableFileCollection singleton = DefaultIdeArtifactRegistry.this.fileOperations.files(result.get().getFile());
                        singleton.builtBy(result.getBuildDependencies());
                        return singleton;
                    }
                });
            }
        });
    }

    private static class MetadataFromOtherBuild<T extends IdeProjectMetadata>
    extends AbstractReference<T> {
        MetadataFromOtherBuild(T metadata, ProjectComponentIdentifier projectId) {
            super(metadata, projectId);
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return new AbstractTaskDependency(){

                @Override
                public void visitDependencies(TaskDependencyResolveContext context) {
                    for (Task task : MetadataFromOtherBuild.this.get().getGeneratorTasks()) {
                        context.add(new IncludedBuildTaskReference(MetadataFromOtherBuild.this.getOwningProject().getBuild(), task.getPath()));
                    }
                }
            };
        }
    }

    private static class MetadataFromThisBuild<T extends IdeProjectMetadata>
    extends AbstractReference<T> {
        MetadataFromThisBuild(T metadata, ProjectComponentIdentifier projectId) {
            super(metadata, projectId);
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return new AbstractTaskDependency(){

                @Override
                public void visitDependencies(TaskDependencyResolveContext context) {
                    for (Task task : MetadataFromThisBuild.this.get().getGeneratorTasks()) {
                        context.add(task);
                    }
                }
            };
        }
    }

    private static abstract class AbstractReference<T extends IdeProjectMetadata>
    implements IdeArtifactRegistry.Reference<T> {
        private final T metadata;
        private final ProjectComponentIdentifier projectId;

        AbstractReference(T metadata, ProjectComponentIdentifier projectId) {
            this.metadata = metadata;
            this.projectId = projectId;
        }

        @Override
        public T get() {
            return this.metadata;
        }

        @Override
        public ProjectComponentIdentifier getOwningProject() {
            return this.projectId;
        }
    }
}

