/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.scala.plugins.ScalaLanguagePlugin;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.GenerateIdeaProject;
import org.gradle.plugins.ide.idea.GenerateIdeaWorkspace;
import org.gradle.plugins.ide.idea.internal.IdeaModuleMetadata;
import org.gradle.plugins.ide.idea.internal.IdeaScalaConfigurer;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaModuleIml;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.plugins.ide.idea.model.IdeaWorkspace;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;
import org.gradle.util.SingleMessageLogger;

public class IdeaPlugin
extends IdePlugin {
    private static final Predicate<Project> HAS_IDEA_AND_JAVA_PLUGINS = new Predicate<Project>(){

        public boolean apply(Project project) {
            return project.getPlugins().hasPlugin(IdeaPlugin.class) && project.getPlugins().hasPlugin(JavaBasePlugin.class);
        }
    };
    public static final Function<Project, JavaVersion> SOURCE_COMPATIBILITY = new Function<Project, JavaVersion>(){

        public JavaVersion apply(Project p) {
            return p.getConvention().getPlugin(JavaPluginConvention.class).getSourceCompatibility();
        }
    };
    public static final Function<Project, JavaVersion> TARGET_COMPATIBILITY = new Function<Project, JavaVersion>(){

        public JavaVersion apply(Project p) {
            return p.getConvention().getPlugin(JavaPluginConvention.class).getTargetCompatibility();
        }
    };
    private final Instantiator instantiator;
    private IdeaModel ideaModel;
    private List<Project> allJavaProjects;
    private final UniqueProjectNameProvider uniqueProjectNameProvider;
    private final IdeArtifactRegistry artifactRegistry;
    private final ProjectStateRegistry projectPathRegistry;

    @Inject
    public IdeaPlugin(Instantiator instantiator, UniqueProjectNameProvider uniqueProjectNameProvider, IdeArtifactRegistry artifactRegistry, ProjectStateRegistry projectPathRegistry) {
        this.instantiator = instantiator;
        this.uniqueProjectNameProvider = uniqueProjectNameProvider;
        this.artifactRegistry = artifactRegistry;
        this.projectPathRegistry = projectPathRegistry;
    }

    public IdeaModel getModel() {
        return this.ideaModel;
    }

    @Override
    protected String getLifecycleTaskName() {
        return "idea";
    }

    @Override
    protected void onApply(Project project) {
        this.getLifecycleTask().setDescription("Generates IDEA project files (IML, IPR, IWS)");
        this.getCleanTask().setDescription("Cleans IDEA project files (IML, IPR)");
        this.ideaModel = project.getExtensions().create("idea", IdeaModel.class, new Object[0]);
        this.configureIdeaWorkspace(project);
        this.configureIdeaProject(project);
        this.configureIdeaModule((ProjectInternal)project);
        this.configureForJavaPlugin(project);
        this.configureForWarPlugin(project);
        this.configureForScalaPlugin();
        this.linkCompositeBuildDependencies((ProjectInternal)project);
    }

    @Deprecated
    public void performPostEvaluationActions() {
        SingleMessageLogger.nagUserOfDiscontinuedMethod("performPostEvaluationActions");
    }

    private void configureIdeaWorkspace(Project project) {
        if (this.isRoot()) {
            GenerateIdeaWorkspace task = project.getTasks().create("ideaWorkspace", GenerateIdeaWorkspace.class);
            task.setDescription("Generates an IDEA workspace file (IWS)");
            IdeaWorkspace workspace = new IdeaWorkspace();
            workspace.setIws(new XmlFileContentMerger(task.getXmlTransformer()));
            task.setWorkspace(workspace);
            this.ideaModel.setWorkspace(task.getWorkspace());
            task.setOutputFile(new File(project.getProjectDir(), project.getName() + ".iws"));
            this.addWorker(task, false);
        }
    }

    private void configureIdeaProject(final Project project) {
        if (this.isRoot()) {
            final GenerateIdeaProject projectTask = project.getTasks().create("ideaProject", GenerateIdeaProject.class);
            projectTask.setDescription("Generates IDEA project file (IPR)");
            XmlFileContentMerger ipr = new XmlFileContentMerger(projectTask.getXmlTransformer());
            IdeaProject ideaProject = this.instantiator.newInstance(IdeaProject.class, project, ipr);
            projectTask.setIdeaProject(ideaProject);
            this.ideaModel.setProject(ideaProject);
            ideaProject.setOutputFile(new File(project.getProjectDir(), project.getName() + ".ipr"));
            ConventionMapping conventionMapping = ((IConventionAware)((Object)ideaProject)).getConventionMapping();
            conventionMapping.map("jdkName", new Callable<String>(){

                @Override
                public String call() {
                    return JavaVersion.current().toString();
                }
            });
            conventionMapping.map("languageLevel", new Callable<IdeaLanguageLevel>(){

                @Override
                public IdeaLanguageLevel call() {
                    JavaVersion maxSourceCompatibility = IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)SOURCE_COMPATIBILITY);
                    return new IdeaLanguageLevel((Object)maxSourceCompatibility);
                }
            });
            conventionMapping.map("targetBytecodeVersion", new Callable<JavaVersion>(){

                @Override
                public JavaVersion call() {
                    return IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)TARGET_COMPATIBILITY);
                }
            });
            ideaProject.getWildcards().addAll(Arrays.asList("!?*.class", "!?*.scala", "!?*.groovy", "!?*.java"));
            conventionMapping.map("modules", new Callable<List<IdeaModule>>(){

                @Override
                public List<IdeaModule> call() {
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Sets.filter(project.getRootProject().getAllprojects(), (Predicate)new Predicate<Project>(){

                        public boolean apply(Project p) {
                            return p.getPlugins().hasPlugin(IdeaPlugin.class);
                        }
                    }), (Function)new Function<Project, IdeaModule>(){

                        public IdeaModule apply(Project p) {
                            return IdeaPlugin.ideaModelFor(p).getModule();
                        }
                    }));
                }
            });
            conventionMapping.map("pathFactory", new Callable<PathFactory>(){

                @Override
                public PathFactory call() {
                    return new PathFactory().addPathVariable("PROJECT_DIR", projectTask.getOutputFile().getParentFile());
                }
            });
            this.addWorker(projectTask);
            this.addWorkspace(ideaProject);
        }
    }

    private static IdeaModel ideaModelFor(Project project) {
        return project.getExtensions().getByType(IdeaModel.class);
    }

    private JavaVersion getMaxJavaModuleCompatibilityVersionFor(Function<Project, JavaVersion> toJavaVersion) {
        List<Project> allJavaProjects = this.getAllJavaProjects();
        if (allJavaProjects.isEmpty()) {
            return JavaVersion.VERSION_1_6;
        }
        return (JavaVersion)((Object)Collections.max(Lists.transform(allJavaProjects, toJavaVersion)));
    }

    private List<Project> getAllJavaProjects() {
        if (this.allJavaProjects != null) {
            return this.allJavaProjects;
        }
        this.allJavaProjects = Lists.newArrayList((Iterable)Iterables.filter(this.project.getRootProject().getAllprojects(), HAS_IDEA_AND_JAVA_PLUGINS));
        return this.allJavaProjects;
    }

    private void configureIdeaModule(final ProjectInternal project) {
        final GenerateIdeaModule task = project.getTasks().create("ideaModule", GenerateIdeaModule.class);
        task.setDescription("Generates IDEA module files (IML)");
        IdeaModuleIml iml = new IdeaModuleIml(task.getXmlTransformer(), project.getProjectDir());
        final IdeaModule module = this.instantiator.newInstance(IdeaModule.class, project, iml);
        task.setModule(module);
        this.ideaModel.setModule(module);
        String defaultModuleName = this.uniqueProjectNameProvider.getUniqueName(project);
        module.setName(defaultModuleName);
        ConventionMapping conventionMapping = ((IConventionAware)((Object)module)).getConventionMapping();
        conventionMapping.map("sourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return Sets.newLinkedHashSet();
            }
        });
        conventionMapping.map("contentRoot", new Callable<File>(){

            @Override
            public File call() {
                return project.getProjectDir();
            }
        });
        conventionMapping.map("testSourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return Sets.newLinkedHashSet();
            }
        });
        conventionMapping.map("resourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return Sets.newLinkedHashSet();
            }
        });
        conventionMapping.map("testResourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return Sets.newLinkedHashSet();
            }
        });
        conventionMapping.map("excludeDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                LinkedHashSet defaultExcludes = Sets.newLinkedHashSet();
                defaultExcludes.add(project.file(".gradle"));
                defaultExcludes.add(project.getBuildDir());
                return defaultExcludes;
            }
        });
        conventionMapping.map("pathFactory", new Callable<PathFactory>(){

            @Override
            public PathFactory call() {
                PathFactory factory = new PathFactory();
                factory.addPathVariable("MODULE_DIR", task.getOutputFile().getParentFile());
                for (Map.Entry<String, File> entry : module.getPathVariables().entrySet()) {
                    factory.addPathVariable(entry.getKey(), entry.getValue());
                }
                return factory;
            }
        });
        this.artifactRegistry.registerIdeProject(new IdeaModuleMetadata(module, task));
        this.addWorker(task);
    }

    private void configureForJavaPlugin(final Project project) {
        project.getPlugins().withType(JavaPlugin.class, new Action<JavaPlugin>(){

            @Override
            public void execute(JavaPlugin javaPlugin) {
                IdeaPlugin.this.configureIdeaModuleForJava(project);
            }
        });
    }

    private void configureForWarPlugin(final Project project) {
        project.getPlugins().withType(WarPlugin.class, new Action<WarPlugin>(){

            @Override
            public void execute(WarPlugin warPlugin) {
                IdeaPlugin.this.configureIdeaModuleForWar(project);
            }
        });
    }

    private void configureIdeaModuleForJava(final Project project) {
        project.getTasks().withType(GenerateIdeaModule.class, new Action<GenerateIdeaModule>(){

            @Override
            public void execute(GenerateIdeaModule ideaModule) {
                IdeaPlugin.this.setupScopes(ideaModule);
                ConventionMapping convention = ((IConventionAware)((Object)ideaModule.getModule())).getConventionMapping();
                convention.map("sourceDirs", new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("main")).getAllSource().getSrcDirs();
                    }
                });
                convention.map("testSourceDirs", new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("test")).getAllSource().getSrcDirs();
                    }
                });
                convention.map("resourceDirs", new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() throws Exception {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("main")).getResources().getSrcDirs();
                    }
                });
                convention.map("testResourceDirs", new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() throws Exception {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("test")).getResources().getSrcDirs();
                    }
                });
                convention.map("singleEntryLibraries", new Callable<Map<String, FileCollection>>(){

                    @Override
                    public Map<String, FileCollection> call() {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        LinkedHashMap<String, FileCollection> map = new LinkedHashMap<String, FileCollection>(2);
                        map.put("RUNTIME", ((SourceSet)sourceSets.getByName("main")).getOutput().getDirs());
                        map.put("TEST", ((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                        return map;
                    }
                });
                convention.map("targetBytecodeVersion", new Callable<JavaVersion>(){

                    @Override
                    public JavaVersion call() {
                        JavaVersion moduleTargetBytecodeLevel = project.getConvention().getPlugin(JavaPluginConvention.class).getTargetCompatibility();
                        return IdeaPlugin.includeModuleBytecodeLevelOverride(project.getRootProject(), moduleTargetBytecodeLevel) ? moduleTargetBytecodeLevel : null;
                    }
                });
                convention.map("languageLevel", new Callable<IdeaLanguageLevel>(){

                    @Override
                    public IdeaLanguageLevel call() {
                        IdeaLanguageLevel moduleLanguageLevel = new IdeaLanguageLevel((Object)project.getConvention().getPlugin(JavaPluginConvention.class).getSourceCompatibility());
                        return IdeaPlugin.includeModuleLanguageLevelOverride(project.getRootProject(), moduleLanguageLevel) ? moduleLanguageLevel : null;
                    }
                });
                ideaModule.dependsOn(new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("main")).getOutput().getDirs().plus(((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                    }
                });
            }
        });
    }

    private void setupScopes(GenerateIdeaModule ideaModule) {
        LinkedHashMap scopes = Maps.newLinkedHashMap();
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            LinkedHashMap plusMinus = Maps.newLinkedHashMap();
            plusMinus.put("plus", Lists.newArrayList());
            plusMinus.put("minus", Lists.newArrayList());
            scopes.put(scope.name(), plusMinus);
        }
        Project project = ideaModule.getProject();
        ConfigurationContainer configurations = project.getConfigurations();
        Collection provided = (Collection)((Map)scopes.get(GeneratedIdeaScope.PROVIDED.name())).get("plus");
        provided.add(configurations.getByName("compileClasspath"));
        Collection runtime = (Collection)((Map)scopes.get(GeneratedIdeaScope.RUNTIME.name())).get("plus");
        runtime.add(configurations.getByName("runtimeClasspath"));
        Collection test = (Collection)((Map)scopes.get(GeneratedIdeaScope.TEST.name())).get("plus");
        test.add(configurations.getByName("testCompileClasspath"));
        test.add(configurations.getByName("testRuntimeClasspath"));
        ideaModule.getModule().setScopes(scopes);
    }

    private void configureIdeaModuleForWar(final Project project) {
        project.getTasks().withType(GenerateIdeaModule.class, new Action<GenerateIdeaModule>(){

            @Override
            public void execute(GenerateIdeaModule ideaModule) {
                ConfigurationContainer configurations = project.getConfigurations();
                Configuration providedRuntime = configurations.getByName("providedRuntime");
                Collection<Configuration> providedPlus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.PROVIDED.name()).get("plus");
                providedPlus.add(providedRuntime);
                Collection<Configuration> runtimeMinus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.RUNTIME.name()).get("minus");
                runtimeMinus.add(providedRuntime);
                Collection<Configuration> testMinus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.TEST.name()).get("minus");
                testMinus.add(providedRuntime);
            }
        });
    }

    private static boolean includeModuleBytecodeLevelOverride(Project rootProject, JavaVersion moduleTargetBytecodeLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleTargetBytecodeLevel.equals((Object)ideaProject.getTargetBytecodeVersion());
    }

    private static boolean includeModuleLanguageLevelOverride(Project rootProject, IdeaLanguageLevel moduleLanguageLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleLanguageLevel.equals(ideaProject.getLanguageLevel());
    }

    private void configureForScalaPlugin() {
        this.project.getPlugins().withType(ScalaBasePlugin.class, new Action<ScalaBasePlugin>(){

            @Override
            public void execute(ScalaBasePlugin scalaBasePlugin) {
                IdeaPlugin.this.ideaModuleDependsOnRoot();
            }
        });
        this.project.getPlugins().withType(ScalaLanguagePlugin.class, new Action<ScalaLanguagePlugin>(){

            @Override
            public void execute(ScalaLanguagePlugin scalaLanguagePlugin) {
                IdeaPlugin.this.ideaModuleDependsOnRoot();
            }
        });
        if (this.isRoot()) {
            new IdeaScalaConfigurer(this.project).configure();
        }
    }

    private void ideaModuleDependsOnRoot() {
        ((Task)this.project.getTasks().findByName("ideaModule")).dependsOn(this.project.getRootProject().getTasks().findByName("ideaProject"));
    }

    private void linkCompositeBuildDependencies(final ProjectInternal project) {
        if (this.isRoot()) {
            this.getLifecycleTask().dependsOn(new Callable<List<TaskDependency>>(){

                @Override
                public List<TaskDependency> call() {
                    return IdeaPlugin.this.allImlArtifactsInComposite(project, IdeaPlugin.this.ideaModel.getProject());
                }
            });
        }
    }

    private List<TaskDependency> allImlArtifactsInComposite(ProjectInternal project, IdeaProject ideaProject) {
        ArrayList dependencies = Lists.newArrayList();
        ProjectComponentIdentifier thisProjectId = this.projectPathRegistry.stateFor(project).getComponentIdentifier();
        for (IdeArtifactRegistry.Reference<IdeaModuleMetadata> reference : this.artifactRegistry.getIdeProjects(IdeaModuleMetadata.class)) {
            BuildIdentifier otherBuildId = reference.getOwningProject().getBuild();
            if (thisProjectId.getBuild().equals(otherBuildId)) {
                boolean found = false;
                for (IdeaModule ideaModule : ideaProject.getModules()) {
                    if (!reference.get().getFile().equals(ideaModule.getOutputFile())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            dependencies.add(reference.getBuildDependencies());
        }
        return dependencies;
    }
}

