/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.EarPluginConvention;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;

public class EarPlugin
implements Plugin<Project> {
    public static final String EAR_TASK_NAME = "ear";
    public static final String DEPLOY_CONFIGURATION_NAME = "deploy";
    public static final String EARLIB_CONFIGURATION_NAME = "earlib";
    static final String DEFAULT_LIB_DIR_NAME = "lib";
    private final ObjectFactory objectFactory;
    private final FileResolver fileResolver;

    @Inject
    public EarPlugin(ObjectFactory objectFactory, FileResolver fileResolver) {
        this.objectFactory = objectFactory;
        this.fileResolver = fileResolver;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        EarPluginConvention earPluginConvention = this.objectFactory.newInstance(EarPluginConvention.class, this.fileResolver, this.objectFactory);
        project.getConvention().getPlugins().put(EAR_TASK_NAME, earPluginConvention);
        earPluginConvention.setLibDirName(DEFAULT_LIB_DIR_NAME);
        earPluginConvention.setAppDirName("src/main/application");
        this.wireEarTaskConventions(project, earPluginConvention);
        this.configureConfigurations(project);
        PluginContainer plugins = project.getPlugins();
        this.setupEarTask(project, earPluginConvention);
        this.configureWithJavaPluginApplied(project, earPluginConvention, plugins);
        this.configureWithNoJavaPluginApplied(project, earPluginConvention);
    }

    private void configureWithNoJavaPluginApplied(final Project project, final EarPluginConvention earPluginConvention) {
        project.getTasks().withType(Ear.class, new Action<Ear>(){

            @Override
            public void execute(Ear task) {
                task.from(new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        if (project.getPlugins().hasPlugin(JavaPlugin.class)) {
                            return null;
                        }
                        return project.fileTree(earPluginConvention.getAppDirName());
                    }
                });
            }
        });
    }

    private void configureWithJavaPluginApplied(final Project project, final EarPluginConvention earPluginConvention, PluginContainer plugins) {
        plugins.withType(JavaPlugin.class, new Action<JavaPlugin>(){

            @Override
            public void execute(JavaPlugin javaPlugin) {
                final JavaPluginConvention javaPluginConvention = project.getConvention().findPlugin(JavaPluginConvention.class);
                SourceSet sourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
                sourceSet.getResources().srcDir(new Callable(){

                    public Object call() throws Exception {
                        return earPluginConvention.getAppDirName();
                    }
                });
                project.getTasks().withType(Ear.class, new Action<Ear>(){

                    @Override
                    public void execute(Ear task) {
                        task.dependsOn(new Callable<FileCollection>(){

                            @Override
                            public FileCollection call() throws Exception {
                                return ((SourceSet)javaPluginConvention.getSourceSets().getByName("main")).getRuntimeClasspath();
                            }
                        });
                        task.from(new Callable<FileCollection>(){

                            @Override
                            public FileCollection call() throws Exception {
                                return ((SourceSet)javaPluginConvention.getSourceSets().getByName("main")).getOutput();
                            }
                        });
                    }
                });
            }
        });
    }

    private void setupEarTask(final Project project, EarPluginConvention convention) {
        Ear ear = project.getTasks().create(EAR_TASK_NAME, Ear.class);
        ear.setDescription("Generates a ear archive with all the modules, the application descriptor and the libraries.");
        DeploymentDescriptor deploymentDescriptor = convention.getDeploymentDescriptor();
        if (deploymentDescriptor != null) {
            if (deploymentDescriptor.getDisplayName() == null) {
                deploymentDescriptor.setDisplayName(project.getName());
            }
            if (deploymentDescriptor.getDescription() == null) {
                deploymentDescriptor.setDescription(project.getDescription());
            }
        }
        ear.setGroup("build");
        project.getExtensions().getByType(DefaultArtifactPublicationSet.class).addCandidate(new ArchivePublishArtifact(ear));
        project.getTasks().withType(Ear.class, new Action<Ear>(){

            @Override
            public void execute(Ear task) {
                task.getLib().from(new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.getConfigurations().getByName(EarPlugin.EARLIB_CONFIGURATION_NAME).minus(project.getConfigurations().getByName(EarPlugin.DEPLOY_CONFIGURATION_NAME));
                    }
                });
                task.from(new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.getConfigurations().getByName(EarPlugin.DEPLOY_CONFIGURATION_NAME);
                    }
                });
            }
        });
    }

    private void wireEarTaskConventions(Project project, final EarPluginConvention earConvention) {
        project.getTasks().withType(Ear.class, new Action<Ear>(){

            @Override
            public void execute(Ear task) {
                task.getConventionMapping().map("libDirName", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return earConvention.getLibDirName();
                    }
                });
                task.getConventionMapping().map("deploymentDescriptor", new Callable<DeploymentDescriptor>(){

                    @Override
                    public DeploymentDescriptor call() throws Exception {
                        return earConvention.getDeploymentDescriptor();
                    }
                });
            }
        });
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration moduleConfiguration = ((Configuration)configurations.create(DEPLOY_CONFIGURATION_NAME)).setVisible(false).setTransitive(false).setDescription("Classpath for deployable modules, not transitive.");
        Configuration earlibConfiguration = ((Configuration)configurations.create(EARLIB_CONFIGURATION_NAME)).setVisible(false).setDescription("Classpath for module dependencies.");
        configurations.getByName("default").extendsFrom(moduleConfiguration, earlibConfiguration);
    }
}

