/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.util.CollectionUtils;

@Incubating
public class PluginUnderTestMetadata
extends DefaultTask {
    public static final String IMPLEMENTATION_CLASSPATH_PROP_KEY = "implementation-classpath";
    public static final String METADATA_FILE_NAME = "plugin-under-test-metadata.properties";
    private FileCollection pluginClasspath;
    private File outputDirectory;

    @Classpath
    public FileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    public void setPluginClasspath(FileCollection pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @TaskAction
    public void generate() {
        Properties properties = new Properties();
        if (this.getPluginClasspath() != null && !this.getPluginClasspath().isEmpty()) {
            properties.setProperty(IMPLEMENTATION_CLASSPATH_PROP_KEY, this.implementationClasspath());
        }
        File outputFile = new File(this.getOutputDirectory(), METADATA_FILE_NAME);
        this.saveProperties(properties, outputFile);
    }

    private String implementationClasspath() {
        StringBuilder implementationClasspath = new StringBuilder();
        Joiner.on((String)File.pathSeparator).appendTo(implementationClasspath, this.getPaths());
        return implementationClasspath.toString();
    }

    private void saveProperties(Properties properties, File outputFile) {
        try {
            PropertiesUtils.store(properties, outputFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Input
    protected List<String> getPaths() {
        return CollectionUtils.collect(this.classpathFiles(), new Transformer<String, File>(){

            @Override
            public String transform(File file) {
                return file.getAbsolutePath().replaceAll("\\\\", "/");
            }
        });
    }

    private Iterable<File> classpathFiles() {
        if (this.getPluginClasspath() != null) {
            return this.getPluginClasspath();
        }
        return Collections.emptyList();
    }
}

