/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.DomainObjectCollectionBackedModelMap;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.inspect.AbstractExtractedModelRule;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ModelMapBasedRule;
import org.gradle.platform.base.plugins.BinaryBasePlugin;

public class BinaryTasksModelRuleExtractor
extends AbstractAnnotationDrivenComponentModelRuleExtractor<BinaryTasks> {
    private static final ModelType<BinarySpec> BINARY_SPEC = ModelType.of(BinarySpec.class);
    private static final ModelType<ITaskFactory> TASK_FACTORY = ModelType.of(ITaskFactory.class);
    private static final ModelType<Task> TASK = ModelType.of(Task.class);
    private static final ModelReference<BinaryContainer> BINARIES_CONTAINER = ModelReference.of("binaries", ModelType.of(BinaryContainer.class));

    @Override
    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        return this.createRegistration(ruleDefinition, context);
    }

    private <R, S extends BinarySpec> ExtractedModelRule createRegistration(MethodRuleDefinition<R, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector();
        this.verifyMethodSignature(dataCollector, ruleDefinition, problems);
        if (problems.hasProblems()) {
            return null;
        }
        ModelType binaryType = dataCollector.getParameterType(BINARY_SPEC);
        return new ExtractedBinaryTasksRule(ruleDefinition, binaryType);
    }

    private void verifyMethodSignature(AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector taskDataCollector, MethodRuleDefinition<?, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        this.validateIsVoidMethod(ruleDefinition, problems);
        this.visitSubject(taskDataCollector, ruleDefinition, TASK, problems);
        this.visitDependency(taskDataCollector, ruleDefinition, BINARY_SPEC, problems);
    }

    private static class ExtractedBinaryTasksRule<T extends BinarySpec>
    extends AbstractExtractedModelRule {
        private final ModelType<T> binaryType;

        public ExtractedBinaryTasksRule(MethodRuleDefinition<?, ?> ruleDefinition, ModelType<T> binaryType) {
            super(ruleDefinition);
            this.binaryType = binaryType;
        }

        @Override
        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            MethodRuleDefinition<?, ?> ruleDefinition = this.getRuleDefinition();
            BinaryTaskRule<T> binaryTaskRule = new BinaryTaskRule<T>(this.binaryType, ruleDefinition);
            final ModelAction binaryTaskAction = context.contextualize(binaryTaskRule);
            context.getRegistry().configure(ModelActionRole.Defaults, DirectNodeNoInputsModelAction.of(BINARIES_CONTAINER, ruleDefinition.getDescriptor(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

                @Override
                public void execute(MutableModelNode modelNode) {
                    modelNode.applyTo(NodePredicate.allLinks(), ModelActionRole.Finalize, binaryTaskAction);
                }
            }));
        }

        @Override
        public List<? extends Class<?>> getRuleDependencies() {
            return ImmutableList.of(BinaryBasePlugin.class);
        }
    }

    private static class BinaryTaskRule<T extends BinarySpec>
    extends ModelMapBasedRule<T, T> {
        public BinaryTaskRule(ModelType<T> binaryType, MethodRuleDefinition<?, ?> ruleDefinition) {
            super(ModelReference.of(binaryType), binaryType, ruleDefinition, ModelReference.of(TASK_FACTORY));
        }

        @Override
        protected void execute(ModelRuleInvoker<?> invoker, final T binary, List<ModelView<?>> inputs) {
            NamedEntityInstantiator taskFactory = (NamedEntityInstantiator)Cast.uncheckedCast(ModelViews.getInstance(inputs.get(0), TASK_FACTORY));
            DomainObjectCollectionBackedModelMap<Task> cast = DomainObjectCollectionBackedModelMap.wrap("tasks", Task.class, binary.getTasks(), taskFactory, new Task.Namer(), new Action<Task>(){

                @Override
                public void execute(Task task) {
                    binary.getTasks().add(task);
                    binary.builtBy(task);
                }
            });
            ArrayList inputsWithBinary = new ArrayList(inputs.size());
            inputsWithBinary.addAll(inputs.subList(1, inputs.size()));
            inputsWithBinary.add(InstanceModelView.of(this.getSubject().getPath(), this.getSubject().getType(), binary));
            this.invoke(invoker, inputsWithBinary, cast, binary, binary);
        }
    }
}

