/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift;

import java.io.File;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;
import org.gradle.util.GFileUtils;

public class IncrementalSwiftCompiler
implements Compiler<SwiftCompileSpec> {
    private final Compiler<SwiftCompileSpec> compiler;
    private final TaskOutputsInternal outputs;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;

    public IncrementalSwiftCompiler(Compiler<SwiftCompileSpec> compiler, TaskOutputsInternal outputs, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory) {
        this.compiler = compiler;
        this.outputs = outputs;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
    }

    @Override
    public WorkResult execute(SwiftCompileSpec spec) {
        boolean didRemove = spec.isIncrementalCompile() ? this.deleteOutputsForRemovedSources(spec) : this.cleanPreviousOutputs(spec);
        WorkResult compileResult = this.compile(spec);
        return WorkResults.didWork(didRemove || compileResult.getDidWork());
    }

    protected WorkResult compile(SwiftCompileSpec spec) {
        return this.compiler.execute(spec);
    }

    private boolean deleteOutputsForRemovedSources(SwiftCompileSpec spec) {
        boolean didRemove = false;
        for (File removedSource : spec.getRemovedSourceFiles()) {
            File objectFile = this.getObjectFile(spec.getObjectFileDir(), removedSource);
            if (!objectFile.delete()) continue;
            didRemove = true;
            GFileUtils.deleteDirectory(objectFile.getParentFile());
        }
        return didRemove;
    }

    private File getObjectFile(File objectFileRoot, File sourceFile) {
        return this.compilerOutputFileNamingSchemeFactory.create().withObjectFileNameSuffix(".o").withOutputBaseFolder(objectFileRoot).map(sourceFile);
    }

    private boolean cleanPreviousOutputs(SwiftCompileSpec spec) {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.outputs);
        cleaner.addDirToClean(spec.getObjectFileDir());
        cleaner.execute();
        return cleaner.getDidWork();
    }
}

